// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;

import fc.io.*;
import fc.util.*;

/** 
A container for a sequence of forms. 
<p>

@author hursh jain
**/
public class FormSequence 
{
Map sequence;
Map	doneMap;

public FormSequence()
	{
	sequence = new LinkedHashMap();	
	doneMap = new HashMap();
	}
	
/** 
Adds a form to the sequence 

@throws IllegalStateException 	if a form with the same name already
								exists in this sequence.						
**/
public void add(Form f) {
	Argcheck.notnull(f, "param f was null");
	sequence.put(f.getName(), f);
	doneMap.put(f.getName(), Boolean.valueOf(false));	
	}

/** specify <tt>true</tt> to mark the form as done**/
public void setDone(Form form, boolean done) 
	{
	Form f = (Form) sequence.get(form.getName());
	if (f == null) {
		return;
		}
	doneMap.put(form.getName(), Boolean.valueOf(done));	
	}

/** 
@return <tt>true</tt> is the specified form is marked
		as done.
**/
public boolean isDone(Form f) 
	{
	if (! sequence.containsKey(f.getName()) )
		return false;
	
	Boolean b = (Boolean) doneMap.get(f.getName());	
	return b.booleanValue();
	}

/** 
Returns the form with the specified name or <tt>null</tt> 
if a form with that name does not exist
**/
public Form get(String name) {
	return (Form) sequence.get(name);
	}

/** 
@return the first form which is still not done or <tt>null</tt>
		if none are remaining to be done.
**/
public Form getFirstRemaining() 
	{
	Form f = null;
	Iterator it = sequence.values().iterator();
	while (it.hasNext()) {
		f = (Form) it.next();
		if (! isDone(f) ) {
			break;
			}
		}	
	return f;
	}

/**
@return <tt>true</tt> is all forms in the sequence are
		marked as done <tt>false</tt> otherwise. Also 
		returns <tt>false</tt> if this sequence contains
		no forms at all.
**/
public boolean isFinished() {
	return getFirstRemaining() == null; 
	}
	
}          