// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.web.forms;

import jakarta.servlet.*;
import jakarta.servlet.http.*;
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.sql.*;

/**
Refreshes the value of a field (or fields) before the field is displayed
to the user. Refreshed values are typically retrieved from a database.
*/
public abstract class FieldRefresher
{
Field field;  //set by target field when added to it

/**
Refresh the value of the field. The new values are request specific (and
each HTTP request handler thread will update the values for that request
independent of other requests). The values should be stored in the
supplied form data object by invoking field methods that look like:
<tt>setValue(<i>FormData fd</i>,....)</tt>.
<p>
It is possible for the specified form data to be <tt>null</tt>. 

@param	fd		the form data object, possibly <tt>null</tt> if there
				is no submit data.
*/
public abstract void refresh(FormData fd) throws IOException, SQLException;

/**
There must be a way to figure out if the client hacked/delete/modified the
form before submitting it. Since the rendered values are different per
request, we cannot rely on values that the target field was constructed
with. This method is conceptually similar to a {@link
Dependency#isSubmitDataValid} method.

This method can be implemented to check the submitted values and return
<tt>true</tt> if the submit was valid, <tt>false</tt> otherwise.
<p>
The default implementation always returns <tt>true</tt>. 
*/
public boolean isSubmitValid(FormData fd) { 
	return true;
	}

public String toString() {
	return "[Refresher: " + field.name + "]";
	}
}
