// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;
//Obsolete with the intro of jdk 1.5 java.util.Q

/**
A thin wrapper around a java collection that provides queue semantics (FIFO).
**/
public class Queue extends LinkedList
{
public Queue() {
	super();
	}
	
public Queue(Collection c) {
	super(c);
	}
	
/** 
Enqueue's the specified object. Behaves as per {@link java.util.Collection#add(Object)} 
**/
public boolean enque(Object obj) {
	return add(obj);
	}

/** 
Dequeues an object from the beginning of the queue 

@throws NoSuchElementException	if this list is empty.
**/
public Object deque() {
	return removeFirst();
	}

/** Returns <tt>true</tt> is this queue is empty, <tt>false</tt> otherwise**/
public boolean empty() {
	return size() == 0;
	}

public static void main(String[] args) 
	{
	Queue q = new Queue();
	q.enque("hello");
	q.enque("world");
	System.out.println("q="+ q);
	//DO NOT PUT "n < q.size()" in the loop, because with every deque
	//the SIZE CHANGES (and the loop won't work properly).
	
	//method 1: take a snapshot
	/*
	int size = q.size();  	//<--the snapshot	
	for(int n = 0; n < size; n++) {
		System.out.println("deque["+n+"]="+q.deque());
 		}
	*/
	
	//method 2: use empty()
	while (! q.empty())
		System.out.println(q.deque());

	System.out.println("This should throw an Exception");
	q.deque();
	}

}          //~class Queue
