// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.io.*;
import java.net.*;
import java.util.*;

import fc.io.*;

/**
Network related utils (including HTTP) (the servlet/WebUtil class is for servlet specific utils)
*/
public final class NetUtil
{
/* 
Downloads and saves data from url to specified file. The file should be a
complete file (including directory information) and the name of the file can
of course be arbitrary. (construct a file with the same name as the url if
you need to save the url as-is, with the same name).
*/
public static void downloadAndSaveImage(File output, String url) throws IOException
	{
	URL u = new URL(url);
	InputStream in = u.openStream();
	BufferedInputStream bin = new BufferedInputStream(in);

	final int buffer_size = 2056;
	final byte[] buf = new byte[buffer_size];

	OutputStream bout = new BufferedOutputStream(
									new FileOutputStream(output), buffer_size);

	int read = 0;
	while (true) {
		read = bin.read(buf, 0, buffer_size);	
		if (read == -1) {
			break;	
			}
		bout.write(buf, 0, read);
		}

	bout.flush();
	bout.close();
	}

/*
Returns true if the specified resource exists, false otherwise.

Uses HTTP HEAD method and a return code != 404
*/
public static boolean resourceExists(String url) 
	{
	boolean exists = false;
	try {
		URL u = new URL(url);
		HttpURLConnection hc = (HttpURLConnection) u.openConnection();
		hc.setRequestMethod("HEAD");
		hc.connect();
		int code = hc.getResponseCode();
		exists = code == HttpURLConnection.HTTP_OK;  //http code 200
		}
	catch (Exception e) {
		Log.getDefault().error(IOUtil.throwableToString(e));
		}
		
	return exists;
	}


public static void main (String args[])
	{
	Args myargs = new Args(args);
	myargs.setUsage("-url <url to check exists>");
	
	String url = myargs.getRequired("url");
	System.out.println("exists: " + resourceExists(url));
	}
	
}

