// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.util;

import java.util.*;
import java.io.*;
import fc.io.*;
import java.util.regex.*;

/**
Misc. utils
*/
public final class MiscUtil
{
public static final String java_keywords[] = {
	"abstract", "assert", "boolean", "break", "byte", "case", "catch",
	"char", "class", "const", "continue", "default", "do", "double",
	"else", "extends", "false", "final", "finally", "float", "for",
	"goto", "if", "implements", "import", "instanceof", "int",
	"interface", "long", "native", "new", "null", "package", "private",
	"protected", "public", "return", "short", "static", "strictfp",
	"super", "switch", "synchronized", "this", "throw", "throws",
	"transient", "true", "try", "void", "volatile", "while" 
	};

/** 
Returns true if the specified word is a Java Language Keyword. Keywords (and hence this comparison) are case sensitive, upper case versions of these are ok in Java. 
*/
public static boolean isJavaKeyword(String word) {
	return (Arrays.binarySearch(java_keywords, word) >= 0);
	}
	

/**
Returns the number of columns in the terminal - if this program is invoked from a Terminal.
<p>
Returns -1 if not a terminal or terminal size cannot be found
*/
public static int getTerminalColumnCount()
	{
	int cols = -1;
	try {
		/*
		; columns 145;  //linux
		; 145 columns;  //os x
		*/
	
		ProcessBuilder pb = new ProcessBuilder("stty", "-a");
		pb.redirectErrorStream(true);
		pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
		Process p = pb.start();
		InputStream is = p.getInputStream();
		String s = IOUtil.inputStreamToString(is);
		//System.out.println("got:----------------\n" + s);
		//System.out.println("----------------\n");
	
		Pattern pat = Pattern.compile("\\s+(\\d+)\\s+columns\\s*|\\s*columns\\s+(\\d+)");
		Matcher m = pat.matcher(s);
		if (m.find()) 
			{
	//		System.out.println("group 1: " + m.group(1));   //first group	
	//		System.out.println("group 2: " + m.group(2));	//second group
			if (m.group(1) != null) {
				cols = Integer.parseInt(m.group(1));
				}
			else if (m.group(2) != null) {
				cols = Integer.parseInt(m.group(2));
				}
			}
		//System.out.println(col);
		}
	catch (Exception e) { 
		}
	
	return cols;
	}
	

public static void main (String args[])
	{
	Args myargs = new Args(args);
	System.out.println(isJavaKeyword(myargs.getRequired("word")));
	System.out.println("Terminal columns: " + getTerminalColumnCount());
	}
	
}

