// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.jdbc;

import fc.util.*;

/**
Enumerates database names. Useful for methods that must be customized for
each type of database.

@author hursh jain
*/
public final class DBName
{
/* IMPORTANT:
When more names are added, the fromDriver() method MUST ALSO BE UPDATED */
/* The singleton DBName class corresponding to mysql. */
public static final DBName mysql 	= new DBName("mysql");

/* The singleton DBName class corresponding to postgres. */
public static final DBName postgres = new DBName("postgresql");

/* The singleton DBName class corresponding to oracel. */
public static final DBName oracle 	= new DBName("oracle");

private String name;
private DBName(String name) { this.name = name;}

/**
Returns the DBName corresponding to the specified jdbc driver or
<tt>null</tt> if the jdbc driver could not be parsed.

@param	driver_name		a jdbc driver name such as
						<tt>com.mysql.jdbc.Driver</tt> or
						<tt>org.postgresql.Driver</tt>
*/
public static DBName fromDriver(String driver_name) 
	{
	driver_name = driver_name.toLowerCase();
	Argcheck.notnull(driver_name, "the specified driver_name was null");

	if (driver_name.indexOf(mysql.name.toLowerCase()) >= 0)
		return mysql;
	else if (driver_name.indexOf(postgres.name.toLowerCase()) >= 0)
		return postgres;
	else if (driver_name.indexOf(oracle.name.toLowerCase()) >=0 )
		return oracle;
	else 
		return null;
	}


public String toString() { return name; }

public static void main(String args[]) 
	{
	Args myargs = new Args(args);
	myargs.setUsage("java fc.jdbc.DBName -fromDriver driver-name ");

	if (! myargs.flagExists("fromDriver"))
		{
		myargs.showError();	
		}
	
	String driver = myargs.get("fromDriver");
	if (driver != null) {
		System.out.println("dbname=" + DBName.fromDriver(driver));
		}
	}
}