// Copyright (c) 2001 Hursh Jain (http://www.mollypages.org) 
// The Molly framework is freely distributable under the terms of an
// MIT-style license. For details, see the molly pages web site at:
// http://www.mollypages.org/. Use, modify, have fun !

package fc.io;

import java.io.*;

/**
Used to transform log messages by adding more information such as 
date/time stamps etc. 

@author 	hursh jain
@version 	1.0, 10/19/2001
@see     	fc.io.Logger
**/
public interface ILogFilter
{

/**
Implementations can add logging information to log messages in the 
transform method.
@param  caller  reference to the client object which originally called the log method.
				Can be passed null if called from a static method.
@param  thread	reference to the calling thread (needed it we want to automatically
				write information about that thread in a filter).
@param	buf 	StringBuffer representing a log message.
**/
public void transform(Object caller, Thread callingThread, StringBuffer buf);
}          