/*
 * Decompiled with CFR 0.152.
 */
package fc.web.servlet;

import fc.io.IOUtil;
import fc.io.Log;
import fc.jdbc.ConnectionMgr;
import fc.jdbc.PooledConnectionMgr;
import fc.jdbc.QueryUtil;
import fc.util.FilePropertyMgr;
import fc.util.PropertyMgr;
import fc.util.ThreadLocalCalendar;
import fc.util.ThreadLocalDateFormat;
import fc.util.ThreadLocalNumberFormat;
import fc.util.ThreadLocalObject;
import fc.util.ThreadLocalRandom;
import fc.util.ToString;
import fc.util.cache.Cache;
import fc.util.cache.MemoryCache;
import fc.web.forms.Form;
import fc.web.servlet.WebUtil;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebApp
implements ServletContextListener {
    public Map connectionManagers = new HashMap();
    public ConnectionMgr defaultConnectionManager;
    public long default_dbcache_time = 120000L;
    public ThreadLocalCalendar default_tlcal;
    public ThreadLocalDateFormat default_tldf;
    public ThreadLocalNumberFormat default_tlnf;
    public ThreadLocalRandom default_tlrand;
    public Map appMap = new Hashtable();
    public Map tlcalMap = new Hashtable();
    public Map tldfMap = new Hashtable();
    public Map tlnfMap = new Hashtable();
    public Map tlrandMap = new Hashtable();
    public Map tlMap = new Hashtable();
    public Log appLog;
    public PropertyMgr propertyMgr;
    long cache_time;
    protected String appName;
    public Map allServletsMap = new HashMap();
    private static Map<String, WebApp> instances = new HashMap<String, WebApp>();
    private static Set autoDestroySet = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebApp getInstance(String string) {
        Class<WebApp> clazz = WebApp.class;
        synchronized (WebApp.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instances.get(string);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            String string = WebUtil.getRequiredParam(servletContext, "appName");
            String string2 = WebUtil.getRequiredParam(servletContext, "configfile");
            WebApp.addWebAppImpl(servletContext, string, string2, this);
        }
        catch (ServletException servletException) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("**** ERROR: exception in " + this.getClass().getName() + " *****");
            System.err.println("**** Shutting down the Web Server ****");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.flush();
            servletException.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.appLog.info("WebApp [", this.appName, "] closing at: ", new Date());
        this.cleanup(this.appName);
        ServletContext servletContext = servletContextEvent.getServletContext();
        String string = null;
        try {
            string = WebUtil.getRequiredParam(servletContext, "appName");
            if (!this.appName.equals(string)) {
                System.err.println("Weird, appName (" + this.appName + ") and context.appName(" + string + ") were different");
                this.cleanup(string);
            }
        }
        catch (Exception exception) {
            IOUtil.throwableToString(exception);
        }
        Iterator iterator = autoDestroySet.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            this.cleanup(string2);
            iterator.remove();
        }
    }

    private void cleanup(String string) {
        WebApp webApp = instances.remove(string);
        if (webApp == null) {
            return;
        }
        for (ConnectionMgr connectionMgr : webApp.connectionManagers.values()) {
            connectionMgr.close();
        }
    }

    public static WebApp addWebApp(ServletContext servletContext, String string, String string2) {
        WebApp webApp = new WebApp();
        WebApp.addWebAppImpl(servletContext, string, string2, webApp);
        autoDestroySet.add(string);
        return webApp;
    }

    private static void addWebAppImpl(ServletContext servletContext, String string, String string2, WebApp webApp) {
        Date date = Calendar.getInstance().getTime();
        System.out.println("*******************************************************************");
        System.out.println("fc.web.servlet.WebApp: starting initialization on: " + String.valueOf(date));
        System.out.println("WebApp running at: " + servletContext.getRealPath(""));
        System.out.println("*******************************************************************");
        try {
            Object object;
            Log log;
            if (instances.containsKey(string)) {
                System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                String string3 = "A webapp with name[" + string + "] at context [" + servletContext.getRealPath(servletContext.getContextPath()) + "] already exists..";
                System.err.println(string3);
                throw new RuntimeException(string3);
            }
            webApp.appName = string;
            webApp.appLog = log = Log.get(string);
            File file = new File(string2);
            System.out.println("-> WebApp: Configuration file: " + file.getPath());
            if (!file.isAbsolute()) {
                file = new File(servletContext.getRealPath("/WEB-INF"), file.getPath());
            }
            FilePropertyMgr filePropertyMgr = new FilePropertyMgr(file);
            webApp.propertyMgr = filePropertyMgr;
            System.out.println("-> WebApp: " + String.valueOf(filePropertyMgr));
            String string4 = filePropertyMgr.get("log.level", null);
            if (string4 != null) {
                log.setLevel(string4);
                Log.setDefaultLevel(string4);
            }
            Object var9_11 = null;
            String string5 = ((PropertyMgr)filePropertyMgr).get("db.default");
            webApp.appLog.info("WebApp: Default database = ", string5 == null ? "Not specified" : string5);
            String string6 = ((PropertyMgr)filePropertyMgr).get("db.list");
            webApp.appLog.info("WebApp: All databases: ", string6 == null ? "None specified" : string6);
            if (string6 == null) {
                if (string5 != null) {
                    throw new IllegalArgumentException("Since a default database was specified, a dblist must also be specified (but was null)");
                }
            } else {
                for (String string7 : object = string6.split(",")) {
                    string7 = string7.trim();
                    String string8 = ((PropertyMgr)filePropertyMgr).get(string7 + ".pool.size");
                    String string9 = ((PropertyMgr)filePropertyMgr).get(string7 + ".jdbc.url");
                    String string10 = ((PropertyMgr)filePropertyMgr).get(string7 + ".jdbc.driver");
                    String string11 = ((PropertyMgr)filePropertyMgr).get(string7 + ".jdbc.user");
                    String string12 = ((PropertyMgr)filePropertyMgr).get(string7 + ".jdbc.password");
                    String string13 = filePropertyMgr.get(string7 + ".jdbc.catalog", "");
                    PooledConnectionMgr pooledConnectionMgr = new PooledConnectionMgr(string9, string10, string11, string12, string13, Integer.parseInt(string8));
                    webApp.connectionManagers.put(string7, pooledConnectionMgr);
                    if (!string7.equalsIgnoreCase(string5)) continue;
                    webApp.defaultConnectionManager = pooledConnectionMgr;
                }
            }
            webApp.cache_time = (object = ((PropertyMgr)filePropertyMgr).get("db.cache_time_seconds")) != null ? Long.parseLong((String)object) * 1000L : webApp.default_dbcache_time;
            log.info("WebApp: db.cache_time = ", webApp.cache_time / 1000L, " seconds");
            QueryUtil.init(log);
            instances.put(string, webApp);
            System.out.println("===> WebApp finished [success]");
            System.out.println("*******************************************************************\n");
        }
        catch (Exception exception) {
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.println("**** ERROR: exception in " + webApp.getClass().getName() + " *****");
            System.err.println("**** Shutting down the Web Server ****");
            System.err.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.err.flush();
            exception.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public PropertyMgr getPropertyMgr() {
        return this.propertyMgr;
    }

    public ConnectionMgr getConnectionMgr(String string) {
        ConnectionMgr connectionMgr = (ConnectionMgr)this.connectionManagers.get(string);
        if (connectionMgr == null) {
            throw new IllegalArgumentException("The specified connectionManager [" + string + "] does not exist or has not been initialized.");
        }
        return connectionMgr;
    }

    public ConnectionMgr getConnectionMgr() {
        return this.defaultConnectionManager;
    }

    public Connection getConnection(String string) throws SQLException {
        return this.getConnectionMgr(string).getConnection();
    }

    public Connection getConnection() throws SQLException {
        if (this.defaultConnectionManager == null) {
            throw new SQLException("The ConnectionManager in " + String.valueOf(WebApp.class) + " does not have \"default\" DB. Specify a DB name to get a connection to that DB.");
        }
        return this.defaultConnectionManager.getConnection();
    }

    public Log getAppLog() {
        return this.appLog;
    }

    public Form getForm(String string) {
        return (Form)this.appMap.get(string);
    }

    public void putForm(Form form) {
        this.appMap.put(form.getName(), form);
    }

    public void removeForm(String string) {
        if (this.appMap.containsKey(string)) {
            this.appMap.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache getDBCache() {
        Object v = this.appMap.get("_dbcache");
        if (v != null) {
            return (Cache)v;
        }
        MemoryCache memoryCache = null;
        Class<WebApp> clazz = WebApp.class;
        synchronized (WebApp.class) {
            memoryCache = new MemoryCache(Log.get("fc.util.cache"), "_dbcache", this.cache_time);
            this.appMap.put("_dbcache", memoryCache);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return memoryCache;
        }
    }

    public ThreadLocalDateFormat getThreadLocalDateFormat(String string) {
        ThreadLocalDateFormat threadLocalDateFormat = (ThreadLocalDateFormat)this.tldfMap.get(string);
        if (threadLocalDateFormat == null) {
            threadLocalDateFormat = new ThreadLocalDateFormat();
            this.tldfMap.put(string, threadLocalDateFormat);
        }
        return threadLocalDateFormat;
    }

    public ThreadLocalDateFormat getThreadLocalDateFormat() {
        if (this.default_tldf == null) {
            this.default_tldf = new ThreadLocalDateFormat();
        }
        return this.default_tldf;
    }

    public ThreadLocalNumberFormat getThreadLocalNumberFormat(String string) {
        ThreadLocalNumberFormat threadLocalNumberFormat = (ThreadLocalNumberFormat)this.tlnfMap.get(string);
        if (threadLocalNumberFormat == null) {
            threadLocalNumberFormat = new ThreadLocalNumberFormat();
            this.tlnfMap.put(string, threadLocalNumberFormat);
        }
        return threadLocalNumberFormat;
    }

    public ThreadLocalNumberFormat getThreadLocalNumberFormat() {
        if (this.default_tlnf == null) {
            this.default_tlnf = new ThreadLocalNumberFormat();
        }
        return this.default_tlnf;
    }

    public ThreadLocalCalendar getThreadLocalCalendar(String string) {
        ThreadLocalCalendar threadLocalCalendar = (ThreadLocalCalendar)this.tlcalMap.get(string);
        if (threadLocalCalendar == null) {
            threadLocalCalendar = new ThreadLocalCalendar();
            this.tlcalMap.put(string, threadLocalCalendar);
        }
        return threadLocalCalendar;
    }

    public ThreadLocalCalendar getThreadLocalCalendar() {
        if (this.default_tlcal == null) {
            this.default_tlcal = new ThreadLocalCalendar();
        }
        return this.default_tlcal;
    }

    public ThreadLocalRandom getThreadLocalRandom(String string) {
        ThreadLocalRandom threadLocalRandom = (ThreadLocalRandom)this.tlrandMap.get(string);
        if (threadLocalRandom == null) {
            threadLocalRandom = new ThreadLocalRandom();
            this.tlrandMap.put(string, threadLocalRandom);
        }
        return threadLocalRandom;
    }

    public ThreadLocalRandom getThreadLocalRandom() {
        if (this.default_tlrand == null) {
            this.default_tlrand = new ThreadLocalRandom();
        }
        return this.default_tlrand;
    }

    public ThreadLocalObject getThreadLocalObject(String string) {
        ThreadLocalObject threadLocalObject = (ThreadLocalObject)this.tlMap.get(string);
        if (threadLocalObject == null) {
            threadLocalObject = new ThreadLocalObject();
            this.tlMap.put(string, threadLocalObject);
        }
        return threadLocalObject;
    }

    public Object get(Object object) {
        return this.appMap.get(object);
    }

    public void put(Object object, Object object2) {
        this.appMap.put(object, object2);
    }

    public String toString() {
        return new ToString(this).reflect().render();
    }
}

