/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.IOUtil;
import fc.web.page.Page;
import fc.web.page.PageMgr;
import fc.web.servlet.FCBaseServlet;
import fc.web.servlet.WebUtil;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;

public class PageServlet
extends FCBaseServlet {
    private static final boolean dbg = false;
    PageMgr pagemgr;
    String error_page;
    String page_404;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        try {
            ServletContext servletContext = servletConfig.getServletContext();
            PageServlet pageServlet = this;
            synchronized (pageServlet) {
                String string = servletContext.getRealPath("/");
                if (string == null) {
                    throw new UnavailableException("docroot == null, so I ask you, what can I do ?");
                }
                File file = new File(string);
                if (!file.exists()) {
                    throw new UnavailableException("docroot " + String.valueOf(file) + " does not exist...so I ask you, what can I do ?");
                }
                File file2 = null;
                if (this.pagemgr == null) {
                    file2 = new File(String.valueOf(file) + File.separator + "WEB-INF" + File.separator + "molly_tmp");
                    if (!file2.exists()) {
                        file2.mkdirs();
                    }
                    this.pagemgr = new PageMgr(this, file, file2, this.log);
                }
                this.error_page = WebUtil.getParam((Servlet)this, "error_page", null);
                this.page_404 = WebUtil.getParam((Servlet)this, "404_page", null);
                this.log.info("PageServlet init() finished");
                this.log.info("Document root=", file);
                this.log.info("Scratch root=", file2);
                this.log.info("Error page=", this.error_page);
                this.log.info("404   page=", this.page_404);
            }
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getServletPath();
        if (string == null) {
            throw new ServletException("Don't know how to handle this request, servletpath was null");
        }
        try {
            Page page;
            String string2 = (String)httpServletRequest.getAttribute("jakarta.servlet.include.servlet_path");
            if (string2 != null) {
                string = string2;
            }
            if ((page = this.pagemgr.getPage(string)) == null) {
                if (this.page_404 == null) {
                    throw new ServletException("Molly page:" + string + " not found.");
                }
                WebUtil.clientRedirect(httpServletRequest, httpServletResponse, this.page_404);
                return;
            }
            page.render(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            if (httpServletResponse.isCommitted() && this.error_page != null) {
                httpServletRequest.setAttribute("jakarta.servlet.error.status_code", (Object)500);
                httpServletRequest.setAttribute("jakarta.servlet.error.exception", (Object)exception);
                httpServletRequest.setAttribute("jakarta.servlet.error.request_uri", (Object)string);
                httpServletRequest.setAttribute("jakarta.servlet.error.servlet_name", (Object)"Molly Page Servlet");
                RequestDispatcher requestDispatcher = httpServletRequest.getRequestDispatcher(this.error_page);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                return;
            }
            ServletException servletException = new ServletException(exception.toString());
            servletException.setStackTrace(exception.getStackTrace());
            throw servletException;
        }
    }

    @Override
    public String toString() {
        return "Scrumptious and delicious Page Servlet ! (See: www.mollypages.org)";
    }

    @Override
    public void destroy() {
        try {
            this.pagemgr.destroy();
            this.pagemgr = null;
            super.destroy();
        }
        catch (Exception exception) {
            System.out.println(IOUtil.throwableToString(exception));
        }
    }
}

