/*
 * Decompiled with CFR 0.152.
 */
package fc.web.page;

import fc.io.Log;
import fc.util.Watch;
import fc.web.page.Page;
import fc.web.page.PageServlet;
import fc.web.servlet.WebUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

public class PageImpl
implements Page {
    private static final boolean internal_dbg = false;
    public Log log;
    protected HttpServlet servlet;
    private static ThreadLocal watchMap = new ThreadLocal();
    private final ThreadLocal threadLocalOut = new ThreadLocal();
    private String dbg_prefix = "";
    private String dbg_suffix = "";
    protected volatile boolean dbg = false;

    @Override
    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        throw new ServletException("This page is not implemented");
    }

    @Override
    public void init(PageServlet pageServlet, String string) throws ServletException {
        this.log = Log.get(string);
        this.servlet = pageServlet;
    }

    @Override
    public void destroy() {
        this.log.close();
    }

    @Override
    public String getPagePath(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getContextPath() + httpServletRequest.getServletPath();
    }

    @Override
    public String getRealPath(HttpServletRequest httpServletRequest) {
        return this.servlet.getServletConfig().getServletContext().getRealPath(this.getPagePath(httpServletRequest));
    }

    @Override
    public void clientRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException {
        String string2 = WebUtil.absolutePath(httpServletRequest, string);
        httpServletResponse.sendRedirect(string2);
    }

    @Override
    public CharArrayWriter getThreadLocalWriter() {
        CharArrayWriter charArrayWriter = (CharArrayWriter)this.threadLocalOut.get();
        if (charArrayWriter == null) {
            charArrayWriter = new CharArrayWriter();
            this.threadLocalOut.set(charArrayWriter);
        }
        return charArrayWriter;
    }

    public final void startTimer() {
        Watch watch = this.getWatch();
        if (watch == null) {
            watch = new Watch();
            watchMap.set(watch);
        }
        watch.start();
    }

    public final long getTime() {
        Watch watch = this.getWatch();
        if (watch == null) {
            throw new RuntimeException("The startTimer() method must be invoked prior to invoking this method. Timers are thread local different processing threads get their own private timers. You must startTimer() and getTime() inside the render method, don't override the init() method to startTimer()..");
        }
        return watch.time();
    }

    private final Watch getWatch() {
        return (Watch)watchMap.get();
    }

    public final void dbg(boolean bl) {
        this.dbg = bl;
    }

    public final void dbgPrefix(String string) {
        this.dbg_prefix = string;
    }

    public final void dbgSuffix(String string) {
        this.dbg_suffix = string;
    }

    public final void bug(Writer writer, Object object) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(this.dbg_prefix);
        writer.append(object != null ? object.toString() : "null");
        writer.append(this.dbg_suffix);
    }

    public final void bug(Writer writer, Object object, Object object2) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(this.dbg_prefix);
        writer.append(object != null ? object.toString() : "null");
        writer.append(object2 != null ? object2.toString() : "null");
        writer.append(this.dbg_suffix);
    }

    public final void bug(Writer writer, Object object, Object object2, Object object3) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(this.dbg_prefix);
        writer.append(object != null ? object.toString() : "null");
        writer.append(object2 != null ? object2.toString() : "null");
        writer.append(object3 != null ? object3.toString() : "null");
        writer.append(this.dbg_suffix);
    }

    public final void bug(Writer writer, Object object, Object object2, Object object3, Object ... objectArray) throws IOException {
        if (!this.dbg) {
            return;
        }
        writer.append(this.dbg_prefix);
        writer.append(object != null ? object.toString() : "null");
        writer.append(object2 != null ? object2.toString() : "null");
        writer.append(object3 != null ? object3.toString() : "null");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            writer.append(objectArray[i] != null ? objectArray[i].toString() : "null");
        }
        writer.append(this.dbg_suffix);
    }

    public final void debug(Writer writer, Object object) throws IOException {
        this.bug(writer, object);
    }

    public final void debug(Writer writer, Object object, Object object2) throws IOException {
        this.bug(writer, object, object2);
    }

    public final void debug(Writer writer, Object object, Object object2, Object object3) throws IOException {
        this.bug(writer, object, object2, object3);
    }

    public final void debug(Writer writer, Object object, Object object2, Object object3, Object ... objectArray) throws IOException {
        this.bug(writer, object, object2, object3, objectArray);
    }
}

