/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.util.StringUtil;
import fc.web.forms.AbstractText;
import fc.web.forms.FieldValidator;
import fc.web.forms.FormData;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VText
extends FieldValidator {
    static final boolean dbg = false;
    boolean checkLength = false;
    boolean checkUnallowedChars = false;
    boolean checkAllowedChars = false;
    boolean checkAllowedPat = false;
    boolean allowEmpty = true;
    boolean trim = false;
    boolean intOnly = false;
    boolean floatOnly = false;
    int minlength;
    int maxlength;
    String unallowedChars;
    String allowedChars;
    Pattern allowedPat;
    private static final String intOnlyRE = "\\s*\\d*\\s*";
    private static final String floatOnlyRE = "\\s*-?\\d*\\.?\\d*\\s*";

    public VText(AbstractText abstractText, String string) {
        super(abstractText, string);
    }

    public void trimSpaces(boolean bl) {
        this.trim = bl;
    }

    public VText allowEmpty(boolean bl) {
        this.allowEmpty = bl;
        return this;
    }

    public VText allowIntegersOnly() {
        this.setAllowedPattern(Pattern.compile(intOnlyRE));
        this.intOnly = true;
        return this;
    }

    public VText allowFloatingOnly() {
        this.setAllowedPattern(Pattern.compile(floatOnlyRE));
        this.floatOnly = true;
        return this;
    }

    public VText setLengthRange(int n, int n2) {
        this.minlength = n;
        this.maxlength = n2;
        this.checkLength = true;
        return this;
    }

    public VText setMaxSize(int n) {
        return this.setLengthRange(0, n);
    }

    public VText setMinSize(int n) {
        return this.setLengthRange(n, Integer.MAX_VALUE);
    }

    public VText setUnallowedChars(String string) {
        Argcheck.notnull(string, "specified param 'chars' was null");
        this.unallowedChars = string;
        this.checkUnallowedChars = true;
        this.checkAllowedPat = false;
        return this;
    }

    public VText setAllowedChars(String string) {
        Argcheck.notnull(string, "specified param 'chars' was null");
        this.allowedChars = string;
        this.checkAllowedChars = true;
        this.checkAllowedPat = false;
        return this;
    }

    public VText setAllowedPattern(Pattern pattern) {
        Argcheck.notnull(pattern, "specified param 'pat' was null");
        this.allowedPat = pattern;
        this.checkAllowedPat = true;
        this.checkAllowedChars = false;
        this.intOnly = false;
        this.floatOnly = false;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        stringBuffer.append("VText(");
        if (this.checkLength) {
            stringBuffer.append("Len=[");
            stringBuffer.append(this.minlength);
            stringBuffer.append("-");
            stringBuffer.append(this.maxlength);
            stringBuffer.append("]");
            stringBuffer.append(", ");
        }
        if (this.checkUnallowedChars) {
            stringBuffer.append("Unallowed=");
            stringBuffer.append(this.unallowedChars);
            stringBuffer.append(", ");
        }
        if (this.checkAllowedChars) {
            stringBuffer.append("Allowed=");
            stringBuffer.append(this.allowedChars);
            stringBuffer.append(", ");
        }
        if (this.checkAllowedPat) {
            if (this.intOnly) {
                stringBuffer.append("ints only");
            } else if (this.floatOnly) {
                stringBuffer.append("floats only");
            } else {
                stringBuffer.append("Pattern=");
                stringBuffer.append(StringUtil.viewableAscii(this.allowedPat.pattern()));
            }
            stringBuffer.append(", ");
        }
        if (this.trim) {
            stringBuffer.append("Trim=true");
            stringBuffer.append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public boolean validate(FormData formData, HttpServletRequest httpServletRequest) {
        String string = ((AbstractText)this.field).getValue(formData);
        if (string == null) {
            return this.allowEmpty;
        }
        if (this.trim) {
            string = string.trim();
        }
        if (this.allowEmpty && this.isEmpty(string)) {
            return true;
        }
        if (!this.allowEmpty && this.isEmpty(string)) {
            return false;
        }
        boolean bl = true;
        if (this.checkLength && bl) {
            bl = this.checkLength(string);
        }
        if (this.checkUnallowedChars && bl) {
            bl = this.checkUnallowedChars(string);
        }
        if (this.checkAllowedChars && bl) {
            bl = this.checkAllowedChars(string);
        }
        if (this.checkAllowedPat && bl) {
            bl = this.checkAllowedPat(string);
        }
        return bl;
    }

    final boolean isEmpty(String string) {
        return string.length() == 0;
    }

    final boolean checkLength(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        return n >= this.minlength && n <= this.maxlength;
    }

    final boolean checkAllowedChars(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < this.allowedChars.length(); ++j) {
                char c2 = this.allowedChars.charAt(j);
                if (c != c2) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    final boolean checkUnallowedChars(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        block0: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            for (int j = 0; j < this.unallowedChars.length(); ++j) {
                char c2 = this.unallowedChars.charAt(j);
                if (c != c2) continue;
                bl = true;
                continue block0;
            }
        }
        return !bl;
    }

    final boolean checkAllowedPat(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = this.allowedPat.matcher(string);
        return matcher.matches();
    }
}

