/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.web.forms.Field;
import fc.web.forms.FormData;
import fc.web.forms.SubmitHackedException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;

public final class Hidden
extends Field {
    static String[] empty_arr = new String[]{""};
    String[] orig_values;
    boolean dynamicallyAdded = false;

    public Hidden(String string) {
        this(string, "");
    }

    public Hidden(String string, String string2) {
        super(string);
        if (string2 == null) {
            string2 = "";
        }
        this.orig_values = new String[]{string2};
    }

    public Hidden(String string, int n) {
        super(string);
        this.orig_values = new String[]{String.valueOf(n)};
    }

    public Hidden(String string, String[] stringArray) {
        super(string);
        if (stringArray == null) {
            log.warn("Specified values were null, defaulting to \"\"");
            this.orig_values = empty_arr;
        } else {
            this.orig_values = stringArray;
        }
    }

    public Hidden(String string, List list) {
        super(string);
        if (list == null) {
            log.warn("Specified values were null, defaulting to \"\"");
            this.orig_values = empty_arr;
        } else {
            int n = list.size();
            this.orig_values = new String[n];
            for (int i = 0; i < n; ++i) {
                this.orig_values[i] = list.get(i).toString();
            }
        }
    }

    @Override
    public Field.Type getType() {
        return Field.Type.HIDDEN;
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws IOException {
        String[] stringArray = this.getRenderValues(formData);
        for (int i = 0; i < stringArray.length; ++i) {
            writer.write("<input type='");
            writer.write(this.getType().toString());
            writer.write("' name='");
            writer.write(this.name);
            writer.write("'");
            if (stringArray != null) {
                writer.write(" value='");
                writer.write(stringArray[i]);
                writer.write("'");
            }
            int n = this.arbitraryString.size();
            for (int j = 0; j < n; ++j) {
                writer.write(" ");
                writer.write(this.arbitraryString.get(j).toString());
            }
            writer.write("></input>\n");
        }
    }

    public String getValue(FormData formData) {
        if (this.dynamicallyAdded) {
            return this.orig_values[0];
        }
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        return data.values[0];
    }

    public String[] getValues(FormData formData) {
        if (this.dynamicallyAdded) {
            return this.orig_values;
        }
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        return data.values;
    }

    public String getStringValue(FormData formData) {
        String string = this.getValue(formData);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public int getIntValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Integer.parseInt(string);
    }

    public short getShortValue(FormData formData) {
        String string = this.getValue(formData);
        if (string != null) {
            string = string.trim();
        }
        return Short.parseShort(string);
    }

    public boolean getBooleanValue(FormData formData) {
        return Boolean.valueOf(this.getValue(formData));
    }

    String[] getRenderValues(FormData formData) {
        if (this.dynamicallyAdded) {
            return this.orig_values;
        }
        if (formData != null) {
            Data data = (Data)formData.getData(this.name);
            if (data == null) {
                return empty_arr;
            }
            return data.values;
        }
        return this.orig_values;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) throws SubmitHackedException {
        String[] stringArray = httpServletRequest.getParameterValues(this.name);
        if (stringArray == null) {
            if (!this.enabled || !this.isEnabled(formData)) {
                this.hacklert(httpServletRequest, "Bug/hack alert: did not find [" + this.name + "] field in the request (but expected to), defaulting to original values");
            }
            stringArray = empty_arr;
        }
        Data data = new Data();
        formData.putData(this.name, data);
        data.values = stringArray;
    }

    public void setValue(String[] stringArray) {
        if (stringArray == null) {
            log.warn("specified values param was null, defaulting to \"\"");
            stringArray = empty_arr;
        }
        this.orig_values = stringArray;
    }

    public void setValue(String string) {
        if (string == null) {
            log.warn("specified values param was null, defaulting to \"\"");
            string = "";
        }
        this.orig_values = new String[]{string};
    }

    @Override
    public boolean isFilled(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return false;
        }
        String[] stringArray = data.values;
        if (stringArray == null) {
            log.error("Internal error: unexpected state");
        }
        return true;
    }

    public void reset(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        data.values = this.orig_values;
    }

    @Override
    public String toString() {
        return super.toString() + "; Orig. value: [" + Arrays.toString(this.orig_values) + "]";
    }

    static final class Data {
        String[] values;

        Data() {
        }
    }
}

