/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.io.Log;
import fc.util.ToString;
import fc.web.forms.Field;
import fc.web.forms.Hidden;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FormData {
    List formValidateErrorsList;
    Map formValidateErrorsMap;
    Map fieldValidateErrors;
    Map fieldValues;
    Set disabledFields;
    Map dynamicFields;
    boolean dependencyUpdated = false;
    Log log;
    Connection connection;
    Map messages;
    Map validatedData;

    public FormData(Log log) {
        this.log = log;
        this.fieldValues = new HashMap();
        this.formValidateErrorsList = new ArrayList();
        this.formValidateErrorsMap = new HashMap();
        this.fieldValidateErrors = new HashMap();
        this.disabledFields = new HashSet();
    }

    public FormData() {
        this(Log.getDefault());
    }

    List createFieldErrorList(Field field) {
        String string = field.name;
        ArrayList arrayList = (ArrayList)this.fieldValidateErrors.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.fieldValidateErrors.put(string, arrayList);
        }
        return arrayList;
    }

    Map getFieldErrors() {
        return this.fieldValidateErrors;
    }

    List getFieldErrors(Field field) {
        return (List)this.fieldValidateErrors.get(field.name);
    }

    void addFormError(String string, String string2) {
        this.formValidateErrorsList.add(string2);
        if (string != null) {
            ArrayList<String> arrayList = (ArrayList<String>)this.formValidateErrorsMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                this.formValidateErrorsMap.put(string, arrayList);
            }
            arrayList.add(string2);
        }
    }

    Collection getFormErrorsCollection() {
        return this.formValidateErrorsList;
    }

    Map getFormErrorsMap() {
        return this.formValidateErrorsMap;
    }

    void putData(String string, Object object) {
        this.fieldValues.put(string, object);
    }

    void setData(String string, Object object) {
        this.fieldValues.put(string, object);
    }

    Object getData(String string) {
        return this.fieldValues.get(string);
    }

    void enableField(String string, boolean bl) {
        if (bl) {
            if (this.disabledFields.remove(string)) {
                // empty if block
            }
        } else {
            this.disabledFields.add(string);
        }
    }

    boolean isEnabled(String string) {
        return !this.disabledFields.contains(string);
    }

    void addMessage(String string, String string2) {
        if (this.messages == null) {
            this.messages = new HashMap();
        }
        this.messages.put(string, string2);
    }

    String getMessage(String string) {
        if (this.messages == null || !this.messages.containsKey(string)) {
            return "";
        }
        return (String)this.messages.get(string);
    }

    public void putValidatedData(String string, Object object) {
        if (this.validatedData == null) {
            this.validatedData = new HashMap();
        }
        this.validatedData.put(string, object);
    }

    public Object getValidatedData(String string) {
        return this.validatedData.get(string);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void addDynamicField(Hidden hidden) {
        if (this.dynamicFields == null) {
            this.dynamicFields = new HashMap();
        }
        hidden.dynamicallyAdded = true;
        this.dynamicFields.put(hidden.getName(), hidden);
    }

    public Hidden getDynamicField(String string) {
        if (this.dynamicFields == null) {
            this.log.warn("Cannot obtain field:", string, " from this formdata. This field is only available after being added to the formdata and is lost when the formdata object is lost, typically after the form is rendered.");
            return null;
        }
        return (Hidden)this.dynamicFields.get(string);
    }

    public void setDependencyUpdated() {
        this.dependencyUpdated = true;
    }

    public String toString() {
        return new ToString((Object)this, ToString.Style.VisibleLevel.PRIVATE).reflect().render();
    }
}

