/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.io.IOUtil;
import fc.io.Log;
import fc.io.TablePrinter;
import fc.util.Argcheck;
import fc.util.StringUtil;
import fc.web.forms.Checkbox;
import fc.web.forms.CheckboxGroup;
import fc.web.forms.Dependency;
import fc.web.forms.DependencyException;
import fc.web.forms.Field;
import fc.web.forms.FieldRef;
import fc.web.forms.FieldValidator;
import fc.web.forms.FormData;
import fc.web.forms.FormValidator;
import fc.web.forms.Hidden;
import fc.web.forms.Password;
import fc.web.forms.Radio;
import fc.web.forms.RadioGroup;
import fc.web.forms.RefreshableSelect;
import fc.web.forms.Select;
import fc.web.forms.SubmitHackedException;
import fc.web.forms.SubmitHackedHandler;
import fc.web.forms.Text;
import fc.web.forms.TextArea;
import fc.web.forms.VText;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;

public class Form {
    public static final List empty_list = Collections.unmodifiableList(new ArrayList());
    public static final Map empty_map = Collections.unmodifiableMap(new HashMap());
    protected Log log;
    protected LinkedHashMap fields;
    protected LinkedHashMap fieldRef;
    protected LinkedHashMap formValidators;
    protected List dependencies;
    protected String name;
    protected String method;
    protected String actionURL;
    protected String displayURL;
    protected Timer timer;
    protected SubmitHackedHandler hackHandler;

    public Form(String string, String string2, String string3, Log log, SubmitHackedHandler submitHackedHandler) {
        this.name = string;
        this.method = string2;
        this.actionURL = string3;
        this.fields = new LinkedHashMap();
        this.fieldRef = new LinkedHashMap();
        this.formValidators = new LinkedHashMap();
        this.dependencies = new ArrayList();
        this.log = log;
        this.hackHandler = submitHackedHandler;
        if (submitHackedHandler == null) {
            this.hackHandler = new SubmitHackedHandler(this);
        }
    }

    public Form(String string, String string2, String string3, Log log) {
        this(string, string2, string3, log, null);
    }

    public Form(String string, String string2, String string3) {
        this(string, string2, string3, Log.getDefault(), null);
    }

    public Form(String string) {
        this(string, "post", null);
    }

    public void destroy() {
        this.timer.cancel();
        this.fields.clear();
    }

    public Object remove(Field field) {
        return this.fields.remove(field.getName());
    }

    public Form add(Field field) {
        String string = field.getName();
        if (this.fields.containsKey(string)) {
            throw new IllegalArgumentException("A form element by that name [" + string + "] already exists");
        }
        this.fields.put(string, field);
        field.setParentForm(this);
        return this;
    }

    public Form add(Dependency dependency) {
        this.dependencies.add(dependency);
        return this;
    }

    public Form add(FieldRef fieldRef) {
        String string = fieldRef.getName();
        if (this.fieldRef.containsKey(string)) {
            throw new IllegalArgumentException("A fieldRef by that name [" + string + "] already exists");
        }
        this.fieldRef.put(string, fieldRef);
        return this;
    }

    public void addError(FormData formData, String string, String string2) {
        formData.addFormError(string, string2);
    }

    public void addError(FormData formData, String string) {
        this.addError(formData, null, string);
    }

    public void addDynamicField(FormData formData, Hidden hidden) {
        formData.addDynamicField(hidden);
    }

    public void addValidator(FormValidator formValidator) {
        String string = formValidator.getName();
        if (this.formValidators.containsKey(string)) {
            throw new IllegalArgumentException("A validator by that name [" + string + "] already exists in this form");
        }
        this.formValidators.put(string, formValidator);
    }

    public void addMessage(FormData formData, String string, String string2) {
        formData.addMessage(string, string2);
    }

    public boolean containsField(String string) {
        return this.fields.containsKey(string);
    }

    public String getMessage(FormData formData, String string) {
        if (formData == null) {
            return null;
        }
        return formData.getMessage(string);
    }

    public void addSubmitHackedHandler(SubmitHackedHandler submitHackedHandler) {
        Argcheck.notnull(submitHackedHandler, "handler param was null");
        this.hackHandler = submitHackedHandler;
    }

    protected void handleSubmitHacked(HttpServletRequest httpServletRequest, String string) throws SubmitHackedException {
        this.hackHandler.handle(httpServletRequest, string);
    }

    public FormData handleSubmit(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        return this.handleSubmit(httpServletRequest, null);
    }

    public FormData handleSubmit(HttpServletRequest httpServletRequest, Connection connection) throws ServletException, IOException {
        FormData formData = this.populate(httpServletRequest);
        if (connection != null) {
            formData.setConnection(connection);
        }
        this.updateDependencies(formData, httpServletRequest);
        if (!formData.dependencyUpdated) {
            this.validate(formData, httpServletRequest);
        }
        return formData;
    }

    public FormData refresh(HttpServletRequest httpServletRequest) throws ServletException, IOException {
        return this.refresh(httpServletRequest, null);
    }

    public FormData refresh(HttpServletRequest httpServletRequest, Connection connection) throws ServletException, IOException {
        FormData formData = this.populate(httpServletRequest);
        if (connection != null) {
            formData.setConnection(connection);
        }
        this.updateDependencies(formData, httpServletRequest);
        return formData;
    }

    protected FormData populate(HttpServletRequest httpServletRequest) throws SubmitHackedException {
        FormData formData = new FormData();
        for (Map.Entry entry : this.fields.entrySet()) {
            Field field = (Field)entry.getValue();
            field.setValueFromSubmit(formData, httpServletRequest);
        }
        return formData;
    }

    protected void updateDependencies(FormData formData, HttpServletRequest httpServletRequest) throws DependencyException {
        for (int i = 0; i < this.dependencies.size(); ++i) {
            Dependency dependency = (Dependency)this.dependencies.get(i);
            dependency.updateValues(formData, httpServletRequest);
        }
    }

    protected boolean validate(FormData formData, HttpServletRequest httpServletRequest) {
        boolean bl = true;
        Map map = formData.getFieldErrors();
        Field field2 = null;
        Iterator iterator = null;
        for (FormValidator formValidator : this.formValidators.values()) {
            if (formValidator.validate(formData, httpServletRequest)) continue;
            bl = false;
            String string = formValidator.getErrorMessage();
            String string2 = formValidator.getName();
            this.log.bug("Group validate error: ", string2, string);
            formData.addFormError(string2, string);
        }
        for (Field field2 : this.fields.values()) {
            if (!field2.isEnabled(formData) || field2.validate(formData, httpServletRequest)) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean hasError(FormData formData) {
        if (formData == null) {
            return false;
        }
        return formData.getFormErrorsCollection().size() > 0 || formData.getFieldErrors().size() > 0;
    }

    public void renderError(FormData formData, Writer writer) throws IOException {
        if (formData == null) {
            return;
        }
        Collection collection = formData.getFormErrorsCollection();
        int n = collection.size();
        if (n == 0) {
            return;
        }
        writer.write("<div class='form-errmsg'>\n");
        for (String string : collection) {
            if (string == null) continue;
            writer.write("<div class='form-errmsg-item'>");
            writer.write(string);
            writer.write("</div>\n");
        }
        writer.write("</div>\n");
    }

    public void renderErrorFor(FormData formData, Writer writer, String string) throws IOException {
        if (formData == null) {
            return;
        }
        List list = this.getFormErrorsFor(formData, string);
        int n = list.size();
        if (n == 0) {
            return;
        }
        writer.write("<div class='form-errmsg'>\n");
        for (String string2 : list) {
            if (string2 == null) continue;
            writer.write("<div class='form-errmsg-item'>");
            writer.write(string2);
            writer.write("</div>\n");
        }
        writer.write("</div>\n");
    }

    public Map getFieldErrors(FormData formData) {
        return formData.getFieldErrors();
    }

    public Collection getFormErrorsCollection(FormData formData) {
        return formData.getFormErrorsCollection();
    }

    public List getFormErrorsFor(FormData formData, String string) {
        Map map = formData.getFormErrorsMap();
        List list = (List)map.get(string);
        if (list == null) {
            return empty_list;
        }
        return list;
    }

    public void renderDynamicFields(FormData formData, Writer writer) throws SQLException, IOException {
        if (formData == null || formData.dynamicFields == null) {
            return;
        }
        for (Hidden hidden : formData.dynamicFields.values()) {
            hidden.render(writer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setActionURL(String string) {
        this.actionURL = string;
    }

    public String getActionURL() {
        return this.actionURL;
    }

    public void setDisplayURL(String string) {
        this.displayURL = string;
    }

    public String getDisplayURL() {
        return this.displayURL;
    }

    public Collection getAllFields() {
        return this.fields.values();
    }

    public Field get(String string) {
        Field field = (Field)this.fields.get(string);
        if (field == null) {
            this.log.warn("Tried to obtain a non-existent field from the form. Did you add a field with this name to the form ? Fieldname: [", string, "]");
        }
        return field;
    }

    public Hidden getDynamicField(FormData formData, String string) {
        if (formData == null) {
            return null;
        }
        return formData.getDynamicField(string);
    }

    public Hidden getSubmittedField(HttpServletRequest httpServletRequest, String string) {
        String string2 = httpServletRequest.getParameter(string);
        if (string2 == null) {
            string2 = "";
        }
        Hidden hidden = new Hidden(string, string2);
        hidden.dynamicallyAdded = true;
        return hidden;
    }

    public List getContaining(String string) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : this.fields.values()) {
            if (field.getName().indexOf(string) < 0) continue;
            arrayList.add(field);
        }
        return arrayList;
    }

    public FieldRef getFieldRef(String string) {
        return (FieldRef)this.fieldRef.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer() {
        Form form = this;
        synchronized (form) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
        }
        return this.timer;
    }

    public Select getSelect(String string) {
        return (Select)this.get(string);
    }

    public RefreshableSelect getUpdatableSelect(String string) {
        return (RefreshableSelect)this.get(string);
    }

    public Checkbox getCheckbox(String string) {
        return (Checkbox)this.get(string);
    }

    public CheckboxGroup getCheckboxGroup(String string) {
        return (CheckboxGroup)this.get(string);
    }

    public Hidden getHidden(String string) {
        return (Hidden)this.get(string);
    }

    public Text getText(String string) {
        return (Text)this.get(string);
    }

    public TextArea getTextArea(String string) {
        return (TextArea)this.get(string);
    }

    public Password getPassword(String string) {
        return (Password)this.get(string);
    }

    public Radio getRadio(String string) {
        return (Radio)this.get(string);
    }

    public RadioGroup getRadioGroup(String string) {
        return (RadioGroup)this.get(string);
    }

    public String toString() {
        Iterator<Object> iterator;
        Object object;
        Object object22;
        String string = IOUtil.LINE_SEP;
        int n = this.formValidators.size();
        int n2 = this.fieldRef.size();
        StringBuffer stringBuffer = new StringBuffer(256);
        StringBuffer stringBuffer2 = null;
        stringBuffer.append(string);
        stringBuffer.append(StringUtil.repeat('-', 70));
        stringBuffer.append(string).append("Form Name: ").append(this.name).append(" [").append(this.fields.size()).append(" Fields]").append(" [").append(n).append(" FormValidators]").append(" [").append(n2).append(" FieldRefs]");
        if (this.timer != null) {
            stringBuffer.append(" [Attached Timer: ").append(this.timer).append(" ]");
        }
        stringBuffer.append(string);
        ByteArrayOutputStream byteArrayOutputStream = null;
        TablePrinter.PrintConfig printConfig = null;
        TablePrinter tablePrinter = null;
        byteArrayOutputStream = new ByteArrayOutputStream(2048);
        printConfig = new TablePrinter.PrintConfig();
        printConfig.setPrintBorders(false);
        printConfig.setCellSpacing(1);
        printConfig.setCellPadding(0);
        printConfig.setAutoFit(true);
        tablePrinter = new TablePrinter(3, new PrintStream(byteArrayOutputStream), printConfig);
        tablePrinter.startTable();
        tablePrinter.startRow();
        tablePrinter.printCell("FIELD");
        tablePrinter.printCell("TYPE");
        tablePrinter.printCell("FIELD_VALIDATORS");
        tablePrinter.endRow();
        for (Object object22 : this.fields.values()) {
            tablePrinter.startRow();
            tablePrinter.printCell(((Field)object22).getName());
            tablePrinter.printCell(((Field)object22).getType().toString());
            object = ((Field)object22).getValidators();
            int n3 = object.size();
            if (n3 == 0) {
                tablePrinter.printCell("-");
            } else {
                stringBuffer2 = new StringBuffer(256);
                for (int i = 0; i < n3; ++i) {
                    FieldValidator fieldValidator;
                    if (i != 0) {
                        stringBuffer2.append(", ");
                    }
                    if ((fieldValidator = (FieldValidator)object.get(i)) instanceof VText) {
                        stringBuffer2.append(fieldValidator);
                        continue;
                    }
                    String string2 = fieldValidator.getClass().getName();
                    stringBuffer2.append(string2.substring(string2.lastIndexOf(".") + 1, string2.length()));
                }
                tablePrinter.printCell(stringBuffer2.toString());
            }
            tablePrinter.endRow();
        }
        tablePrinter.endTable();
        stringBuffer.append(byteArrayOutputStream.toString());
        if (n > 0) {
            stringBuffer.append(string);
            byteArrayOutputStream.reset();
            printConfig = new TablePrinter.PrintConfig();
            printConfig.setPrintBorders(false);
            printConfig.setCellSpacing(1);
            printConfig.setCellPadding(0);
            printConfig.setAutoFit(true);
            tablePrinter = new TablePrinter(1, new PrintStream(byteArrayOutputStream), printConfig);
            tablePrinter.startTable();
            tablePrinter.startRow();
            tablePrinter.printCell("Form-Validators....");
            tablePrinter.endRow();
            iterator = this.formValidators.entrySet().iterator();
            while (iterator.hasNext()) {
                tablePrinter.startRow();
                object22 = (Map.Entry)iterator.next();
                object = (String)object22.getKey();
                stringBuffer2 = new StringBuffer(stringBuffer2.length() + 2);
                stringBuffer2.append("\t");
                stringBuffer2.append((String)object);
                tablePrinter.printCell(stringBuffer2.toString());
                tablePrinter.endRow();
            }
            tablePrinter.endTable();
            stringBuffer.append(byteArrayOutputStream.toString());
        }
        if (n2 > 0) {
            stringBuffer.append(string);
            byteArrayOutputStream.reset();
            printConfig = new TablePrinter.PrintConfig();
            printConfig.setPrintBorders(false);
            printConfig.setCellSpacing(1);
            printConfig.setCellPadding(0);
            printConfig.setAutoFit(true);
            tablePrinter = new TablePrinter(2, new PrintStream(byteArrayOutputStream), printConfig);
            tablePrinter.startTable();
            tablePrinter.startRow();
            tablePrinter.printCell("Field References....");
            tablePrinter.printCell("");
            tablePrinter.endRow();
            iterator = this.fieldRef.values().iterator();
            while (iterator.hasNext()) {
                tablePrinter.startRow();
                object22 = (FieldRef)iterator.next();
                stringBuffer2 = new StringBuffer(stringBuffer2.length() + 2);
                stringBuffer2.append("\t");
                stringBuffer2.append(((FieldRef)object22).getName());
                tablePrinter.printCell(stringBuffer2.toString());
                stringBuffer2 = new StringBuffer(128);
                if (((FieldRef)object22).getList() != null) {
                    stringBuffer2.append(((FieldRef)object22).getList().size());
                    stringBuffer2.append(" fields");
                } else if (((FieldRef)object22).getMap() != null) {
                    stringBuffer2.append(((FieldRef)object22).getMap().size());
                    stringBuffer2.append(" fields");
                } else {
                    stringBuffer2.append(((FieldRef)object22).getObject());
                }
                tablePrinter.printCell(stringBuffer2.toString());
                tablePrinter.endRow();
            }
            tablePrinter.endTable();
            stringBuffer.append(byteArrayOutputStream.toString());
        }
        stringBuffer.append(StringUtil.repeat('-', 70));
        return stringBuffer.toString();
    }
}

