/*
 * Decompiled with CFR 0.152.
 */
package fc.web.forms;

import fc.util.Argcheck;
import fc.util.ToString;
import fc.web.forms.DependentField;
import fc.web.forms.Field;
import fc.web.forms.Form;
import fc.web.forms.FormData;
import fc.web.forms.Select;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DependentSelect
extends DependentField {
    public DependentSelect(String string) {
        super(string);
    }

    @Override
    public Field.Type getType() {
        return Field.Type.SELECT;
    }

    public List getValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null || data.selectedList == null) {
            return Form.empty_list;
        }
        return data.selectedList;
    }

    public String getStringValue(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return null;
        }
        List list = data.selectedList;
        if (list == null || list.size() == 0) {
            return null;
        }
        Select.Option option = (Select.Option)list.get(0);
        return option.getValue();
    }

    public int getIntValue(FormData formData) {
        return Integer.parseInt(this.getStringValue(formData));
    }

    public boolean getBooleanValue(FormData formData) {
        return Boolean.valueOf(this.getStringValue(formData));
    }

    @Override
    public boolean isFilled(FormData formData) {
        if (formData == null) {
            return false;
        }
        Data data = (Data)formData.getData(this.name);
        if (data == null) {
            return false;
        }
        List list = data.selectedList;
        return list != null && list.size() != 0;
    }

    @Override
    public void setValueFromSubmit(FormData formData, HttpServletRequest httpServletRequest) {
        this.dependency.setDependencyDataFromSubmit(formData, httpServletRequest);
        String[] stringArray = httpServletRequest.getParameterValues(this.name);
        Data data = new Data();
        formData.putData(this.name, data);
        if (stringArray == null) {
            return;
        }
        data.selectedMap = new HashMap();
        data.selectedList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            Select.Option option = new Select.Option(stringArray[i]);
            data.selectedMap.put(option.getValue(), option);
            data.selectedList.add(option);
        }
    }

    @Override
    public void renderImpl(FormData formData, Writer writer) throws SQLException, IOException {
        Data data = null;
        if (formData == null) {
            data = (Data)this.dependency.getInitialValues(this);
        } else {
            data = (Data)formData.getData(this.name);
            if (data == null) {
                data = (Data)this.dependency.getInitialValues(this);
            }
        }
        Argcheck.notnull(data, "Internal error: unexpected state, data was null");
        writer.write("<select");
        writer.write(" name='");
        writer.write(this.name);
        writer.write("'");
        if (data.size > 0) {
            writer.write(" size='");
            writer.write(String.valueOf(data.size));
            writer.write("'");
        }
        if (data.multiple) {
            writer.write(" multiple");
        }
        if (!this.enabled || !this.isEnabled(formData)) {
            writer.write(" disabled");
        }
        if (this.renderStyleTag) {
            writer.write(" style='");
            writer.write(this.styleTag);
            writer.write("'");
        }
        int n = this.arbitraryString.size();
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
            writer.write(this.arbitraryString.get(i).toString());
        }
        writer.write(">\n");
        for (Select.Option option : data.options.values()) {
            String string = option.getValue();
            boolean bl = false;
            if (formData != null) {
                if (data.selectedMap != null) {
                    bl = data.selectedMap.containsKey(string);
                }
            } else {
                bl = data.origSelectedMap.containsKey(string);
            }
            writer.write(option.render(bl));
            writer.write("\n");
        }
        writer.write("</select>\n");
        this.dependency.renderDependencyData(formData, writer);
    }

    public DependentSelect allowMultiple(FormData formData, boolean bl) {
        Data data = this.getDataObject(formData);
        data.multiple = bl;
        return this;
    }

    public DependentSelect setSize(FormData formData, int n) {
        Data data = this.getDataObject(formData);
        data.size = n;
        return this;
    }

    public void setValue(FormData formData, List list) {
        Argcheck.notnull(formData, "specified fd param was null");
        Data data = new Data();
        formData.putData(this.name, data);
        this.setValue(data, list);
    }

    public void setValue(Data data, List list) {
        for (Select.Option option : list) {
            String string = option.getValue();
            data.options.put(string, option);
            if (!option.isOrigSelected()) continue;
            data.origSelectedMap.put(string, option);
        }
    }

    Data getDataObject(FormData formData) {
        Data data = (Data)formData.getData(this.name);
        return data;
    }

    public static class Data {
        private LinkedHashMap options = new LinkedHashMap();
        private Map origSelectedMap = new HashMap();
        private int size = 0;
        private boolean multiple;
        private Map selectedMap = null;
        private List selectedList = null;

        public void addOption(Select.Option option) {
            String string = option.getValue();
            this.options.put(string, option);
            if (option.isOrigSelected()) {
                this.origSelectedMap.put(string, option);
            }
        }

        public void clearSubmittedData() {
            if (this.selectedMap != null) {
                this.selectedMap.clear();
            }
            if (this.selectedList != null) {
                this.selectedList.clear();
            }
        }

        public String toString() {
            return new ToString((Object)this, ToString.Style.VisibleLevel.PRIVATE).reflect().render();
        }
    }
}

