/*
 * Decompiled with CFR 0.152.
 */
package fc.util.pagetemplate;

import fc.io.IOUtil;
import fc.io.Log;
import fc.util.Argcheck;
import fc.util.Args;
import fc.util.ClassUtil;
import fc.util.StringUtil;
import fc.util.pagetemplate.TemplatePage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class TemplateClassLoader
extends ClassLoader {
    private static final boolean dbg = false;
    Log log;
    Map class_file_paths = new HashMap();

    public TemplateClassLoader(Log log) {
        this.log = log;
    }

    public TemplateClassLoader() {
        this.log = Log.getDefault();
    }

    public Class loadClass(String object, boolean bl) throws ClassNotFoundException {
        if (((String)object).startsWith(TemplatePage.PACKAGE_NAME)) {
            Class clazz = this.findLoadedClass((String)object);
            if (clazz != null) {
                return clazz;
            }
            int n = TemplatePage.PACKAGE_NAME.length() + 1;
            if (!((String)(object = ((String)object).substring(n, ((String)object).length()))).endsWith(".class")) {
                String string = ((String)object).substring(0, ((String)object).indexOf("$"));
                String string2 = (String)this.class_file_paths.get(string);
                if (string2 == null) {
                    throw new ClassNotFoundException("Internal error: cannot load anonymous/inner classe: " + (String)object);
                }
                object = string2 + (String)object + ".class";
            } else {
                String string = StringUtil.dirName((String)object);
                String string3 = StringUtil.fileName((String)object);
                string3 = string3.substring(0, string3.indexOf(".class"));
                this.class_file_paths.put(string3, string);
            }
            clazz = this.readClassFromDisk(new File((String)object));
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        return Thread.currentThread().getContextClassLoader().loadClass((String)object);
    }

    Class readClassFromDisk(File file) throws ClassNotFoundException {
        Argcheck.istrue(file.exists(), "The specified file does not exist: " + file.getAbsolutePath());
        byte[] byArray = null;
        try {
            byArray = IOUtil.fileToByteArray(file);
            if (byArray == null) {
                throw new ClassNotFoundException(file.getPath());
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(file.getPath());
        }
        if (this.getPackage(TemplatePage.PACKAGE_NAME) == null) {
            this.definePackage(TemplatePage.PACKAGE_NAME, null, null, null, null, null, null, null);
        }
        Class<?> clazz = this.defineClass(null, byArray, 0, byArray.length);
        return clazz;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        args.setUsage("java " + ClassUtil.getClassName() + " -file full-path-to-class-file");
        String string = TemplatePage.PACKAGE_NAME + "." + args.getRequired("file");
        TemplateClassLoader templateClassLoader = new TemplateClassLoader();
        templateClassLoader.log.setLevel("debug");
        System.out.println("Loading java.lang.object: ");
        Class<?> clazz = templateClassLoader.loadClass("java.lang.Object");
        System.out.println(ClassUtil.getClassLoaderInfo(clazz));
        System.out.println("Loading " + string);
        clazz = templateClassLoader.loadClass(string);
        System.out.println(ClassUtil.getClassLoaderInfo(clazz));
        System.out.println("Package for this class: " + String.valueOf(clazz.getPackage()));
    }
}

