/*
 * Decompiled with CFR 0.152.
 */
package fc.util.cache;

import fc.io.Log;
import fc.util.Argcheck;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class BoundedCache {
    final String myName;
    Map cache;
    volatile boolean closed = false;
    final Log log;
    final Policy cachePolicy;
    int bound;

    public BoundedCache(Log log, String string, Policy policy, int n) {
        if (log == null) {
            log = Log.getDefault();
        }
        this.log = log;
        this.myName = string;
        this.cachePolicy = policy;
        this.bound = n;
        if (policy == Policy.LEAST_USED) {
            this.cache = Collections.synchronizedMap(new MyLinkedHashMap(this, n, 0.75f, true));
        } else if (policy == Policy.FIFO) {
            this.cache = Collections.synchronizedMap(new MyLinkedHashMap(this, n, 0.75f, false));
        } else {
            throw new IllegalArgumentException("Do not understand this cache policy: " + String.valueOf((Object)policy));
        }
    }

    public BoundedCache(Policy policy, int n) {
        this(null, "BoundedCache/created@" + DateFormat.getDateTimeInstance(3, 3).format(new Date()), policy, n);
    }

    public void setBound(int n) {
        this.bound = n;
    }

    public long getBound() {
        return this.bound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire(Object object) {
        Map map = this.cache;
        synchronized (map) {
            this.cache.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object containsKey(Object object) {
        Argcheck.isfalse(this.isClosed(), "Cache has been closed");
        Object var2_2 = null;
        Map map = this.cache;
        synchronized (map) {
            var2_2 = this.cache.get(object);
        }
        return var2_2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Argcheck.isfalse(this.isClosed(), "Cache has been closed");
        Object var2_2 = null;
        Map map = this.cache;
        synchronized (map) {
            var2_2 = this.cache.get(object);
        }
        return var2_2;
    }

    public Map getAll() {
        return Collections.unmodifiableMap(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        Argcheck.isfalse(this.isClosed(), "Memory cache has been closed");
        Object object3 = null;
        Map map = this.cache;
        synchronized (map) {
            object3 = this.cache.put(object, object2);
        }
        return object3;
    }

    public void close() {
        this.closed = true;
        this.cache.clear();
        this.log.info("*** cache:[", this.myName, "] closed. ***");
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    public String toString() {
        int n = this.cache.size();
        String string = this.myName + " [bound=" + this.bound + ", used=";
        string = string + n;
        string = string + "] items;";
        string = string + " [Policy = " + String.valueOf((Object)this.cachePolicy) + "] ";
        string = string + (this.isClosed() ? "cache is closed. " : "cache is open.");
        return string;
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    public static enum Policy {
        LEAST_USED,
        FIFO;

    }

    private class MyLinkedHashMap
    extends LinkedHashMap {
        final /* synthetic */ BoundedCache this$0;

        MyLinkedHashMap(BoundedCache boundedCache, int n, float f, boolean bl) {
            BoundedCache boundedCache2 = boundedCache;
            Objects.requireNonNull(boundedCache2);
            this.this$0 = boundedCache2;
            super(n, f, bl);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.this$0.bound;
        }
    }

    private static class Test {
        Test() {
            try {
                System.out.println("Testing FIFO...");
                BoundedCache boundedCache = new BoundedCache(Policy.FIFO, 3);
                System.out.println("putting key1, " + String.valueOf(boundedCache.put("key1", "val1")));
                System.out.println("putting key2, " + String.valueOf(boundedCache.put("key2", "key2")));
                System.out.println("putting key3, " + String.valueOf(boundedCache.put("key3", "key3")));
                System.out.println("putting key4, " + String.valueOf(boundedCache.put("key4", "key4")));
                System.out.println("get key1 = " + String.valueOf(boundedCache.get("key1")));
                System.out.println("get key2 = " + String.valueOf(boundedCache.get("key2")));
                System.out.println("getkey3 = " + String.valueOf(boundedCache.get("key3")));
                System.out.println("get key4 = " + String.valueOf(boundedCache.get("key4")));
                System.out.println("mycache.toString() = " + String.valueOf(boundedCache));
                System.out.println("=========================");
                System.out.println("Testing LRU...");
                boundedCache = new BoundedCache(Policy.LEAST_USED, 3);
                System.out.println("putting key1, " + String.valueOf(boundedCache.put("key1", "val1")));
                System.out.println("putting key2, " + String.valueOf(boundedCache.put("key2", "key2")));
                System.out.println("putting key3, " + String.valueOf(boundedCache.put("key3", "key3")));
                System.out.println("putting key4, " + String.valueOf(boundedCache.put("key4", "key4")));
                System.out.println("getting key2 [4times] and key3[1 time]");
                System.out.println(boundedCache.get("key2"));
                System.out.println(boundedCache.get("key2"));
                System.out.println(boundedCache.get("key2"));
                System.out.println(boundedCache.get("key2"));
                System.out.println(boundedCache.get("key3"));
                System.out.println("putting key5, " + String.valueOf(boundedCache.put("key5", "key5")));
                System.out.println("get key1=" + String.valueOf(boundedCache.get("key1")));
                System.out.println("get key2=" + String.valueOf(boundedCache.get("key2")));
                System.out.println("get key3=" + String.valueOf(boundedCache.get("key3")));
                System.out.println("get key4=" + String.valueOf(boundedCache.get("key4")));
                System.out.println("get key5=" + String.valueOf(boundedCache.get("key5")));
                System.out.println("mycache.toString() = " + String.valueOf(boundedCache));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

