/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.NanoWatch;
import fc.util.Watch;
import java.text.NumberFormat;
import java.util.Calendar;

public final class ThreadLocalCalendar {
    private final ThreadLocal tlcal = new ThreadLocal();

    public Calendar get() {
        return (Calendar)this.tlcal.get();
    }

    public void set(Calendar calendar) {
        this.tlcal.set(calendar);
    }

    public boolean isNull() {
        return this.tlcal.get() == null;
    }

    public static void main(String[] stringArray) throws Exception {
        ThreadLocalCalendar threadLocalCalendar = new ThreadLocalCalendar();
        TestThread testThread = new TestThread(false, threadLocalCalendar);
        TestThread testThread2 = new TestThread(false, threadLocalCalendar);
        testThread.start();
        testThread2.start();
        for (int i = 0; i < 100; ++i) {
            new TestThread(true, threadLocalCalendar).start();
        }
    }

    static class TestThread
    extends Thread {
        boolean timing_only = false;
        ThreadLocalCalendar cal;

        TestThread(boolean bl, ThreadLocalCalendar threadLocalCalendar) {
            this.timing_only = bl;
            this.cal = threadLocalCalendar;
        }

        @Override
        public void run() {
            if (this.cal.isNull()) {
                this.cal.set(Calendar.getInstance());
            }
            NanoWatch nanoWatch = new NanoWatch();
            ((Watch)nanoWatch).start();
            if (this.cal.isNull()) {
                this.cal.set(Calendar.getInstance());
            }
            Calendar calendar = this.cal.get();
            ((Watch)nanoWatch).stop();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumIntegerDigits(2);
            if (this.timing_only) {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]");
            } else {
                System.out.println("[" + numberFormat.format((double)((Watch)nanoWatch).getTime() / 1000000.0) + " ms]" + String.valueOf(Thread.currentThread()) + "/Calendar-ID:[" + System.identityHashCode(calendar) + "] " + String.valueOf(calendar));
            }
        }
    }
}

