/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.HAlign;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class StringUtil {
    static final String[] VIEW_ASCII = new String[]{"NUL", "[ascii(1)]", "[ascii(2)]", "[ascii(3)]", "[ascii(4)]", "[ascii(5)]", "[ascii(6)]", "\\a", "\\b", "\\t", "\\n", "\\v", "[ascii(12)]", "\\r", "[ascii(14)]", "[ascii(15)]", "[ascii(16)]", "[ascii(17)", "[ascii(18)]", "[ascii(19)]", "[ascii(20)]", "[ascii(21)]", "[ascii(22)]", "ascii(23)]", "[ascii(24)]", "[ascii(25)]", "[ascii(26)]", "\\e", "[ascii(28)]", "[ascii(29)]", "[ascii(30)]", "[ascii(31)]"};

    public static String nullToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String nullToEmpty(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static boolean nullOrEmpty(String string) {
        return string != null && string.isEmpty();
    }

    public static String repeat(char c, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, int n) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String repeatToWidth(String string, int n) {
        Argcheck.notnull(string, "specified string was null");
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 > n) {
            return string.substring(0, n);
        }
        int n3 = n / n2;
        int n4 = n % n2;
        String string2 = StringUtil.repeat(string, n3);
        if (n4 != 0) {
            string2 = string2.concat(string.substring(0, n4));
        }
        return string2;
    }

    public static String fixedWidth(String string, int n) {
        return StringUtil.fixedWidth(string, n, HAlign.LEFT, ' ');
    }

    public static String fixedWidth(String string, int n, HAlign hAlign) {
        return StringUtil.fixedWidth(string, n, hAlign, ' ');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String fixedWidth(String object, int n, HAlign hAlign, char c) {
        int n2;
        if (object == null) {
            object = "";
        }
        if ((n2 = ((String)object).length()) < n) {
            if (hAlign == HAlign.LEFT) {
                return (String)object + StringUtil.repeat(c, n - n2);
            }
            if (hAlign == HAlign.RIGHT) {
                return StringUtil.repeat(c, n - n2) + (String)object;
            }
            if (hAlign != HAlign.CENTER) throw new IllegalArgumentException("Do not understand the specified alignment: " + String.valueOf(hAlign));
            int n3 = n - n2;
            String string = StringUtil.repeat(c, n3 / 2);
            return string + (String)object + string + StringUtil.repeat(c, n3 % 2);
        }
        if (n2 <= n) return object;
        return ((String)object).substring(0, n);
    }

    public static String ellipsis(String object, String string, int n) {
        if (((String)object).length() > n) {
            object = ((String)object).substring(0, n - string.length()) + string;
        }
        return object;
    }

    public static String ellipsis(String string, int n) {
        return StringUtil.ellipsis(string, "...", n);
    }

    public static String removeLeadingWhiteSpace(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return string.replaceFirst("^\\s+", "");
    }

    public static String remove(String string, char[] cArray) {
        if (string == null || cArray == null) {
            return string;
        }
        int n = string.length();
        char[] cArray2 = new char[n];
        char[] cArray3 = new char[n];
        string.getChars(0, n, cArray3, 0);
        int n2 = cArray.length;
        int n3 = -1;
        int n4 = -1;
        char c = '\u0000';
        boolean bl = false;
        while (++n3 < n) {
            c = cArray3[n3];
            bl = false;
            for (int i = 0; i < n2; ++i) {
                if (c != cArray[i]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            cArray2[++n4] = c;
        }
        return new String(cArray2, 0, n4 + 1);
    }

    public static String removeTrailingSlash(String string) {
        String string2 = string;
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char c = string.charAt(n - 1);
        if (c == '/' || c == '\\') {
            string2 = string.substring(0, n - 1);
        }
        return string2;
    }

    public static String removeBeginningSlash(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        char c = string.charAt(0);
        if (c == '/' || c == '\\') {
            if (n > 1) {
                return string.substring(1);
            }
            return "";
        }
        return string;
    }

    public static String removeSuffix(String string) {
        String string2 = null;
        if (string == null) {
            return string2;
        }
        string2 = string.replaceFirst("(.+)(\\..+)", "$1");
        return string2;
    }

    public static String dirName(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    public static String fileName(String string) {
        String string2 = "";
        if (string == null) {
            return string2;
        }
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        int n2 = string.length();
        if (n2 == 1) {
            return string2;
        }
        return string.substring(++n, n2);
    }

    public static List split(String string, String string2) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().toLowerCase());
        }
        return arrayList;
    }

    public static String join(List list, String string) {
        Argcheck.notnull(list, "specified list param was null");
        Argcheck.notnull(string, "specified delim param was null");
        int n = list.size();
        int n2 = n - 1;
        StringBuffer stringBuffer = new StringBuffer(n * 16);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(list.get(i).toString());
            if (i >= n2) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String capitalWord(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string.substring(0, 1).toUpperCase() + string.substring(1, n));
        return stringBuffer.toString();
    }

    public static String sentenceCase(String string, String string2) {
        Argcheck.notnull(string, "specified string was null");
        if (string2 == null) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (string2.indexOf(c) >= 0) {
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append(stringBuffer2.substring(0, 1).toUpperCase());
                    stringBuffer.append(stringBuffer2.substring(1, stringBuffer2.length()).toLowerCase());
                }
                stringBuffer.append(c);
                stringBuffer2 = new StringBuffer(n);
                continue;
            }
            stringBuffer2.append(c);
        }
        if (stringBuffer2.length() > 0) {
            stringBuffer.append(stringBuffer2.substring(0, 1).toUpperCase());
            stringBuffer.append(stringBuffer2.substring(1, stringBuffer2.length()).toLowerCase());
        }
        return stringBuffer.toString();
    }

    public static String viewableAscii(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < ' ') {
                stringBuffer.append(VIEW_ASCII[c]);
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append('?');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String viewableAscii(char c) {
        if (c < ' ') {
            return VIEW_ASCII[c];
        }
        if (c > '\u00ff') {
            return "?";
        }
        return new String(new char[]{c});
    }

    public static String arrayToString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        int n = cArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(StringUtil.viewableAscii(cArray[n2]));
            if (++n2 == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String listToString(List list, String string) {
        return StringUtil.listToString(list, string, "", "");
    }

    public static String listToString(List list, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(list.get(i));
                if (i + 1 >= n) continue;
                stringBuilder.append(string);
            }
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    public static String escapeSingleQuotes(String string) {
        return StringUtil.escapeSingleQuotes(string, "\\");
    }

    public static String escapeSingleQuotes(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\'') {
                stringBuilder.append(string2);
                stringBuilder.append('\'');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String escapeDoubleQuotes(String string) {
        return StringUtil.escapeSingleQuotes(string, "\\");
    }

    public static String escapeDoubleQuotes(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append(string2);
                stringBuilder.append('\"');
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        String string = "hahaha, my name is ha";
        char[] cArray = new char[]{'h', 'm'};
        System.out.println("testing StringUtil.remove(\"" + string + "\",'" + String.valueOf(cArray) + "')");
        String string2 = StringUtil.remove(string, cArray);
        System.out.println("result>>" + string2 + "<<");
        System.out.println("Original String length: " + string.length() + " ; New String length: " + string2.length());
        System.out.println(":" + StringUtil.repeat(' ', 20) + ":");
        System.out.println("removeLeadingWhiteSpace(\" \\n\"): [" + StringUtil.removeLeadingWhiteSpace(" \n") + "]");
        System.out.println("removeLeadingWhiteSpace(\"\"): [" + StringUtil.removeLeadingWhiteSpace("") + "]");
        System.out.println("removeLeadingWhiteSpace(\"\\n\"): [" + StringUtil.removeLeadingWhiteSpace("\n") + "]");
        System.out.println("removeLeadingWhiteSpace(\"\\n\\n\\ttest\"): [" + StringUtil.removeLeadingWhiteSpace("\n\n\ttest") + "]");
        System.out.println("removeLeadingWhiteSpace(\"\\n\\n\\ttest\\t \"): [" + StringUtil.removeLeadingWhiteSpace("\n\n\ttest\t ") + "]");
        System.out.println("sentenceCase(\"hello world\", \" \"): [" + StringUtil.sentenceCase("hello world", " ") + "]");
        System.out.println("sentenceCase(\"helloworld\", \" \"): [" + StringUtil.sentenceCase("helloworld", " ") + "]");
        System.out.println("sentenceCase(\"  hello world\", \" \"): [" + StringUtil.sentenceCase("  hello world", " ") + "]");
        System.out.println("sentenceCase(\"hello world  \", \" \"): [" + StringUtil.sentenceCase("hello world  ", " ") + "]");
        System.out.println("sentenceCase(\"hello_world  \", \"_\"): [" + StringUtil.sentenceCase("hello_world  ", "_") + "]");
        System.out.println("sentenceCase(\"__hello_world_ foo  \", \"_ \"): [" + StringUtil.sentenceCase("__hello_world_ foo  ", "_ ") + "]");
        System.out.println("sentenceCase(\"foXbAr\", \"X\"): [" + StringUtil.sentenceCase("foXbAr", "X") + "]");
        System.out.println("viewableAscii(abc[newline]foo[tab]\\u4234)=" + StringUtil.viewableAscii("abc\nfoo\t\u4234"));
        for (char c = '\u0000'; c < '\u00ff'; c = (char)(c + '\u0001')) {
            System.out.print(StringUtil.viewableAscii(c));
        }
        System.out.println("");
        System.out.println("remove trailing slash on '' = " + StringUtil.removeTrailingSlash(""));
        System.out.println("remove trailing slash on '/' = " + StringUtil.removeTrailingSlash(""));
        System.out.println("remove trailing slash on 'foo/' = " + StringUtil.removeTrailingSlash("foo/"));
        System.out.println("remove beginning slash on '' = " + StringUtil.removeBeginningSlash(""));
        System.out.println("remove beginning slash on '/' = " + StringUtil.removeBeginningSlash("/"));
        System.out.println("remove beginning slash on '/foo' = " + StringUtil.removeBeginningSlash("/foo"));
        System.out.println("====fixed width tests");
        String string3 = "hello";
        int n = 15;
        System.out.println("fixed width input string: " + string3);
        System.out.println("fixed width = 15");
        System.out.println("align default: [" + StringUtil.fixedWidth(string3, n) + "]");
        System.out.println("align left: [" + StringUtil.fixedWidth(string3, n, HAlign.LEFT) + "]");
        System.out.println("align right : [" + StringUtil.fixedWidth(string3, n, HAlign.RIGHT) + "]");
        System.out.println("align center: [" + StringUtil.fixedWidth(string3, n, HAlign.CENTER) + "]");
        System.out.println("repeatToWidth('hello', 0)=" + StringUtil.repeatToWidth("hello", 0));
        System.out.println("repeatToWidth('hello', 1)=" + StringUtil.repeatToWidth("hello", 1));
        System.out.println("repeatToWidth('hello', 5)=" + StringUtil.repeatToWidth("hello", 5));
        System.out.println("repeatToWidth('hello', 9)=" + StringUtil.repeatToWidth("hello", 9));
        System.out.println("repeatToWidth('hello', 10)=" + StringUtil.repeatToWidth("hello", 10));
        System.out.println("repeatToWidth('hello', 11)=" + StringUtil.repeatToWidth("hello", 11));
        System.out.println("repeatToWidth('X', 0)=[" + StringUtil.repeatToWidth("X", 0) + "]");
        System.out.println("escapeSingleQuotes(\"'\")=" + StringUtil.escapeSingleQuotes("'"));
        System.out.println("escapeSingleQuotes(\"\")=" + StringUtil.escapeSingleQuotes(""));
        System.out.println("escapeSingleQuotes(\"'foo'bar'\")=" + StringUtil.escapeSingleQuotes("'foo'bar'"));
        System.out.println("escapeSingleQuotes(\"'''\")=" + StringUtil.escapeSingleQuotes("'''"));
        System.out.println("escapeSingleQuotes(\"'foo'bar'\", \"'\")=" + StringUtil.escapeSingleQuotes("'foo'bar'", "'"));
        System.out.println("listToString(null):" + StringUtil.listToString(null, "x"));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(1);
        arrayList.add(2);
        System.out.println("listToString([1,2] / [ ]): " + StringUtil.listToString(arrayList, "/", "[", "]"));
        System.out.println("ellipsis('hello world', 8): " + StringUtil.ellipsis("hello world", 8));
    }
}

