/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

public class Platform {
    public static final Platform LINUX = new Platform("linux");
    public static final Platform WINDOWS = new Platform("windows");
    public static final Platform SOLARIS = new Platform("solaris");
    public static final Platform OSX = new Platform("osx");
    public static final Platform FREEBSD = new Platform("freebsd");
    public static final Platform OPENBSD = new Platform("openbsd");
    public static final Platform OTHER = new Platform("other");
    private static Platform currentPlatform;
    private String name;
    private static byte count;

    private Platform(String string) {
        this.name = string;
    }

    public static Platform getPlatform() {
        return currentPlatform;
    }

    public static boolean isWindows() {
        return currentPlatform == WINDOWS;
    }

    public static boolean isOSX() {
        return currentPlatform == OSX;
    }

    public static boolean isLinux() {
        return currentPlatform == LINUX;
    }

    public static boolean isSolaris() {
        return currentPlatform == SOLARIS;
    }

    public static boolean isFreeBSD() {
        return currentPlatform == FREEBSD;
    }

    public static boolean isOpenBSD() {
        return currentPlatform == OPENBSD;
    }

    public static boolean isOther() {
        return currentPlatform == OTHER;
    }

    public static boolean isAIX() {
        return currentPlatform == WINDOWS;
    }

    private static void init() {
        String string = System.getProperty("os.name").toLowerCase();
        currentPlatform = string.indexOf("windows") != -1 ? WINDOWS : (string.indexOf("linux") != -1 ? LINUX : (string.indexOf("sun") != -1 ? SOLARIS : (string.toLowerCase().indexOf("mac") != -1 && string.toLowerCase().indexOf("x") != -1 ? OSX : (string.indexOf("freebsd") != -1 ? FREEBSD : (string.indexOf("openbsd") != -1 ? OPENBSD : OTHER)))));
    }

    public String toString() {
        return this.name;
    }

    public static void main(String[] stringArray) {
        System.out.println("Current platform: " + String.valueOf(Platform.getPlatform()));
    }

    static {
        count = 1;
        Platform.init();
    }
}

