/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Watch;
import java.text.NumberFormat;

public final class NanoWatch
extends Watch {
    private static final double ms_factor = 1.0E-6;

    public NanoWatch(String string) {
        super(string);
    }

    public NanoWatch() {
        super("DefaultNanoWatch/" + Thread.currentThread().getName());
    }

    @Override
    public NanoWatch start() {
        this.startTime = System.nanoTime();
        this.running = true;
        return this;
    }

    @Override
    public void stop() {
        this.stopTime = System.nanoTime();
        this.cumulativeTime += this.stopTime - this.startTime;
        this.running = false;
    }

    @Override
    public long time() {
        if (this.startTime == -1L) {
            throw new RuntimeException("You need to start the watch at least once before calling this method");
        }
        if (this.running) {
            return System.nanoTime() - this.startTime;
        }
        return this.stopTime - this.startTime;
    }

    @Override
    public long getTime() {
        return this.time();
    }

    @Override
    public double getTimeInMillis() {
        long l = this.time();
        return (double)l * 1.0E-6;
    }

    @Override
    public long cumulativeTime() {
        if (!this.running) {
            return this.cumulativeTime;
        }
        return this.cumulativeTime + (System.nanoTime() - this.startTime);
    }

    @Override
    public void reset() {
        this.stopTime = 0L;
        this.startTime = 0L;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    protected long getStart() {
        return this.startTime;
    }

    @Override
    protected long getStop() {
        return this.stopTime;
    }

    @Override
    public String toString() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        Object object = this.myname;
        object = (String)object + ": Cum.Time=[" + numberFormat.format(this.cumulativeTime()) + " nanoseconds]";
        if (this.running) {
            object = (String)object + "; Elapsed=[" + numberFormat.format(this.time()) + " nanoseconds]";
        }
        return object;
    }

    public static void main(String[] stringArray) {
        NanoWatch nanoWatch = new NanoWatch("NanoWatch 1");
        ((Watch)nanoWatch).start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    NanoWatch nanoWatch = new NanoWatch();
                    ((Watch)nanoWatch).start();
                    Thread.currentThread();
                    Thread.sleep(20L);
                    ((Watch)nanoWatch).stop();
                    System.out.println("t2.toString():" + String.valueOf(nanoWatch));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
        System.out.println("NanoWatch 1, total time taken:" + ((Watch)nanoWatch).time());
        System.out.println("NanoWatch 1, time=" + ((Watch)nanoWatch).time());
        System.out.println("NanoWatch 1, before-being-stopped, toString():" + String.valueOf(nanoWatch));
        ((Watch)nanoWatch).stop();
        System.out.println("NanoWatch 1, is running ? " + ((Watch)nanoWatch).isRunning());
        System.out.println("NanoWatch 1, after-being-stopped, toString():" + String.valueOf(nanoWatch));
        System.out.println("NanoWatch 1, elapsed time:" + ((Watch)nanoWatch).time());
        System.out.println("NanoWatch 1, cumulative time taken:" + ((Watch)nanoWatch).cumulativeTime());
        System.out.println("NanoWatch 1, elapsed time:" + ((Watch)nanoWatch).time());
    }
}

