/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.io.IOUtil;
import fc.util.Args;
import java.io.InputStream;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MiscUtil {
    public static final String[] java_keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};

    public static boolean isJavaKeyword(String string) {
        return Arrays.binarySearch(java_keywords, string) >= 0;
    }

    public static int getTerminalColumnCount() {
        int n = -1;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("stty", "-a");
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            String string = IOUtil.inputStreamToString(inputStream);
            Pattern pattern = Pattern.compile("\\s+(\\d+)\\s+columns\\s*|\\s*columns\\s+(\\d+)");
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                if (matcher.group(1) != null) {
                    n = Integer.parseInt(matcher.group(1));
                } else if (matcher.group(2) != null) {
                    n = Integer.parseInt(matcher.group(2));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Args args = new Args(stringArray);
        System.out.println(MiscUtil.isJavaKeyword(args.getRequired("word")));
        System.out.println("Terminal columns: " + MiscUtil.getTerminalColumnCount());
    }
}

