/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import fc.util.CharRange;
import java.util.ArrayList;
import java.util.List;

public class CharRangeSet {
    CharRange seedRange;
    List union;
    List intersect;

    public CharRangeSet(CharRange charRange) {
        Argcheck.notnull(charRange);
        this.seedRange = charRange;
        this.union = new ArrayList();
        this.intersect = new ArrayList();
    }

    public void union(CharRange charRange) {
        Argcheck.notnull(charRange);
        this.union.add(charRange);
    }

    public void intersection(CharRange charRange) {
        Argcheck.notnull(charRange);
        this.intersect.add(charRange);
    }

    public boolean inRange(char c) {
        CharRange charRange;
        int n;
        boolean bl = this.seedRange.inRange(c);
        int n2 = this.union.size();
        for (n = 0; n < n2; ++n) {
            charRange = (CharRange)this.union.get(n);
            bl = bl || charRange.inRange(c);
        }
        n2 = this.intersect.size();
        for (n = 0; n < n2; ++n) {
            charRange = (CharRange)this.intersect.get(n);
            bl = bl && charRange.inRange(c);
        }
        return bl;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("CharRangeSet:[");
        if (this.intersect.size() > 0) {
            stringBuffer.append("(");
        }
        stringBuffer.append(this.seedRange);
        int n2 = this.union.size();
        if (n2 > 0) {
            stringBuffer.append(" || ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.union.get(n).toString());
                if (n >= n2 - 1) continue;
                stringBuffer.append(" || ");
            }
        }
        if ((n2 = this.intersect.size()) > 0) {
            stringBuffer.append(") && ");
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(this.intersect.get(n).toString());
                if (n >= n2 - 1) continue;
                stringBuffer.append(" && ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        CharRange charRange = new CharRange('b', 'd');
        CharRange charRange2 = new CharRange('x', 'y');
        CharRangeSet charRangeSet = new CharRangeSet(charRange);
        charRangeSet.union(charRange2);
        System.out.println("constructed: " + String.valueOf(charRangeSet));
        CharRangeSet.test(charRangeSet);
        charRangeSet.intersection(new CharRange('a', 'x'));
        System.out.println("added intersection, now: ");
        System.out.println(charRangeSet);
        CharRangeSet.test(charRangeSet);
        charRangeSet.union(new CharRange('a', 'z'));
        charRangeSet.intersection(new CharRange('s', 't'));
        System.out.println("added union, intersection, now: ");
        System.out.println(charRangeSet);
        CharRangeSet.test(charRangeSet);
    }

    private static void test(CharRangeSet charRangeSet) {
        System.out.println("'b' in range:" + charRangeSet.inRange('b'));
        System.out.println("'z' in range:" + charRangeSet.inRange('z'));
        System.out.println("'s' in range:" + charRangeSet.inRange('s'));
        System.out.println("'m' in range:" + charRangeSet.inRange('m'));
    }
}

