/*
 * Decompiled with CFR 0.152.
 */
package fc.util;

import fc.util.Argcheck;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;

public class BitUtil {
    static final int DEF_SEP_NUM = 4;
    static final char DEF_SEP_CHAR = ' ';

    public static boolean isBitSet(byte by, int n) {
        Argcheck.istrue(n >= 0 && n <= 7, "bit number must be between [0-7] for char, I got num=[" + n + "]");
        return (by >> n & 1) == 1;
    }

    public static boolean isBitSet(short s, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for short, I got num=[" + n + "]");
        return (s >> n & 1) == 1;
    }

    public static boolean isBitSet(char c, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for char, I got num=[" + n + "]");
        return (c >> n & 1) == 1;
    }

    public static boolean isBitSet(int n, int n2) {
        Argcheck.istrue(n2 >= 0 && n2 <= 31, "bit number must be between [0-31] for int, I got num=[" + n2 + "]");
        return (n >> n2 & 1) == 1;
    }

    public static boolean isBitSet(long l, int n) {
        Argcheck.istrue(n >= 0 && n <= 63, "bit number must be between [0-63] for char, I got num=[" + n + "]");
        return (l >> n & 1L) == 1L;
    }

    public static byte setBit(byte by, int n) {
        Argcheck.istrue(n >= 0 && n <= 7, "bit number must be between [0-7] for byte, I got num=[" + n + "]");
        return (byte)(by | 1 << n);
    }

    public static short setBit(short s, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for short, I got num=[" + n + "]");
        return (short)(s | 1 << n);
    }

    public static char setBit(char c, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for char, I got num=[" + n + "]");
        return (char)(c | 1 << n);
    }

    public static int setBit(int n, int n2) {
        Argcheck.istrue(n2 >= 0 && n2 <= 31, "bit number must be between [0-31] for int, I got num=[" + n2 + "]");
        return n | 1 << n2;
    }

    public static long setBit(long l, long l2) {
        Argcheck.istrue(l2 >= 0L && l2 <= 63L, "bit number must be between [0-63] for long, I got num=[" + l2 + "]");
        return l | 1L << (int)l2;
    }

    public static byte clearBit(byte by, int n) {
        Argcheck.istrue(n >= 0 && n <= 7, "bit number must be between [0-7] for byte, I got num=[" + n + "]");
        return (byte)(by & ~(1 << n));
    }

    public static short clearBit(short s, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for short, I got num=[" + n + "]");
        return (short)(s & ~(1 << n));
    }

    public static char clearBit(char c, int n) {
        Argcheck.istrue(n >= 0 && n <= 15, "bit number must be between [0-15] for char, I got num=[" + n + "]");
        return (char)(c & ~(1 << n));
    }

    public static int clearBit(int n, int n2) {
        Argcheck.istrue(n2 >= 0 && n2 <= 31, "bit number must be between [0-31] for int, I got num=[" + n2 + "]");
        return n & ~(1 << n2);
    }

    public static long clearBit(long l, int n) {
        Argcheck.istrue(n >= 0 && n <= 63, "bit number must be between [0-63] for long, I got num=[" + n + "]");
        return l & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static String toBinaryString(byte by) {
        char[] cArray = new char[8];
        for (int i = 0; i < 8; ++i) {
            cArray[i] = (by >> 7 - i & 1) == 1 ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String toBinaryString(short s) {
        char[] cArray = new char[16];
        for (int i = 0; i < 16; ++i) {
            cArray[i] = (s >> 15 - i & 1) == 1 ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String toBinaryString(char c) {
        char[] cArray = new char[16];
        for (int i = 0; i < 16; ++i) {
            cArray[i] = (c >> 15 - i & 1) == 1 ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String toBinaryString(int n) {
        char[] cArray = new char[32];
        for (int i = 0; i < 32; ++i) {
            cArray[i] = (n >> 31 - i & 1) == 1 ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String toBinaryString(long l) {
        char[] cArray = new char[64];
        for (int i = 0; i < 64; ++i) {
            cArray[i] = (l >> 63 - i & 1L) == 1L ? 49 : 48;
        }
        return new String(cArray);
    }

    private static Map getFormatMap(String string) {
        int n = 4;
        char c = ' ';
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
            if (cArray.length > 0) {
                try {
                    n = Integer.parseInt(String.valueOf(cArray[0]));
                }
                catch (NumberFormatException numberFormatException) {
                    c = cArray[0];
                }
            }
            if (cArray.length > 1) {
                c = cArray[1];
            }
        }
        HashMap<String, Constable> hashMap = new HashMap<String, Constable>();
        hashMap.put("sep_num", Integer.valueOf(n));
        hashMap.put("sep_char", Character.valueOf(c));
        return hashMap;
    }

    public static String toBinaryString(byte by, String string) {
        String string2 = BitUtil.toBinaryString(by);
        Map map = BitUtil.getFormatMap(string);
        int n = (Integer)map.get("sep_num");
        char c = ((Character)map.get("sep_char")).charValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 8;
        int n3 = 1;
        while (n2 > 0) {
            stringBuilder.append(string2.charAt(n2 - 1));
            if (n3 % n == 0 && n2 > 1) {
                stringBuilder.append(c);
            }
            --n2;
            ++n3;
        }
        return stringBuilder.reverse().toString();
    }

    public static String toBinaryString(short s, String string) {
        String string2 = BitUtil.toBinaryString(s);
        Map map = BitUtil.getFormatMap(string);
        int n = (Integer)map.get("sep_num");
        char c = ((Character)map.get("sep_char")).charValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 16;
        int n3 = 1;
        while (n2 > 0) {
            stringBuilder.append(string2.charAt(n2 - 1));
            if (n3 % n == 0 && n2 > 1) {
                stringBuilder.append(c);
            }
            --n2;
            ++n3;
        }
        return stringBuilder.reverse().toString();
    }

    public static String toBinaryString(char c, String string) {
        String string2 = BitUtil.toBinaryString(c);
        Map map = BitUtil.getFormatMap(string);
        int n = (Integer)map.get("sep_num");
        char c2 = ((Character)map.get("sep_char")).charValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 16;
        int n3 = 1;
        while (n2 > 0) {
            stringBuilder.append(string2.charAt(n2 - 1));
            if (n3 % n == 0 && n2 > 1) {
                stringBuilder.append(c2);
            }
            --n2;
            ++n3;
        }
        return stringBuilder.reverse().toString();
    }

    public static String toBinaryString(int n, String string) {
        String string2 = BitUtil.toBinaryString(n);
        Map map = BitUtil.getFormatMap(string);
        int n2 = (Integer)map.get("sep_num");
        char c = ((Character)map.get("sep_char")).charValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 32;
        int n4 = 1;
        while (n3 > 0) {
            stringBuilder.append(string2.charAt(n3 - 1));
            if (n4 % n2 == 0 && n3 > 1) {
                stringBuilder.append(c);
            }
            --n3;
            ++n4;
        }
        return stringBuilder.reverse().toString();
    }

    public static String toBinaryString(long l, String string) {
        String string2 = BitUtil.toBinaryString(l);
        Map map = BitUtil.getFormatMap(string);
        int n = (Integer)map.get("sep_num");
        char c = ((Character)map.get("sep_char")).charValue();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 64;
        int n3 = 1;
        while (n2 > 0) {
            stringBuilder.append(string2.charAt(n2 - 1));
            if (n3 % n == 0 && n2 > 1) {
                stringBuilder.append(c);
            }
            --n2;
            ++n3;
        }
        return stringBuilder.reverse().toString();
    }

    public static void main(String[] stringArray) {
        int n = Integer.parseInt("1000", 2);
        System.out.println("[int]isBitSet('1000'/" + n + ",3):" + BitUtil.isBitSet(n, 3));
        n = Integer.parseInt("0000", 2);
        System.out.println("[int]isBitSet('0000'/" + n + ",3):" + BitUtil.isBitSet(n, 3));
        n = Integer.parseInt("1001", 2);
        System.out.println("[int]isBitSet('1001'/" + n + ",2):" + BitUtil.isBitSet(n, 2));
        n = Integer.parseInt("1001", 2);
        System.out.println("[int]isBitSet('1001'/" + n + ",0):" + BitUtil.isBitSet(n, 0));
        n = Integer.parseInt("1000000000000000000000000000000", 2);
        System.out.println("[int]isBitSet('1000000000000000000000000000000'/" + n + ",2):" + BitUtil.isBitSet(n, 2));
        n = Integer.parseInt("1001", 2);
        try {
            System.out.println("[int]isBitSet('1001'/" + n + ",31):" + BitUtil.isBitSet(n, 31));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        long l = Long.parseLong("11001100", 2);
        System.out.println("[long]isBitSet('11001100'/" + l + ",3):" + BitUtil.isBitSet(l, 3));
        char c = (char)Integer.parseInt("1001000010010000", 2);
        System.out.println("[char]isBitSet('1001000010010000'/" + c + ",1):" + BitUtil.isBitSet(c, 1));
        System.out.println("[char]isBitSet('1001000010010000'/" + c + ",15):" + BitUtil.isBitSet(c, 15));
        byte by = (byte)Integer.parseInt("00000100", 2);
        System.out.println("[byte]isBitSet('00000100'/" + by + ",1):" + BitUtil.isBitSet(by, 0));
        System.out.println("[byte]isBitSet('00000100'/" + by + ",3):" + BitUtil.isBitSet(by, 2));
        short s = (short)Integer.parseInt("1000100010001000", 2);
        System.out.println("[short]isBitSet('1000100010001000'/" + s + ",1):" + BitUtil.isBitSet(s, 0));
        System.out.println("[short]isBitSet('1000100010001000'/" + s + ",3):" + BitUtil.isBitSet(s, 15));
        System.out.println("------- set and clear bits ----------");
        System.out.println("------- char ----------");
        System.out.print("c=" + BitUtil.toBinaryString(c));
        c = BitUtil.setBit(c, 0);
        System.out.println("->setBit(c, 0)->" + BitUtil.toBinaryString(c));
        System.out.println("isBitSet(c, 0):" + BitUtil.isBitSet(c, 0));
        System.out.print("c=" + BitUtil.toBinaryString(c));
        c = BitUtil.setBit(c, 1);
        System.out.println("->setBit(c, 1)->" + BitUtil.toBinaryString(c));
        System.out.println("isBitSet(c, 1):" + BitUtil.isBitSet(c, 1));
        System.out.print("c=" + BitUtil.toBinaryString(c));
        c = BitUtil.clearBit(c, 1);
        System.out.println("->clearBit(c, 1)->" + BitUtil.toBinaryString(c));
        System.out.println("isBitSet(c, 1):" + BitUtil.isBitSet(c, 1));
        System.out.println("------- long ----------");
        System.out.println("lng=" + BitUtil.toBinaryString(l, ","));
        l = BitUtil.setBit(l, 63L);
        System.out.println("->setBit(lng, 63)->\n    " + BitUtil.toBinaryString(l, ","));
        System.out.println("isBitSet(lng, 63):" + BitUtil.isBitSet(l, 63));
        l = BitUtil.clearBit(l, 63);
        System.out.println("->clearBit(lng, 63)->\n    " + BitUtil.toBinaryString(l, ","));
        System.out.println("isBitSet(lng, 63):" + BitUtil.isBitSet(l, 63));
        System.out.println("------- int ----------");
        System.out.print("i=" + BitUtil.toBinaryString(n, "|"));
        n = BitUtil.setBit(n, 20);
        System.out.println("->setBit(i, 20)-> " + BitUtil.toBinaryString(n, "|"));
        System.out.println("isBitSet(i, 20):" + BitUtil.isBitSet(n, 20));
        System.out.print("i=" + BitUtil.toBinaryString(n, "|"));
        n = BitUtil.clearBit(n, 20);
        System.out.println("->clearBit(i,20)->" + BitUtil.toBinaryString(n, "|"));
        System.out.println("isBitSet(i, 20):" + BitUtil.isBitSet(n, 20));
        System.out.println("------- int ----------");
        System.out.print("i=" + BitUtil.toBinaryString(n, "|"));
        n = BitUtil.setBit(n, 31);
        System.out.println("->setBit(i, 31)-> " + BitUtil.toBinaryString(n, "|"));
        System.out.println("isBitSet(i, 31):" + BitUtil.isBitSet(n, 31));
        System.out.print("i=" + BitUtil.toBinaryString(n, "|"));
        n = BitUtil.clearBit(n, 31);
        System.out.println("->clearBit(i,31)->" + BitUtil.toBinaryString(n, "|"));
        System.out.println("isBitSet(i, 31):" + BitUtil.isBitSet(n, 31));
        System.out.println("------- byte ----------");
        System.out.println("b=" + BitUtil.toBinaryString(by));
        by = BitUtil.setBit(by, 7);
        System.out.println("->setBit(b, 7)->" + BitUtil.toBinaryString(by));
        System.out.println("isBitSet(b, 7):" + BitUtil.isBitSet(by, 7));
        System.out.print("b=" + BitUtil.toBinaryString(by));
        by = BitUtil.clearBit(by, 7);
        System.out.println("->clearBit(b, 7)->" + BitUtil.toBinaryString(by));
        System.out.println("isBitSet(b, 7):" + BitUtil.isBitSet(by, 7));
        System.out.println("------- short ----------");
        System.out.print("s=" + BitUtil.toBinaryString(s, "|"));
        s = BitUtil.setBit(s, 10);
        System.out.println("->setBit(s, 10)->" + BitUtil.toBinaryString(s, "|"));
        System.out.println("isBitSet(s, 10):" + BitUtil.isBitSet(s, 10));
        System.out.print("s=" + BitUtil.toBinaryString(s, "|"));
        s = BitUtil.clearBit(s, 10);
        System.out.println("->clearBit(s, 10)->" + BitUtil.toBinaryString(s, "|"));
        System.out.println("isBitSet(s, 10):" + BitUtil.isBitSet(s, 10));
        System.out.println("------- argument checks ----------");
        try {
            BitUtil.setBit(by, 8);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(c, 16);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(s, 16);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(n, 32);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(l, 64L);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(by, 7);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(c, 15);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(s, 15);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(n, 31);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(l, 63L);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(by, -1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(c, -1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(s, -1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(n, -1);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            BitUtil.setBit(l, -1L);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        System.out.println("done...");
    }
}

