/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc.dbo;

import fc.io.IOUtil;
import fc.io.Log;
import fc.io.SystemLog;
import fc.io.TablePrinter;
import fc.jdbc.DBName;
import fc.jdbc.SimpleConnectionMgr;
import fc.jdbc.dbo.ColumnData;
import fc.jdbc.dbo.DBspecific;
import fc.jdbc.dbo.NameWrangle;
import fc.jdbc.dbo.Table;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.util.MiscUtil;
import fc.util.PropertyMgr;
import fc.util.Watch;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Generate {
    static final String nl = IOUtil.LINE_SEP;
    static final String mgrSuffix = "Mgr";
    static final String DBO_BaseClassName = "fc.jdbc.dbo.DBO";
    static final String DBO_MgrBaseClassName = "fc.jdbc.dbo.DBOMgr";
    Date rundate;
    DatabaseMetaData md;
    PropertyMgr props;
    SystemLog log;
    Connection con;
    String url;
    DBName dbname;
    DBspecific dbspecific;
    File outputDir;
    String catalogName;
    String packageName;
    String classVis;
    String fieldVis;
    boolean accessors;
    String[] tableTypesToProcess;
    List tableNamesToInclude;
    Map tableNamesToIncludeAction;
    final int INCLUDE_ANY_PREFIX = 1;
    final int INCLUDE_ANY_SUFFIX = 2;
    final int INCLUDE_CONTAINS = 3;
    final int INCLUDE_EXACT = 4;
    List tableNamesToExclude;
    Map tableNamesToExcludeAction;
    PrintWriter out;
    NameWrangle wrangler;
    int processedTablesCount;
    String validateNull_ErrorMsg = "Error: Required field, please enter a value";
    String validateIntegerOnly_ErrorMsg = "Error: Please enter only numbers in this field";
    String validateText_ErrorMsg_MaxSize = "Not enough or too many characters";
    List tableList;
    StringBuffer strbuf = new StringBuffer(2048);
    String beanClassName;
    String mgrClassName;
    Table table;
    List pklist;
    List fklist;
    String colsCommaDelimString;
    String pkCommaDelimString;
    String fkCommaDelimString;
    String pkFormalParamString;
    boolean modifiableAutoIncrementColumns;
    final HashMap commentMap = new HashMap();

    public Generate(String[] stringArray) throws Exception {
        String string;
        String string2;
        this.log = Log.getDefault();
        this.log.printTimestamp(true);
        this.log.printRelativeTimestamp(true);
        Args args = new Args(stringArray);
        args.setDefaultUsage(this);
        String string3 = args.getRequired("conf");
        this.props = new FilePropertyMgr(new File(string3));
        String string4 = this.props.get("log.level");
        if (string4 != null) {
            this.log.setLevel(string4);
        }
        SimpleConnectionMgr simpleConnectionMgr = new SimpleConnectionMgr(this.props);
        String string5 = simpleConnectionMgr.getDriver().getClass().getName();
        this.dbname = DBName.fromDriver(string5);
        if (this.dbname == null) {
            this.log.bug("dbname=", this.dbname);
            this.log.error("Could not understand the name of the target database. See documentation for more info.");
            System.exit(1);
        }
        this.dbspecific = (DBspecific)Class.forName("fc.jdbc.dbo.DB" + this.dbname.toString().toLowerCase()).newInstance();
        this.url = simpleConnectionMgr.getURL();
        this.con = simpleConnectionMgr.getConnection();
        this.md = this.con.getMetaData();
        this.rundate = new Date();
        String string6 = this.props.get("jdbc.catalog");
        if (string6 == null) {
            string6 = "";
        }
        String string7 = this.props.getRequired("generate.output.dir");
        this.outputDir = new File(string7);
        if (!this.outputDir.isDirectory() || !this.outputDir.canWrite()) {
            this.log.error("Specified output location '" + string7 + "' is not a directory and/or is not writable");
            System.exit(1);
        }
        if (!this.outputDir.exists()) {
            System.out.print("Output directory: " + string7 + " does not exist. Creating..");
            boolean bl = this.outputDir.mkdirs();
            if (!bl) {
                System.out.println("Error creating output directory: " + string7);
                System.exit(1);
            }
            System.out.println("..done");
        }
        this.log.info("Output Directory: ", this.outputDir);
        this.modifiableAutoIncrementColumns = Boolean.valueOf(this.props.get("generate.modifiableAutoIncrementColumns", "false"));
        this.packageName = this.props.get("generate.class_package");
        this.accessors = Boolean.valueOf(this.props.get("generate.accessors", "true"));
        this.classVis = this.props.get("generate.class_vis", "public");
        this.fieldVis = this.accessors ? this.props.get("generate.field_vis", "private") : this.props.get("generate.field_vis", "public");
        String string8 = this.props.get("target.types_to_process");
        if (string8 != null) {
            this.tableTypesToProcess = string8.split(",\\s*");
            for (int i = 0; i < this.tableTypesToProcess.length; ++i) {
                this.tableTypesToProcess[i] = this.tableTypesToProcess[i].toUpperCase();
            }
        }
        if ((string2 = this.props.get("target.tables_to_process")) != null) {
            this.tableNamesToInclude = new ArrayList();
            this.tableNamesToIncludeAction = new HashMap();
            this.createActions(string2, this.tableNamesToInclude, this.tableNamesToIncludeAction);
            this.log.bug("Table names to include:", this.tableNamesToInclude);
            this.log.bug("Table names to include action:", this.tableNamesToIncludeAction);
        }
        if ((string = this.props.get("target.tables_to_ignore")) != null) {
            this.tableNamesToExclude = new ArrayList();
            this.tableNamesToExcludeAction = new HashMap();
            this.createActions(string, this.tableNamesToExclude, this.tableNamesToExcludeAction);
            this.log.bug("Table names to exclude:", this.tableNamesToExclude);
            this.log.bug("Table names to exclude action:", this.tableNamesToExcludeAction);
        }
        this.wrangler = new NameWrangle(this.props, this.log);
        Watch watch = new Watch();
        watch.start();
        this.readTables();
        this.generateCode();
        simpleConnectionMgr.close();
        long l = watch.timeInSeconds();
        System.out.println("Generator processed " + this.processedTablesCount + " table" + (this.processedTablesCount > 1 ? "s" : "") + " in " + l + (l > 1L ? " seconds." : " second."));
    }

    void createActions(String string, List list, Map map) throws Exception {
        String[] stringArray = string.split(",\\s*");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim().toLowerCase();
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray[i].startsWith("*")) {
                if (stringArray[i].length() == 1) {
                    throw new Exception("Bad option in config file.\nIn line: " + string + "\nA star must be a prefix/suffix to a tablename, not standalone.");
                }
                stringArray[i] = stringArray[i].substring(1, stringArray[i].length());
                bl = true;
            }
            if (stringArray[i].endsWith("*")) {
                if (stringArray[i].length() == 1) {
                    throw new Exception("Bad option in config file.\nIn line: " + string + "\nA star must be a prefix/suffix to a tablename, not standalone.");
                }
                stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 1);
                bl2 = true;
            }
            if (bl) {
                if (bl2) {
                    map.put(stringArray[i], 3);
                } else {
                    map.put(stringArray[i], 1);
                }
            } else if (bl2) {
                map.put(stringArray[i], 2);
            } else {
                map.put(stringArray[i], 4);
            }
            list.add(stringArray[i]);
        }
    }

    boolean matchTable(String string, List list, Map map) throws IOException {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            int n = (Integer)map.get(string2);
            if (n == 2) {
                if (!string.startsWith(string2)) continue;
                bl = true;
                break;
            }
            if (n == 1) {
                if (!string.endsWith(string2)) continue;
                bl = true;
                break;
            }
            if (n == 3) {
                if (string.indexOf(string2) == -1) continue;
                bl = true;
                break;
            }
            if (n == 4) {
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
            throw new IOException("Internal error. Unrecognized action = " + n);
        }
        return bl;
    }

    void readTables() throws IOException, SQLException {
        this.tableList = new ArrayList();
        Table.init(this, this.md, this.log, this.props, this.dbspecific);
        String string = null;
        String string2 = "%";
        ResultSet resultSet = this.md.getTables(this.catalogName, string, string2, this.tableTypesToProcess);
        while (resultSet.next()) {
            String string3 = resultSet.getString("TABLE_NAME");
            if (string3.intern() == "") {
                throw new SQLException("The returned tablename was an empty string, looks like the JDBC driver is broken");
            }
            String string4 = string3.toLowerCase();
            boolean bl = false;
            if (this.tableNamesToInclude != null && !(bl = this.matchTable(string4, this.tableNamesToInclude, this.tableNamesToIncludeAction))) {
                this.log.bug("Ignoring table: ", string3);
                continue;
            }
            boolean bl2 = false;
            if (this.tableNamesToExclude != null && (bl2 = this.matchTable(string4, this.tableNamesToExclude, this.tableNamesToExcludeAction))) {
                this.log.bug("Ignoring table (via exclude): ", string3);
                continue;
            }
            if (MiscUtil.isJavaKeyword(string3)) {
                throw new SQLException("The returned tablename [" + string3 + "] is a Java Reserved Keyword. Either change the name in the DB or exclude this table in the config file");
            }
            this.log.info(">>>> Processing table: ", string3);
            ++this.processedTablesCount;
            String string5 = resultSet.getString("TABLE_TYPE");
            String string6 = resultSet.getString("REMARKS");
            Table table = new Table(this.con, this.catalogName, string, string3, string5, string6);
            this.tableList.add(table);
        }
    }

    void generateCode() throws IOException, SQLException {
        for (int i = 0; i < this.tableList.size(); ++i) {
            this.table = (Table)this.tableList.get(i);
            this.pklist = this.table.getPKList();
            this.fklist = this.table.getFKList();
            int n = this.pklist.size();
            StringBuffer stringBuffer = new StringBuffer(128);
            for (int j = 0; j < n; ++j) {
                ColumnData columnData = (ColumnData)this.pklist.get(j);
                stringBuffer.append(columnData.getJavaTypeFromSQLType());
                stringBuffer.append(" ");
                stringBuffer.append(columnData.getName());
                if (j >= n - 1) continue;
                stringBuffer.append(", ");
            }
            this.pkFormalParamString = stringBuffer.toString();
            this.colsCommaDelimString = Table.getListAsString(this.table.getColumnList());
            this.pkCommaDelimString = Table.getListAsString(this.pklist);
            this.fkCommaDelimString = Table.getListAsString(this.fklist);
            this.writeBeanCode();
            this.writeMgrCode();
        }
    }

    void writeBeanCode() throws IOException, SQLException {
        this.beanClassName = this.wrangler.getClassName(this.table.getName());
        String string = this.beanClassName + ".java";
        File file = new File(this.outputDir, string);
        if (file.exists()) {
            file.delete();
        }
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        this.writePackage();
        this.writePrologue();
        this.writeImports();
        this.beanWriteClass();
        this.out.close();
    }

    void writeMgrCode() throws IOException, SQLException {
        this.mgrClassName = this.wrangler.getClassName(this.table.getName()) + mgrSuffix;
        String string = this.mgrClassName + ".java";
        File file = new File(this.outputDir, string);
        if (file.exists()) {
            file.delete();
        }
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        this.writePackage();
        this.writePrologue();
        this.writeImports();
        this.mgrWriteClass();
        this.out.close();
    }

    void writePrologue() {
        String string = this.getClass().getName();
        this.ol("/*");
        this.ol(" * Auto generated on: " + String.valueOf(this.rundate));
        this.ol(" * JDBC url: [" + this.url + "]");
        this.ol(" * WARNING: Manual edits will be lost if/when this file is regenerated.");
        this.ol(" */");
    }

    void writePackage() {
        if (this.packageName != null) {
            this.ol("package " + this.packageName + ";");
            this.ol();
        }
    }

    void writeImports() {
        this.ol("import java.io.*;");
        this.ol("import java.math.*;");
        this.ol("import java.sql.*;");
        this.ol("import java.util.*;");
        this.ol();
        this.ol("import fc.io.*;");
        this.ol("import fc.jdbc.*;");
        this.ol("import fc.jdbc.dbo.*;");
        this.ol("import fc.util.*;");
        this.ol("import fc.web.forms.*;");
        this.ol();
    }

    String getBeanComment(ColumnData columnData) throws SQLException {
        Object object = (String)this.commentMap.get(columnData);
        if (object != null) {
            return object;
        }
        object = "/** " + columnData.getSQLTypeDriverSpecificName() + " (" + columnData.getSQLTypeName() + ")";
        if (columnData.isPK()) {
            object = (String)object + "; PK=yes";
        }
        if (columnData.isFK()) {
            ColumnData.FKData fKData = columnData.getFK();
            object = (String)object + "; FK=yes, refers to: " + fKData.getPKTableName() + "." + fKData.getPKColName();
        }
        object = (String)object + "; Nullable=" + columnData.isNullable();
        object = (String)object + "; AutoInc=" + columnData.isAutoIncrement();
        object = (String)object + "; MaxSize=" + columnData.getSize();
        if (columnData.hasRemarks()) {
            object = (String)object + "; Remarks: " + columnData.getRemarks();
        }
        object = (String)object + " */";
        this.commentMap.put(columnData, object);
        return object;
    }

    void beanWriteClass() throws SQLException {
        this.ol("/**");
        this.o("Represents a row in the  ");
        this.o(this.table.getName());
        this.ol(" table. ");
        String string = this.table.getRemarks();
        if (string != null) {
            this.ol("<p><b>Table Remarks: </b>");
            this.ol(string);
        }
        this.ol("*/");
        this.o(this.classVis + " class ");
        this.o(this.beanClassName);
        this.o(" extends ");
        this.ol(DBO_BaseClassName);
        this.ol("{");
        this.beanWriteConstructor();
        this.beanWriteDBFields();
        this.beanWriteDBFieldsTracking();
        this.beanWriteMiscMethods();
        this.beanWriteGetSet();
        this.beanWriteIncDec();
        this.ol("}");
    }

    void beanWriteConstructor() {
        this.ol("/* Default constructor */");
        this.o(this.classVis);
        this.o(" ");
        this.o(this.beanClassName);
        this.ol("()");
        this.ol("\t{");
        this.ol("\tthis.__isNew \t= true;");
        this.ol("\t}");
        this.ol();
    }

    void beanWriteDBFields() throws SQLException {
        List list = this.table.getColumnList();
        this.ol("/*--------------------- Columns ------------------------*/");
        TablePrinter.PrintConfig printConfig = new TablePrinter.PrintConfig();
        printConfig.setPrintBorders(false);
        printConfig.setCellSpacing(1);
        printConfig.setCellPadding(0);
        printConfig.setAutoFit(true);
        TablePrinter tablePrinter = new TablePrinter(4, this.out, printConfig);
        tablePrinter.startTable();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            this.log.bug("Processing column: ", columnData);
            tablePrinter.startRow();
            tablePrinter.printCell(this.fieldVis);
            tablePrinter.printCell(columnData.getJavaTypeFromSQLType());
            tablePrinter.printCell(columnData.getName() + ";");
            tablePrinter.printCell(this.getBeanComment(columnData));
            tablePrinter.endRow();
        }
        tablePrinter.endTable();
        this.ol("/*------------------------------------------------------*/");
    }

    void beanWriteDBFieldsTracking() throws SQLException {
        if (this.pklist.size() > 0) {
            this.ol("/*");
            this.ol("Original PK saved here for updates. If a row is retrieved from the database and");
            this.ol("the PK value is changed, and then if the object is saved, we need the orignal PK");
            this.ol("value to find the row in the db for our update to work.");
            this.ol("*/");
            for (int i = 0; i < this.pklist.size(); ++i) {
                ColumnData columnData = (ColumnData)this.pklist.get(i);
                this.o(columnData.getJavaTypeFromSQLType());
                this.o(" __orig_");
                this.o(columnData.getName());
                this.ol(";");
            }
        }
        this.ol();
        this.ol("\t\tboolean __force_update\t= false;");
        this.ol("private\tMap\t\t__extra_data;\t\t\t");
        this.ol("private boolean __isNew\t\t\t= false;");
        this.ol("private boolean __isModified\t= false;");
        List list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            this.ol();
            ColumnData columnData = (ColumnData)list.get(i);
            String string = columnData.getName();
            this.o("private   boolean __isModified_");
            this.o(string);
            this.ol(" = false;");
            if (columnData.isNullable() && columnData.usesPrimitiveJavaType()) {
                this.ol("/* this primitive type is nullable, this tracks whether we should save it as null to the database*/");
                this.o("private   boolean __isModified_");
                this.o(string);
                this.ol("_setnull = false;");
            }
            this.o("protected boolean __isNullInDB_");
            this.o(string);
            this.ol(" = false;");
            this.o("/**returns <tt>true</tt> if ");
            this.o(string);
            this.o(" has changed since it was created/loaded, <tt>false</tt> otherwise");
            this.ol("*/");
            this.o("public boolean ");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.o("() { return this.__isModified_");
            this.o(string);
            this.ol("; }");
            if (columnData.isNullable() && columnData.usesPrimitiveJavaType()) {
                this.o("/**returns <true> is primitive type ");
                this.o(string);
                this.ol(" has been set to null via the setNull mechanism*/");
                this.o("public boolean ");
                this.o(this.wrangler.getIsModifiedNullName(columnData));
                this.o("() { return this.__isModified_");
                this.o(string);
                this.ol("_setnull; }");
            }
            this.o("/**returns <tt>true</tt> if ");
            this.o(string);
            this.o(" was null in the database");
            this.ol("*/");
            this.o("public boolean ");
            this.o(this.wrangler.getIsNullInDBName(columnData));
            this.o("() { return this.__isNullInDB_");
            this.o(string);
            this.ol("; }");
        }
    }

    void beanWriteMiscMethods() throws SQLException {
        String string;
        ColumnData columnData;
        int n;
        this.ol();
        this.ol();
        this.ol("/** returns <tt>true</tt> if this object is newly created and has <b>not</b> been loaded from the database, <tt>false</tt> otherwise */");
        this.ol("public boolean isNew() ");
        this.ol("\t{");
        this.ol("\treturn this.__isNew;");
        this.ol("\t}");
        this.ol();
        this.ol("/** Specify <tt>true</tt> to set this object's status as newly created (and not read from a database) */");
        this.ol("protected void setNew(boolean val) ");
        this.ol("\t{");
        this.ol("\tthis.__isNew = val;");
        this.ol("\t}");
        this.ol();
        this.ol("/** returns <tt>true</tt> if this object's data (for any field) has changed since it was created/loaded, <tt>false</tt> otherwise */");
        this.ol("public boolean isModified() ");
        this.ol("\t{");
        this.ol("\treturn this.__isModified;");
        this.ol("\t}");
        this.ol();
        this.ol("/** Resets the modified status of this object to not-modified");
        this.ol("this is useful when loading an object via a prepared statement");
        this.ol("(by using various setXXX methods when we do so, we inadvertently");
        this.ol("set the modified status of each field to true)");
        this.ol("*/");
        this.ol("void resetModified() ");
        this.ol("\t{");
        List list = this.table.getColumnList();
        this.ol("\tthis.__isModified = false;");
        for (n = 0; n < list.size(); ++n) {
            columnData = (ColumnData)list.get(n);
            string = columnData.getName();
            this.o("\tthis.__isModified_");
            this.o(string);
            this.ol(" = false;");
            if (!columnData.isNullable() || !columnData.usesPrimitiveJavaType()) continue;
            this.o("\tthis.__isModified_");
            this.o(string);
            this.ol("_setnull = false;");
        }
        this.ol("\t}");
        this.ol();
        this.ol("/**");
        this.ol("Allows putting arbitrary object-specific data into this object.");
        this.ol("This is useful to store additional query-specific columns when performing");
        this.ol("arbitrary queries. For example: ");
        this.ol("<blockquote><pre>");
        this.o("String query = \"select <font color=blue>1+1 as my_sum, \n\t\tnow() as my_time</font>, ");
        this.o(this.table.getName());
        this.o("Mgr.columns() \n\t\tfrom ");
        this.o(this.table.getName());
        this.ol("\";");
        this.ol("PreparedStatement ps = con.prepareStatment(query);");
        this.ol("ResultSet rs = ps.executeQuery();");
        this.ol("List list = new ArrayList();");
        this.ol("while (rs.next()) {");
        this.o("\t<font color=green>");
        this.o(this.table.getName());
        this.o("</font> obj = ");
        this.o(this.table.getName());
        this.ol("Mgr.getFromRS(rs);");
        this.ol("\tobj.<font color=blue>putExtraData(\"my_sum\"</font>, rs.getInt(\"my_sum\"));");
        this.ol("\tobj.<font color=blue>putExtraData(\"my_time\"</font>, rs.getDate(\"my_time\"));");
        this.ol("\t}");
        this.o("//use the list later on...each <font color=green>");
        this.o(this.table.getName());
        this.ol(" </font>object in the list will ");
        this.ol("//have the extra data..");
        this.ol("</pre></blockquote>");
        this.ol("*/");
        this.ol("public void putExtraData(Object key, Object value) ");
        this.ol("\t{");
        this.ol("\tsynchronized (this) {");
        this.ol("\t\tif (__extra_data == null) {");
        this.ol("\t\t\t__extra_data = new HashMap();");
        this.ol("\t\t\t}");
        this.ol("\t\t}");
        this.ol("\t__extra_data.put(key, value);");
        this.ol("\t}");
        this.ol("/*Alias for the {@link putExtraData} method */");
        this.ol("public void put(Object key, Object value) ");
        this.ol("\t{");
        this.ol("\tputExtraData(key, value);");
        this.ol("\t}");
        this.ol();
        this.ol("/**");
        this.ol("Allows retrieving arbitrary object-specific data from this object.");
        this.ol("This data should have been put via the {@link #putExtraData putExtraData} ");
        this.ol("method prior to invoking this method");
        this.ol("*/");
        this.ol("public Object getExtraData(Object key) ");
        this.ol("\t{");
        this.ol("\tsynchronized (this) {");
        this.ol("\t\tif (__extra_data == null) {");
        this.ol("\t\t\treturn null;");
        this.ol("\t\t\t}");
        this.ol("\t\t}");
        this.ol("\treturn __extra_data.get(key);");
        this.ol("\t}");
        this.ol("/*Alias for the {@link getExtraData} method */");
        this.ol("public Object get(Object key) ");
        this.ol("\t{");
        this.ol("\treturn getExtraData(key);");
        this.ol("\t}");
        this.ol();
        this.ol("public String toString() ");
        this.ol("\t{");
        this.ol("\tfinal String nl = fc.io.IOUtil.LINE_SEP;");
        this.ol("\tStringBuffer buf = new StringBuffer(256);");
        this.o("\tbuf.append(\"Class Name: [");
        this.o(this.beanClassName);
        this.ol("]\");");
        this.ol("\tbuf.append(\" [isDiscarded=\").append(this.isDiscarded()).append(\"]\");");
        this.ol("\tbuf.append(\" [isNew=\").append(this.isNew()).append(\"]\");");
        this.ol("\tbuf.append(\" [isModified=\").append(this.isModified()).append(\"]\");");
        this.ol("\tbuf.append(nl);");
        this.ol("\tbuf.append(\"Note: IsNullInDB only meaningful for existing rows (i.e., isNew=false)\");");
        this.ol("\tbuf.append(nl);");
        this.ol();
        this.ol("\tByteArrayOutputStream out = new ByteArrayOutputStream(768);");
        this.ol("\tTablePrinter.PrintConfig config = new TablePrinter.PrintConfig();");
        this.ol("\tconfig.setPrintBorders(false);");
        this.ol("\tconfig.setCellSpacing(1);");
        this.ol("\tconfig.setCellPadding(0);");
        this.ol("\tconfig.setAutoFit(true);");
        this.ol("\tTablePrinter p = new TablePrinter(7, new PrintStream(out), config);");
        this.ol("\tp.startTable();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"PK\");");
        this.ol("\tp.printCell(\"FK\");");
        this.ol("\tp.printCell(\"Field\");");
        this.ol("\tp.printCell(\"Value\");");
        this.ol("\tp.printCell(\"isModified\");");
        this.ol("\tp.printCell(\"isNullinDB\");");
        this.ol("\tp.printCell(\"isSerial/AutoInc\");");
        this.ol("\tp.endRow();");
        for (n = 0; n < list.size(); ++n) {
            Object object;
            columnData = (ColumnData)list.get(n);
            string = columnData.isPK() ? "x" : "-";
            Object object2 = "-";
            if (columnData.isFK()) {
                object = columnData.getFK();
                object2 = "x [" + ((ColumnData.FKData)object).getPKTableName() + "." + ((ColumnData.FKData)object).getPKColName() + "]";
            }
            object = columnData.getName();
            String string2 = "String.valueOf(this." + (String)object + ")";
            String string3 = "(this.__isModified_" + (String)object + ")";
            String string4 = "(this.__isNullInDB_" + (String)object + ")";
            String string5 = columnData.isAutoIncrement() ? "x" : "-";
            this.ol();
            this.ol("\tp.startRow();");
            this.o("\tp.printCell(\"");
            this.o(string);
            this.ol("\");");
            this.o("\tp.printCell(\"");
            this.o((String)object2);
            this.ol("\");");
            this.o("\tp.printCell(\"");
            this.o((String)object);
            this.ol("\");");
            this.o("\tp.printCell(");
            this.o(string2);
            this.ol(");");
            this.o("\tp.printCell(");
            this.o(string3);
            this.ol(" ?\"x\":\"-\");");
            this.o("\tp.printCell(");
            this.o(string4);
            this.ol(" ?\"x\":\"-\");");
            this.o("\tp.printCell(\"");
            this.o(string5);
            this.ol("\");");
            this.ol("\tp.endRow();");
        }
        this.ol();
        this.ol("\tp.endTable();");
        this.ol("\tbuf.append(out.toString());");
        this.ol("\treturn buf.toString();");
        this.ol("\t}");
        this.ol();
        this.ol("/**");
        this.ol("Returns a map of all fields-&gt;values (as Strings) contained in this");
        this.ol("object. This is useful when sending auto converting the object to JSON, etc.");
        this.ol("*/");
        this.ol("public Map allFieldsMap() ");
        this.ol("\t{");
        this.ol("\tfinal HashMap m = new HashMap();");
        for (n = 0; n < list.size(); ++n) {
            columnData = (ColumnData)list.get(n);
            string = columnData.getName();
            this.o("\tm.put(\"");
            this.o(string);
            this.o("\", ");
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("(");
                this.o(string);
                this.o(" == null ? null : ");
                this.o("String.valueOf(this.");
                this.o(string);
                this.o(")");
                this.o(")");
            } else if (columnData.isNullable()) {
                this.ol();
                this.o("\t\t( __isModified_");
                this.o(string);
                this.ol(" ? ");
                this.o("\t\t\t( __isModified_");
                this.o(string);
                this.o("_setnull ? null : ");
                this.o("String.valueOf(this.");
                this.o(string);
                this.o(") )");
                this.ol(" : ");
                this.o("\t\t\t( __isNullInDB_");
                this.o(string);
                this.o(" ? null : ");
                this.o("String.valueOf(this.");
                this.o(string);
                this.o(")))");
            } else {
                this.o("String.valueOf(this.");
                this.o(string);
                this.o(")");
            }
            this.ol(");");
        }
        this.ol("\treturn m;");
        this.ol("\t}");
        this.ol();
    }

    void beanWriteGetSet() throws SQLException {
        List list = this.table.getColumnList();
        this.ol("/* ============== Gets and Sets ============== */");
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            this.ol();
            this.ol(this.getBeanComment(columnData));
            String string = columnData.getName();
            this.o("public ");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            this.o(this.wrangler.getGetName(columnData));
            this.ol("()  { ");
            this.o("\treturn ");
            this.o(string);
            this.ol(";");
            this.ol("\t}");
            this.ol();
            this.ol(this.getBeanComment(columnData));
            if (columnData.isAutoIncrement() && !this.modifiableAutoIncrementColumns) {
                this.o("/* Generating set for ");
                this.o(this.wrangler.getSetName(columnData));
                this.ol(" with non public access since it's an auto-increment column */");
            } else {
                this.o("public");
            }
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getSetName(columnData));
            this.o("(");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            this.o(string);
            this.ol(")\t{");
            this.ol("\tthis." + string + " = " + string + ";");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            if (!columnData.isNullable() && !columnData.usesPrimitiveJavaType()) {
                this.o("\tif (");
                this.o(string);
                this.ol(" == null) {");
                this.o("\t\tLog.getDefault().warn(\"");
                this.o(string);
                this.o(" was set to null via ");
                this.o(this.beanClassName);
                this.o(".");
                this.o(this.wrangler.getSetName(columnData));
                this.ol("() and it is non-nullable in the database. Queries using this object will not work properly and you will get a runtime error if saving this object\");");
                this.ol("\t\t}");
            }
            this.ol("\treturn this;");
            this.ol("\t}");
            if (!columnData.isNullable() || !columnData.usesPrimitiveJavaType()) continue;
            if (columnData.isAutoIncrement() && !this.modifiableAutoIncrementColumns) {
                this.o("/* Generating setNull for ");
                this.o(this.wrangler.getSetNullName(columnData));
                this.ol(" with non public access since it's an auto-increment column */");
            } else {
                this.o("public");
            }
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getSetNullName(columnData));
            this.ol("()");
            this.ol("\t{");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified_" + string + "_setnull = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
        }
    }

    void beanWriteIncDec() throws SQLException {
        List list = this.table.getColumnList();
        this.ol();
        this.ol("/* =========== Increments / Decrements =========== */");
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            if (!columnData.usesSimpleIntegralJavaType() || columnData.isAutoIncrement() && !this.modifiableAutoIncrementColumns || columnData.isPK() || columnData.isFK()) continue;
            this.ol();
            String string = columnData.getName();
            this.o("/** ");
            this.o("Increments ");
            this.o(string);
            this.o(" by 1");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getIncName(columnData));
            this.ol("() {");
            this.ol("\tthis." + string + " = this." + string + " + 1;");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
            this.ol();
            this.o("/** ");
            this.o("Increments ");
            this.o(string);
            this.o(" by the specified amount");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getIncName(columnData));
            this.o("(");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" amount");
            this.ol(") {");
            this.ol("\tthis." + string + " = this." + string + " + amount;");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
            this.ol();
            this.o("/** ");
            this.o("Increments ");
            this.o(string);
            this.o(" by the specified amount, upto but not above the upper bound (bound is inclusive)");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getIncName(columnData));
            this.o("(");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" amount, int upper_bound");
            this.ol(") {");
            this.ol("\tthis." + string + " = Math.min(this." + string + " + amount, upper_bound);");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
            this.ol();
            this.o("/** ");
            this.o("Decrements ");
            this.o(string);
            this.o(" by 1");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getDecName(columnData));
            this.ol("() {");
            this.ol("\tthis." + string + " = this." + string + " - 1;");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
            this.ol();
            this.o("/** ");
            this.o("Decrements ");
            this.o(string);
            this.o(" by the specified amount");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getDecName(columnData));
            this.o("(");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" amount");
            this.ol(") {");
            this.ol("\tthis." + string + " = this." + string + " - amount;");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
            this.ol();
            this.o("/** ");
            this.o("Decrements ");
            this.o(string);
            this.o(" by the specified amount, upto but not below the lower bound (bound is inclusive)");
            this.ol(" */");
            this.o("public");
            this.o(" ");
            this.o(this.beanClassName);
            this.o(" ");
            this.o(this.wrangler.getDecName(columnData));
            this.o("(");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" amount, int lower_bound");
            this.ol(") {");
            this.ol("\tthis." + string + " = Math.max(this." + string + " - amount, lower_bound);");
            this.ol("\tthis.__isModified_" + string + " = true;");
            this.ol("\tthis.__isModified = true;");
            this.ol("\treturn this;");
            this.ol("\t}");
        }
    }

    void mgrWriteClass() throws SQLException {
        this.ol("/**");
        this.o("Manages various operations on the ");
        this.o(this.table.getName());
        this.ol(" table. ");
        this.ol();
        this.ol("<p>Most methods of this class take a {@link java.sql.Connection Connection} as an argument");
        this.ol("and use that connection to run various queries. The connection parameter is never closed");
        this.ol("by methods in this class and that connection can and should be used again. Methods of this");
        this.ol("class will also throw a <tt>IllegalArgumentException</tt> if the specified connection");
        this.ol("object is <tt>null</tt>.");
        this.ol();
        this.ol("<p>Thread Safety: Operations on this class are by and large thread safe in that multiple");
        this.ol("threads can call the methods at the same time. However, seperate threads should use");
        this.ol("seperate connection objects when invoking methods of this class.");
        this.ol("*/");
        this.o(this.classVis + " final class " + this.mgrClassName);
        this.o(" extends ");
        this.ol(DBO_MgrBaseClassName);
        this.ol("{");
        this.mgrWriteFields();
        this.mgrWriteConstructor();
        this.mgrWriteMethods();
        this.ol("}");
    }

    void mgrWriteConstructor() {
        this.ol();
        this.ol("/** Constructor is private since class is never instantiated */");
        this.o("private ");
        this.o(this.mgrClassName);
        this.ol("() {");
        this.ol("\t}");
        this.ol();
    }

    void mgrWriteFields() throws SQLException {
        this.ol("/* --- Fields used for collecting usage statistics --- ");
        this.ol("Increments to these don't need to be synchronized since these are");
        this.ol("ints and not longs and memory visibility is not an issue in the");
        this.ol("toString() method (in which these are read).");
        this.ol("*/");
        this.ol("private static int __getall_called = 0;");
        this.ol("private static int __getlimited_called = 0;");
        this.ol("private static int __getbykey_called = 0;");
        this.ol("private static int __getwhere_called = 0;");
        this.ol("private static int __getusing_called = 0;");
        this.ol("private static int __getusing_ps_called = 0;");
        this.ol("private static int __getfromrs_called = 0;");
        this.ol("private static int __save_called = 0;");
        this.ol("private static int __delete_called = 0;");
        this.ol("private static int __deletebykey_called = 0;");
        this.ol("private static int __deletewhere_called = 0;");
        this.ol("private static int __deleteusing_called = 0;");
        this.ol("private static int __count_called = 0;");
        this.ol("private static int __countwhere_called = 0;");
        this.ol("private static int __countusing_called = 0;");
        this.ol("private static int __exists_called = 0;");
        this.ol("/* -------------- end statistics fields -------------- */");
    }

    void mgrWriteMethods() throws SQLException {
        this.mgrWriteMethodGetAll();
        this.mgrWriteMethodGetAllNoClause();
        this.mgrWriteMethodGetLimited();
        this.mgrWriteMethodGetByKey();
        this.mgrWriteMethodGetWhere();
        this.mgrWriteMethodGetUsing();
        this.mgrWriteMethodGetUsingNoClause();
        this.mgrWriteMethodGetUsingPS();
        this.mgrWriteMethodGetUsingNamedPS();
        this.mgrWriteMethodGetColumnNames();
        this.mgrWriteMethodGetColumnNames2();
        this.mgrWriteMethodGetFromRS();
        this.mgrWriteMethodGetFromRS2();
        this.mgrWriteMethodGetFromRS1Table();
        this.mgrWriteMethodDecodeFromRS();
        this.mgrWriteMethodSave();
        this.mgrWriteMethodUpdate();
        this.mgrWriteMethodDelete();
        this.mgrWriteMethodDeleteByKey();
        this.mgrWriteMethodDeleteUsing();
        this.mgrWriteMethodDeleteUsingNoClause();
        this.mgrWriteMethodDeleteWhere();
        this.mgrWriteMethodCount();
        this.mgrWriteMethodCountWhere();
        this.mgrWriteMethodCountUsing();
        this.mgrWriteMethodCountUsingNoClause();
        this.mgrWriteMethodExists();
        this.mgrWriteMethodExistsUsing();
        this.mgrWriteMethodPrepareStatement();
        this.mgrWriteCheckDiscarded();
        this.mgrWriteMethodStats();
        this.mgrWriteMethodToString();
        this.mgrWriteValidators();
    }

    final void mgrWriteMethodGetAll() {
        this.ol();
        this.o("static private final String getAllStmt = \"SELECT ");
        this.o(this.colsCommaDelimString);
        this.o(" from ");
        this.o(this.table.getName());
        this.ol("\";");
        this.ol("/** ");
        this.ol("Returns all rows in the table. Use with care for large tables since");
        this.ol("this method can result in VM out of memory errors. <p>This method");
        this.ol("also takes an optional (can be null) <tt>clause</tt> parameter which");
        this.ol("is sent as is to the database. For example, a clause can be:");
        this.ol("<blockquote><pre>");
        this.ol("order by some_column_name");
        this.ol("</pre> </blockquote>");
        this.o("@return \ta list containing {@link ");
        this.o(this.beanClassName);
        this.o(" } objects <i>or an empty list</i> if there are no rows in the database");
        this.ol("*/");
        this.ol("public static List getAll(final Connection con, final String clause) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getall_called++;");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal String getAllStmtClaused = (clause == null) ? ");
        this.ol("\t\t\t\t\t\t   getAllStmt : getAllStmt + \" \" + clause;");
        this.ol("\tPreparedStatement ps = prepareStatement(con, getAllStmtClaused);");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " bean = decodeFromRS(rs);");
        this.ol("\t\tif (bean == null) { break; } ");
        this.ol("\t\tlist.add(bean);");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetAllNoClause() {
        this.ol();
        this.ol("/** ");
        this.o("Convenience method that invokes {@link getAll(Connection, ");
        this.o(this.beanClassName);
        this.ol(", String) getAll} with an empty additional clause.");
        this.ol("*/");
        this.o("public static List getAll(final Connection con) ");
        this.ol("throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\treturn getAll(con, null);");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetLimited() {
        this.ol();
        this.o("static private final String getLimitedStmt = \"SELECT ");
        this.o(this.colsCommaDelimString);
        this.o(" from ");
        this.o(this.table.getName());
        this.ol("\";");
        this.ol("/** ");
        this.ol("Returns all rows in the table starting from some row number and limited");
        this.ol("by a certain number of rows after that starting row. ");
        this.ol("<p>");
        this.ol("This method takes a required (non-null) <code>order_clause</code>, since when using");
        this.ol("a limit clause, rows must be ordered for the limit to make sense. The");
        this.ol("clause should be of the form <font color=blue>order by ...</font>");
        this.ol("<p>");
        this.ol("The <code>limit</code> specifies the number of rows that will be returned. (those many");
        this.ol("or possibly lesser rows will be returned, if the query itself yields less");
        this.ol("rows).");
        this.ol("<p>");
        this.ol("The <code>offset</code> skips that many rows before returning rows. A zero offset is");
        this.ol("the same as a traditional query with no offset clause, where rows from");
        this.ol("the beginning are returned. If say, offset = 10, then rows starting from");
        this.ol("row 11 will be returned.");
        this.ol("<p>");
        this.ol("The sql-query generated by this method is database specific but will (typically) look like:");
        this.ol("<blockquote><pre>");
        this.ol("select &lt;column_list&gt; from &lt;table&gt; order by &lt;clause&gt; limit 5 offset 10");
        this.ol("</pre> </blockquote>");
        this.o("@return \ta list containing {@link ");
        this.o(this.beanClassName);
        this.o(" } objects <i>or an empty list</i> if there are no rows in the database");
        this.ol("*/");
        this.ol("public static List getLimited(final Connection con, final String order_clause, int limit, int offset) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getlimited_called++;");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal String tmp = getLimitedStmt + \" \" + order_clause + \" LIMIT \" + limit + \" OFFSET \" + offset;");
        this.ol("\tPreparedStatement ps = prepareStatement(con, tmp);");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " bean = decodeFromRS(rs);");
        this.ol("\t\tif (bean == null) { break; } ");
        this.ol("\t\tlist.add(bean);");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetByKey() throws SQLException {
        this.ol();
        if (this.pklist.size() == 0) {
            this.ol("/* getByKey() not implemented since this table does not have any primary keys defined */");
            return;
        }
        this.o("static private final String getByPKStmt = \"SELECT ");
        this.o(this.colsCommaDelimString);
        this.o(" from ");
        this.o(this.table.getName());
        this.o(" WHERE ");
        this.o(Table.getPreparedStmtPlaceholders(this.pklist));
        this.ol("\";");
        this.ol("/** ");
        this.ol("Returns <b>the</b> row corresponding to the specified primary key(s) of this table ");
        this.ol("or <b><tt>null</tt></b> if no row was found.");
        this.ol("<p>This method uses a prepared statement and is safe from SQL injection attacks");
        this.ol("*/");
        this.o("public static ");
        this.o(this.beanClassName);
        this.o(" getByKey(final Connection con, ");
        this.o(this.pkFormalParamString);
        this.ol(") throws SQLException");
        this.ol("\t{");
        this.ol("\t__getbykey_called++;");
        this.ol("\tPreparedStatement ps = prepareStatement(con, getByPKStmt);");
        this.ol("\tStringBuilder errbuf = null;");
        this.ol();
        for (int i = 0; i < this.pklist.size(); ++i) {
            ColumnData columnData = (ColumnData)this.pklist.get(i);
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("\tif (");
                this.o(columnData.getName());
                this.ol(" == null) {");
                this.ol("\t\tif (errbuf == null) { errbuf = new StringBuilder(); }");
                this.o("\t\terrbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" was set to null (but is non-nullable)\").append(IOUtil.LINE_SEP);");
                this.ol("\t\t}");
                this.ol();
            } else {
                this.o("\t//");
                this.o(columnData.getName());
                this.o(" [");
                this.o(columnData.getJavaTypeFromSQLType());
                this.ol("] is primitive, skipping null test");
            }
            String string = columnData.getName();
            this.o("\t");
            String string2 = String.valueOf(i + 1);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", string2, string));
        }
        this.ol("\t");
        this.ol("\tif (errbuf != null) {");
        this.ol("\t\tthrow new ValidateException(errbuf.toString());");
        this.ol("\t\t}");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\t" + this.beanClassName + " bean = decodeFromRS(rs);");
        this.ol("\trs.close();");
        this.ol("\treturn bean;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetWhere() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.ol("Returns the rows returned by querying the table with the specified");
        this.ol("<tt>WHERE</tt> clause or <i>an empty list</i> if no rows were found.");
        this.ol("(note: the string <tt>\"WHERE\"</tt> does <b>not</b> have to be");
        this.ol("specified in the clause. It is added automatically by this method).");
        this.ol("<p>Queries can use database functions such as: <code>lower()</code>,");
        this.ol("<code>upper()</code>, <code>LIKE</code> etc. For example:");
        this.o("<pre><blockquote>");
        this.o(this.table.getName());
        this.ol("Mgr.getWhere(\"lower(col_a) = 'foo'\")");
        this.ol("//compares the lower case value of col_a with the string 'foo'");
        this.ol("</blockquote></pre>");
        this.ol("<p><b>The \"where\" clause is sent as-is to the database</b>. SQL");
        this.ol("injection attacks are possible if it is created as-is from a <b><u>untrusted</u></b> source.");
        this.ol();
        this.ol("@throws\tIllegalArgumentException if the specified <tt>where</tt> parameter is null");
        this.ol("*/");
        this.ol("public static List getWhere(final Connection con, final String where) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getwhere_called++;");
        this.ol("\tArgcheck.notnull(where, \"the where parameter was null (and should not be null)\");");
        this.ol("\tfinal String where_stmt = \"SELECT " + this.colsCommaDelimString + " from " + this.table.getName() + " WHERE \" + where ;");
        this.ol("\tStatement stmt = QueryUtil.getRewindableStmt(con);");
        this.ol("\tlog.bug(\"Query to run: \", stmt, \" \", where_stmt);");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal ResultSet rs = stmt.executeQuery(where_stmt);");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " bean = decodeFromRS(rs);");
        this.ol("\t\tif (bean == null) { break; } ");
        this.ol("\t\tlist.add(bean);");
        this.ol("\t\t}");
        this.ol("\tstmt.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetUsing() throws SQLException {
        List list;
        this.ol();
        this.ol("/** ");
        this.ol("Returns the rows returned by querying the table with the value of the");
        this.o("specified <tt>");
        this.o(this.beanClassName);
        this.ol("</tt> object or <i>an empty list</i> if no rows were found. As many");
        this.ol("fields in <tt>alltypes</tt> can be set as needed and the values of");
        this.ol("all set fields (including fields explicitly set to <tt>null</tt>)");
        this.ol("are then used to perform the query.");
        this.ol("<p>");
        this.ol("This method is often convenient/safer than the {@link #getWhere");
        this.ol("getWhere} method (because the <tt>getWhere</tt> method takes an");
        this.ol("arbitrary query string which has to be properly escaped by the");
        this.ol("user).");
        this.ol("<p>Essentially, this method is a more convenient way to use a");
        this.ol("PreparedStatement. Internally, a prepared statement is created and");
        this.ol("it's parameters are set to fields that are set in this object).");
        this.ol("Using PreparedStatements directly is also perfectly fine. For");
        this.ol("example, the following are equivalent. ");
        this.ol("<p> Using a PreparedStatement:");
        this.ol("<blockquote><pre>");
        this.ol("String foo = \"select * from table_foo where x = ? and y = ?\";");
        this.ol("PreparedStatement ps = con.prepareStatement(foo);");
        this.ol("ps.setString(1, \"somevalue\");");
        this.ol("ps.setString(2, \"othervalue\");");
        this.ol("ResultSet rs  = ps.executeUpdate();");
        this.ol("while (rs.next()) {");
        this.ol("    table_foo bean = table_fooMgr.getFromRS(rs);");
        this.ol("    }");
        this.ol("</pre> </blockquote>");
        this.ol("");
        this.ol("Using this method:");
        this.ol("<blockquote><pre>");
        this.ol("table_foo <font color=blue>proto</font> = new table_foo();");
        this.ol("proto.set_x(\"somevalue\");\t//compile time safety");
        this.ol("proto.set_y(\"othervalue\");\t//compile time safety");
        this.ol("List beans = table_fooMgr.<font color=blue>getUsing(proto)</font>;");
        this.ol("</pre> </blockquote>");
        this.ol("<p>This method also takes an <tt>clause</tt> parameter which");
        this.ol("is sent as is to the database. For example, a clause can be:");
        this.ol("<blockquote><pre>");
        this.ol("List beans = table_fooMgr.<font color=blue>getUsing(proto, <b>\"order by some_column_name\"</b>)</font>;");
        this.ol("</pre> </blockquote>");
        this.ol("This clause is optional. Specify <tt>null</tt> to not use it at all.");
        this.ol("If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.");
        this.ol();
        this.ol("The fields that are set in the proto object (as shown above) are sent as");
        this.ol("part of a WHERE clause constructed internally. If you are specifying a clause");
        this.ol("as well, you should not specify the word <tt>WHERE</tt>. However, you may have");
        this.ol("to specify <tt>AND</tt> to add to the internal WHERE clause, if you have set any");
        this.ol("fields in the proto object. For example");
        this.ol("<blockquote><pre>");
        this.ol("List beans = table_fooMgr.<font color=blue>getUsing(proto, <b>\"and bar = 5\"</b>)</font>;");
        this.ol("</pre> </blockquote>");
        this.ol("<p>Note: For a <i>very</i> large number of rows, it may be more");
        this.ol("efficient to use a prepared statement directly (as opposed to using");
        this.ol("this method). In most cases, this is not something to worry about,");
        this.ol("but your mileage may vary...");
        this.ol("*/");
        this.o("public static List getUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean, final String clause) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\t__getusing_called++;");
        this.ol("\tArgcheck.notnull(bean, \"the bean parameter was null (and should not be null)\");");
        this.ol("\tif (! bean.isModified()) { ");
        this.ol("\t\tthrow new ValidateException(\"bean=\" + bean + \" not modified, ignoring query\");");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tint __count = 0;");
        this.ol("\tfinal StringBuilder buf = new StringBuilder(512);");
        this.ol("\tbuf.append(\"SELECT " + this.colsCommaDelimString + " from " + this.table.getName() + " WHERE \");");
        List list2 = list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            this.o("\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) { ");
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("() == null) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else if (columnData.isNullable()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getIsModifiedNullName(columnData));
                this.ol("()) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else {
                this.o("\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t__count++;");
            }
            this.ol("\t\t}");
        }
        this.ol();
        this.ol("\tbuf.setLength(buf.length() - 4);");
        this.ol();
        this.ol("\tif (clause != null) {");
        this.ol("\t\tbuf.append(\" \");");
        this.ol("\t\tbuf.append(clause);");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tfinal String getUsingPKStmt = buf.toString();");
        this.ol("\tPreparedStatement ps = prepareStatement(con, getUsingPKStmt);");
        this.utilFillPStmtFromList_IfModified_Object(list2, "\t");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " row = decodeFromRS(rs);");
        this.ol("\t\tif (row == null) { break; } ");
        this.ol("\t\tlist.add(row);");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetUsingNoClause() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Convenience method that invokes {@link getUsing(Connection, ");
        this.o(this.beanClassName);
        this.o(", String) getUsing} with an empty <i><tt>clause</tt></i> parameter.");
        this.ol("*/");
        this.o("public static List getUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\treturn getUsing(con, bean, null);");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetUsingPS() throws SQLException {
        this.ol();
        this.ol("/**");
        this.ol("This is a <i>convenience</i> method that runs the specified ");
        this.ol("prepared statement to perform an arbitrary query. For example: ");
        this.ol("<blockquote>");
        this.ol("<pre>");
        this.ol("PreparedStatement <font color=blue>ps</font> = con.prepareStatement(");
        this.ol("\t\t\"select * from some_table where some_column = ?\");");
        this.ol("ps.setString(1, \"foo\");");
        this.ol("List list = fooMgr.<font color=blue>getUsing</font>(con, <font color=blue>ps</font>);");
        this.ol("for (int n = 0; n < list.size(); n++) {");
        this.ol("\tsometable t = (sometable) list.get(n);");
        this.ol("\t//do something");
        this.ol("\t}");
        this.ol("</pre>");
        this.ol("</blockquote>");
        this.ol("The effect of the above is <u>equivalent</u> to the following (larger) block ");
        this.ol("of code:");
        this.ol("<blockquote>");
        this.ol("<pre>");
        this.ol("PreparedStatement <font color=blue>ps</font> = con.prepareStatement(");
        this.ol("\t\"select * from sometable where some_column = ?\"");
        this.ol("\t);");
        this.ol("ps.setString(1, \"foo\");");
        this.ol("ResultSet rs = <font color=blue>ps.executeQuery()</font>;");
        this.ol("List list = new ArrayList();");
        this.ol("while (rs.next()) {");
        this.ol("\tlist.add(sometableMgr.<font color=blue>getFromRS(rs)</font>);");
        this.ol("\t}");
        this.ol("");
        this.ol("for (int n = 0; n < list.size(); n++) {");
        this.ol("\tsometable t = (sometable) list.get(n);");
        this.ol("\t//do something");
        this.ol("\t}");
        this.ol("</pre>");
        this.ol("</blockquote>");
        this.ol("");
        this.ol("Note: Just as with other get<i>XXX</i> methods, for large amounts of");
        this.ol("rows (say many thousands), it may be more efficient use and iterate");
        this.ol("through a JDBC result set directly.");
        this.ol("*/");
        this.o("public static List getUsing(final Connection con, ");
        this.ol(" final PreparedStatement ps) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\t__getusing_ps_called++;");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " row = decodeFromRS(rs);");
        this.ol("\t\tif (row == null) { break; } ");
        this.ol("\t\tlist.add(row);");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetUsingNamedPS() throws SQLException {
        this.ol();
        this.ol("/**");
        this.ol("This is a <i>convenience</i> method that runs the specified ");
        this.ol("{@link fc.jdbc.dbo.NamedParamStatement NamedParamStatement} to perform an arbitrary query.");
        this.ol("For example: <blockquote>");
        this.ol("<pre>");
        this.ol("NamedParamStatement <font color=blue>ps</font> = queryReadeer.getQuery(\"somequery\");");
        this.ol("ps.setString(\"some_placeholder\", \"foo\");");
        this.ol("List list = fooMgr.<font color=blue>getUsing</font>(con, <font color=blue>ps</font>);");
        this.ol("for (int n = 0; n < list.size(); n++) {");
        this.ol("\tsometable t = (sometable) list.get(n);");
        this.ol("\t//do something");
        this.ol("\t}");
        this.ol("</pre>");
        this.ol("</blockquote>");
        this.ol("");
        this.ol("Note: Just as with other get<i>XXX</i> methods, for large amounts of");
        this.ol("rows (say many thousands), it may be more efficient use and iterate");
        this.ol("through a JDBC result set directly.");
        this.ol("*/");
        this.o("public static List getUsing(final Connection con, ");
        this.ol(" final NamedParamStatement ps) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\t__getusing_ps_called++;");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal List list = new ArrayList();");
        this.ol("\tfinal ResultSet rs = ps.executeQuery();");
        this.ol("\twhile (true) {");
        this.ol("\t\t" + this.beanClassName + " row = decodeFromRS(rs);");
        this.ol("\t\tif (row == null) { break; } ");
        this.ol("\t\tlist.add(row);");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn list;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetColumnNames() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Returns a <i>comma delimited list</i> of <i>all</i> columns in <tt>");
        this.o(this.table.getName());
        this.ol("</tt>. These column names are fully qualified, i.e., they contain ");
        this.ol("table name as a prefix to the column name. For example:");
        this.ol("<blockquote><pre>");
        this.ol("<tt>tablename.column1 AS tablename_column1, tablename.column2 AS tablename_column2 ...</tt>");
        this.ol("</pre></blockquote>");
        this.ol("<p>This list is suitable for placing in the column(s) clause of a select query, such as: ");
        this.ol("<blockquote>");
        this.ol("<tt>Single table: select <i><font color=blue>[column_list_A]</font></i> from table_A</tt><br>");
        this.ol("<tt>Join: select <i><font color=blue>[column_list_A], [column_list_B]</font></i> from table_A, table_B</tt>");
        this.ol("</blockquote>");
        this.ol("The ResultSet returned by the query can be used directly or can be passed");
        this.o("to the {@link #getFromRS getFromRS} method to convert it into a list of <code>");
        this.ol(this.table.getName());
        this.ol("</code> objects. If the query is a join across multiple tables,");
        this.ol("then the {@link #getFromRS getFromRS} method for each table manager");
        this.ol("can be called on the same ResultSet to retrieve the row object for");
        this.ol("that table.");
        this.ol("Note: the returned list of names has a trailing space, which is good when");
        this.ol("the rest of the query is appended to this list.");
        this.ol("*/");
        this.o("public static String");
        this.ol(" columns() throws SQLException");
        this.ol("\t{");
        this.o("\treturn \"");
        this.o(this.table.getFullyQualifiedColumnString());
        this.ol("\";");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetColumnNames2() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Returns a <i>comma delimited list</i> of <i>all</i> columns in <tt>");
        this.o(this.table.getName());
        this.ol("</tt>. These column names are prefix with the specified prefix, which corresponds to the");
        this.ol("table abbreviation used in the \"AS\" clause. For example:");
        this.ol("<blockquote><pre>");
        this.ol("<tt>xyz.column1 AS xyz_column1, xyz.column2 AS xyz_column2 ...</tt>");
        this.ol("</pre></blockquote>");
        this.ol("<p>This list is suitable for placing in the column(s) clause of a select query, such as: ");
        this.ol("<blockquote>");
        this.ol("<p><b>Note:</b> the \".\" will automatically be appended between the prefix and column name");
        this.ol("so the prefix should not end with a \".\" or \"_\", etc<p>");
        this.ol("<tt>Single table: select <i><font color=blue>[column_list_A]</font></i> from table_A <b>AS</b> xyz</tt><br>");
        this.ol("<tt>Join: select <i><font color=blue>[column_list_A], [column_list_B]</font></i> from table_A <b>AS</b> xyz, table_B <b>AS</b> zzz</tt>");
        this.ol("</blockquote>");
        this.ol("The ResultSet returned by the query can be used directly or can be passed");
        this.o("to the {@link #getFromRS getFromRS(String)} method to convert it into a list of <code>");
        this.ol(this.table.getName());
        this.ol("</code> objects. If the query is a join across multiple tables,");
        this.ol("then the {@link #getFromRS getFromRS(String)} method for each table manager");
        this.ol("can be called on the same ResultSet to retrieve the row object for");
        this.ol("that table.");
        this.ol("Note: the returned list of names has a trailing space, which is good when");
        this.ol("the rest of the query is appended to this list.");
        this.ol("*/");
        this.o("public static String");
        this.ol(" columns(String prefix) throws SQLException");
        this.ol("\t{");
        this.ol(this.table.getPrefixQualifiedColumnString());
        this.ol("\t}");
    }

    final void mgrWriteMethodGetFromRS() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Creates and returns a new <tt>");
        this.o(this.table.getName());
        this.ol("</tt> object that represents a row from the specified ResultSet. The ResultSet is");
        this.ol("typically obtained via a handwritten query/PreparedStatement. The resulting ");
        this.ol("ResultSet should contain all of the");
        this.ol("column names of table, and this will only happen if the handwritten query had");
        this.ol("a select statement that specified all fields or used a <tt>select <b>*</b>..</tt>");
        this.ol("clause.");
        this.ol("<p>");
        this.ol("In the select clause, we could also be selecting multiple tables. To disambiguate");
        this.ol("between the same field names that may exist in multiple tables, this method ");
        this.ol("also requires that the query should use <font color=blue>fully qualified</font>");
        this.ol("(prefixed with the table name) column names, such as:");
        this.ol("<blockquote><pre>");
        this.ol("<font color=blue>tablename</font>_column1");
        this.ol("<font color=blue>tablename</font>_column2");
        this.ol("...etc.");
        this.ol("</pre></blockquote>");
        this.ol("<p>");
        this.ol("For example:");
        this.ol("<blockquote>");
        this.ol("<code>select <font color=blue>foo</font>.a <b>AS</b> <font color=blue>foo</font>_a, <font color=red>bar</font>.a <b>AS</b> <font color=red>bar</font>_a from <font color=blue>foo</font>, <font color=red>bar</font> where foo.a = bar.a;</code>");
        this.ol("</blockquote>");
        this.ol("The {@link #columns} method conveniently returns a list of column names in fully qualified format ");
        this.ol("and is useful for this purpose.");
        this.ol("<p>Note: This method will read the <i>current</i> row from the specified result set");
        this.ol("and will <b>not</b> move the result set pointer to the next row after the current");
        this.ol("row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]");
        this.ol("<i>before</i> calling this method.");
        this.ol();
        this.ol("@return a new {@link ");
        this.o(this.beanClassName);
        this.o("} object populated with the contents of the next");
        this.ol("\t\trow from the result set or <tt> null </tt> if");
        this.ol("\t\tthe ResultSet was empty.");
        this.ol("*/");
        this.o("public static ");
        this.o(this.beanClassName);
        this.ol(" getFromRS(final ResultSet rs) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getfromrs_called++;");
        this.ol("\tArgcheck.notnull(rs, \"the specified resultset parameter was null\");");
        this.ol("\tboolean hasrow = ! rs.isAfterLast();");
        this.ol("\tif (! hasrow) { ");
        this.ol("\t\treturn null; ");
        this.ol("\t\t} ");
        this.o("\t");
        this.o(this.beanClassName);
        this.o(" bean = new ");
        this.o(this.beanClassName);
        this.ol("();");
        this.ol();
        List list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string = this.wrangler.getSetName(columnData);
            this.o("\tbean.");
            this.o(string);
            this.o("( ");
            if (!columnData.useBooleanObject()) {
                this.o("rs.");
            }
            this.o(columnData.getResultSetMethod(this.table.getName() + "_"));
            this.ol(" );");
            if (columnData.isPK()) {
                this.o("\tbean.__orig_");
                this.o(columnData.getName());
                this.o(" = ");
                if (!columnData.useBooleanObject()) {
                    this.o("rs.");
                }
                this.o(columnData.getResultSetMethod(this.table.getName() + "_"));
                this.ol("; /* save original PK */");
            }
            this.ol("\tif (rs.wasNull()) {");
            this.o("\t\tbean.__isNullInDB_");
            this.o(columnData.getName());
            this.ol(" = true;");
            this.ol("\t\t}");
        }
        this.ol();
        this.ol(" \t/* set to true when instantiated new, false when we populate the bean from a resultset */");
        this.ol("\tbean.setNew(false);");
        this.ol("\t/* it's not modified, just loaded from the database */");
        this.ol("\tbean.resetModified();");
        this.ol("\treturn bean;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetFromRS2() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Creates and returns a new <tt>");
        this.o(this.table.getName());
        this.ol("</tt> object that represents a row from the specified ResultSet. The ResultSet is");
        this.ol("typically obtained via a handwritten query/PreparedStatement. The resulting ");
        this.ol("ResultSet should contain all of the");
        this.ol("column names of table, prefixed with the specified <i>prefix</i> argument.");
        this.ol("a select statement that specified all fields or used a <tt>select <b>*</b>..</tt>");
        this.ol("clause.");
        this.ol("<p>");
        this.ol("In the select clause, we could also be selecting multiple tables. To disambiguate");
        this.ol("between the same field names that may exist in multiple tables, this method ");
        this.ol("also requires that the query should use a <font color=blue>prefix</font>");
        this.ol("(some arbitrary prefix) before column names, such as:");
        this.ol("<blockquote><pre>");
        this.ol("<font color=blue>foo</font>_column1");
        this.ol("<font color=blue>foo</font>_column2");
        this.ol("...etc.");
        this.ol("</pre></blockquote>");
        this.ol("This prefix will typically be the same as the table abbreviation chosen via the <b>AS</b> clause. ");
        this.ol("If the AS clause is not used, then it is simpler to use the {@link getFromRS(ResultSet)} method instead");
        this.ol("<p><b>Note:</b> the \".\" will automatically be appended between the prefix and column name");
        this.ol("so the prefix should not end with a \".\" or \"_\", etc<p>");
        this.ol("<p>");
        this.ol("For example:");
        this.ol("<blockquote>");
        this.ol("<code>select <font color=blue>XXX</font>.a <b>AS</b> <font color=blue>XXX</font>_a, <font color=red>YYY</font>.a <b>AS</b> <font color=red>YYY</font>_a from <font color=blue>foo as XXX</font>, <font color=red>bar as YYY</font> where foo.a = bar.a;</code>");
        this.ol("</blockquote>");
        this.ol("The {@link #columns} method conveniently returns a list of column names in fully qualified format ");
        this.ol("and is useful for this purpose.");
        this.ol("<p>Note: This method will read the <i>current</i> row from the specified result set");
        this.ol("and will <b>not</b> move the result set pointer to the next row after the current");
        this.ol("row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]");
        this.ol("<i>before</i> calling this method.");
        this.ol();
        this.ol("@return a new {@link ");
        this.o(this.beanClassName);
        this.o("} object populated with the contents of the next");
        this.ol("\t\trow from the result set or <tt> null </tt> if");
        this.ol("\t\tthe ResultSet was empty.");
        this.ol("*/");
        this.o("public static ");
        this.o(this.beanClassName);
        this.ol(" getFromRS(final ResultSet rs, String prefix) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getfromrs_called++;");
        this.ol("\tArgcheck.notnull(rs, \"the specified resultset parameter was null\");");
        this.ol("\tboolean hasrow = ! rs.isAfterLast();");
        this.ol("\tif (! hasrow) { ");
        this.ol("\t\treturn null; ");
        this.ol("\t\t} ");
        this.o("\t");
        this.o(this.beanClassName);
        this.o(" bean = new ");
        this.o(this.beanClassName);
        this.ol("();");
        this.ol();
        List list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string = this.wrangler.getSetName(columnData);
            this.o("\tbean.");
            this.o(string);
            this.o("( ");
            if (!columnData.useBooleanObject()) {
                this.o("rs.");
            }
            this.o(columnData.getRuntimeResultSetMethod());
            this.ol(" );");
            if (columnData.isPK()) {
                this.o("\tbean.__orig_");
                this.o(columnData.getName());
                this.o(" = ");
                if (!columnData.useBooleanObject()) {
                    this.o("rs.");
                }
                this.o(columnData.getRuntimeResultSetMethod());
                this.ol("; /* save original PK */");
            }
            this.ol("\tif (rs.wasNull()) {");
            this.o("\t\tbean.__isNullInDB_");
            this.o(columnData.getName());
            this.ol(" = true;");
            this.ol("\t\t}");
        }
        this.ol();
        this.ol(" \t/* set to true when instantiated new, false when we populate the bean from a resultset */");
        this.ol("\tbean.setNew(false);");
        this.ol("\t/* it's not modified, just loaded from the database */");
        this.ol("\tbean.resetModified();");
        this.ol("\treturn bean;");
        this.ol("\t}");
    }

    final void mgrWriteMethodGetFromRS1Table() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Creates and returns a new <tt>");
        this.o(this.table.getName());
        this.ol("</tt> object that represents a row from the specified ResultSet. For this method");
        this.ol("to work properly, the specified ResultSet should contain <b>all</b> (typically via <b>select *");
        this.o("</b>) of the column names of table.");
        this.o("<tt>");
        this.o(this.table.getName());
        this.ol("</tt>.");
        this.ol("<p>");
        this.ol("This method does not prepend the table name to columns when reading data from");
        this.ol("the result set. It is useful when writing a JDBC query by hand that uses a single table");
        this.ol("(no joins) and then converting the returned result set into objects of this");
        this.ol("class. For example:");
        this.ol("<p>");
        this.ol("<code>select a, b, c, c*2 from foo where a = 1;</code>");
        this.ol("<p>");
        this.ol("This method will expect columns to be called <code><i>a, b, c</i></code> (no column aliases) in the returned");
        this.ol("result set. In this example, there is only one table <code>foo</code> so qualifying the column");
        this.ol("names, like <code>foo.a as foo_a</code> is not necessary). Also note, for this method to work properly, the ");
        this.ol("column list<blockquote><code>select <i>a, b, c </i></code> ...</blockquote> should be complete, i.e., contain <i>at least</i> all the columns");
        this.ol("of this table (<i>additional</i> expressions like c*2 are fine). It is slightly less efficient to retrieve all columns");
        this.ol("especially for large tables but to construct a row into an object, we need all the fields. To be safe, use <blockquote><tt>select * ....</tt></blockquote>");
        this.ol("<p>");
        this.ol("Of course, if one needs a subset of columns, one can use the ResultSet directly and forego trying to");
        this.ol("convert a ResultSet row into an corresponding object");
        this.ol("<p>\t");
        this.ol("See {@link getFromRS(ResultSet)} which is more useful when writing a JDBC");
        this.ol("query that uses multiple table joins.");
        this.ol("<p>Note: This method will read the <i>current</i> row from the specified result set");
        this.ol("and will <b>not</b> move the result set pointer to the next row after the current");
        this.ol("row has been read. The result set should be appropriately positioned [via <tt>rs.next()</tt>]");
        this.ol("<i>before</i> calling this method.");
        this.ol();
        this.o("@return a new {@link ");
        this.o(this.beanClassName);
        this.ol("} object populated with the contents of the next");
        this.ol("\t\trow from the result set or <tt> null </tt> if");
        this.ol("\t\tthe ResultSet was empty.");
        this.ol("*/");
        this.o("public static ");
        this.o(this.beanClassName);
        this.ol(" getFromRS1Table(final ResultSet rs) throws SQLException");
        this.ol("\t{");
        this.ol("\t__getfromrs_called++;");
        this.ol("\tArgcheck.notnull(rs, \"the specified resultset parameter was null\");");
        this.ol("\tboolean hasrow = ! rs.isAfterLast();");
        this.ol("\tif (! hasrow) { ");
        this.ol("\t\treturn null; ");
        this.ol("\t\t} ");
        this.o("\t");
        this.o(this.beanClassName);
        this.o(" bean = new ");
        this.o(this.beanClassName);
        this.ol("();");
        this.ol();
        List list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string = this.wrangler.getSetName(columnData);
            this.o("\tbean.");
            this.o(string);
            this.o("( ");
            if (!columnData.useBooleanObject()) {
                this.o("rs.");
            }
            this.o(columnData.getResultSetMethod());
            this.ol(" );");
            if (columnData.isPK()) {
                this.o("\tbean.__orig_");
                this.o(columnData.getName());
                this.o(" = ");
                if (!columnData.useBooleanObject()) {
                    this.o("rs.");
                }
                this.o(columnData.getResultSetMethod());
                this.ol("; /* save original PK */");
            }
            this.ol("\tif (rs.wasNull()) {");
            this.o("\t\tbean.__isNullInDB_");
            this.o(columnData.getName());
            this.ol(" = true;");
            this.ol("\t\t}");
        }
        this.ol();
        this.ol(" \t/* set to true when instantiated but this should be false");
        this.ol("\t whenever we populate the bean from a result set */");
        this.ol("\tbean.setNew(false);");
        this.ol("\t//it's not modified, just loaded from the database");
        this.ol("\tbean.resetModified();");
        this.ol("\treturn bean;");
        this.ol("\t}");
    }

    final void mgrWriteMethodDecodeFromRS() throws SQLException {
        this.ol();
        this.o("private static ");
        this.o(this.beanClassName);
        this.ol(" decodeFromRS(final ResultSet rs) throws SQLException");
        this.ol("\t{");
        this.ol("\tArgcheck.notnull(rs, \"the specified resultset parameter was null\");");
        this.ol("\tboolean hasrow = rs.next();");
        this.ol("\tif (! hasrow) { ");
        this.ol("\t\treturn null; ");
        this.ol("\t\t} ");
        this.ol("\t" + this.beanClassName + " bean = new " + this.beanClassName + "();");
        this.ol();
        List list = this.table.getColumnList();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string = this.wrangler.getSetName(columnData);
            this.o("\tbean.");
            this.o(string);
            this.o("( ");
            if (!columnData.useBooleanObject()) {
                this.o("rs.");
            }
            this.o(columnData.getResultSetMethod());
            this.ol(" );");
            if (columnData.isPK()) {
                this.o("\tbean.__orig_");
                this.o(columnData.getName());
                this.o(" = ");
                if (!columnData.useBooleanObject()) {
                    this.o("rs.");
                }
                this.o(columnData.getResultSetMethod());
                this.ol("; /* save original PK */");
            }
            this.ol("\tif (rs.wasNull()) {");
            this.o("\t\tbean.__isNullInDB_");
            this.o(columnData.getName());
            this.ol(" = true;");
            this.ol("\t\t}");
            this.ol();
        }
        this.ol();
        this.ol(" \t/* set to true when newly instantiated but this should be false");
        this.ol("\t whenever we populate the bean from a result set */");
        this.ol("\tbean.setNew(false);");
        this.ol("\t//it's not modified, just loaded from the database");
        this.ol("\tbean.resetModified();");
        this.ol("\treturn bean;");
        this.ol("\t}");
    }

    final void mgrWriteMethodSave() throws SQLException {
        String string;
        int n;
        int n2;
        ColumnData columnData = null;
        List list = this.table.getColumnList();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>();
        ArrayList<ColumnData> arrayList2 = new ArrayList<ColumnData>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            columnData = (ColumnData)list.get(n2);
            if (columnData.isAutoIncrement()) {
                arrayList2.add(columnData);
                if (!this.modifiableAutoIncrementColumns) continue;
            }
            arrayList.add(columnData);
        }
        n2 = arrayList.size();
        this.ol();
        this.ol("/**");
        this.ol("Saves the specified object into the database. If the specified");
        this.ol("object was newly created, then it is <span style=\"font-variant:");
        this.ol("small-caps\">insert</span>'ed into the database, else (if it was retrieved");
        this.ol("earlier from the database) it is <span ");
        this.ol("style=\"font-variant: small-caps\">update</span>'ed. (this can be");
        this.ol("overriden by the {@link #update update} method). If the object is");
        this.ol("inserted as a new row, then after insertion, the values of");
        this.ol("serial/auto-incremented columns will be automatically available via the");
        this.ol("appropriate getXXX() methods on that object.");
        this.ol("<p>");
        this.ol("<b>NOTE 1:</b> When saving an object, only modified fields are");
        this.ol("saved. Do not rely on default field values (such as null) of newly");
        this.ol("created objects; instead explicitly set the value (including to null");
        this.ol("if needed) of any field that should be saved to the database.");
        this.ol("<p>");
        this.ol("<b>NOTE 2:</b> Once an object is successfully saved, it is discarded");
        this.ol("and cannot be saved again and any attempt to save it again will");
        this.ol("result in a runtime exception. Objects that need to be modified");
        this.ol("again must be re-instantiated or re-populated from the database");
        this.ol("before they can be saved again. (the serial/auto-increment data will still be");
        this.ol("available, discarding only affects the ability to save the object");
        this.ol("again).");
        this.ol("<p>");
        this.ol("<b>Note 3:</b> <font color='red'>For various reasons/flexiblity, default database values");
        this.ol("for columns <i>other</i> than serial columns are <b>not</b> available");
        this.ol("in the saved object. To get these values, retrieve the saved object again. (this is what");
        this.ol("we would have to do internally anyway). This is relevant, for example, when a column has");
        this.ol("a default value of a now() timestamp, and we need to get that timestamp after the object");
        this.ol("has been saved</font>");
        this.ol();
        this.ol("@return \tthe number of rows inserted or updated (typically useful ");
        this.ol("\t\t\tto see if an update succeeded)");
        this.ol("@throws\tValidateException \ton a validation error");
        this.ol("@throws SQLException\t\ton some SQL/Database error");
        this.ol("@throws IOException\t\t\tby the available() method if/when");
        this.ol("\t\t\t\t\t\t\tsetting a stream for longvar/text types");
        this.ol("*/");
        this.o("public static int save(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException, SQLException, IOException");
        this.ol("\t{");
        this.ol("\t__save_called++;");
        this.ol("\tArgcheck.notnull(bean, \"the specified bean parameter was null\");");
        this.ol("\tcheckDiscarded(bean);");
        this.ol("\tif (! bean.isModified()) { ");
        this.ol("\t\tlog.warn(\"bean=\", bean, \" not modified, IGNORING SAVE\\n====DEBUG STACK TRACE====\\n\", IOUtil.throwableToString(new Exception()));");
        this.ol("\t\treturn 0;");
        this.ol("\t\t}");
        this.ol("\tPreparedStatement ps = null;");
        this.ol();
        this.ol("\tboolean inserting_a_row = false;");
        this.ol("\tif (bean.isNew() && ! bean.__force_update) ");
        this.ol("\t\t{  //insert new row");
        this.ol("\t\tvalidateBeforeSaveNew(bean);");
        this.ol("\t\tint __count = 0;");
        this.ol("\t\tinserting_a_row = true;");
        this.ol("\t\tfinal StringBuilder buf = new StringBuilder(512);");
        this.o("\t\tbuf.append(\"INSERT into ");
        this.o(this.table.getName());
        this.ol(" (\");");
        for (n = 0; n < n2; ++n) {
            columnData = (ColumnData)arrayList.get(n);
            this.o("\t\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) { ");
            this.o("\t\t\tbuf.append(\"");
            this.o(columnData.getName());
            this.ol("\").append(\", \");");
            this.ol("\t\t\t__count++;");
            this.ol("\t\t\t}");
        }
        this.ol();
        this.ol("\t\tif (__count == 0) {");
        this.ol("\t\t\tthrow new ValidateException(\"Cannot save this bean because no column has been modified. Use JDBC directly as needed.\\n\");");
        this.ol("\t\t}");
        this.ol("\t\tbuf.setLength(buf.length() - 2);");
        this.ol(" \t\tbuf.append(\") values (\");");
        this.ol("\t\tfor (int n = 0; n < __count; n++) { ");
        this.ol("\t\t\tbuf.append(\"?\");");
        this.ol("\t\t\tif ((n+1) < __count)");
        this.ol("\t\t\t\tbuf.append(\", \");");
        this.ol("\t\t\t}");
        this.ol("\t\tbuf.append(\")\");");
        this.ol();
        this.ol("\t\tfinal String insertByPKStmt = buf.toString();");
        this.ol("\t\tps = prepareStatement(con, insertByPKStmt);");
        this.ol("\t\t/* Insert any changed values into our prepared statement */");
        this.utilFillPStmtFromList_IfModified(arrayList, "\t\t");
        this.ol("\t\t}");
        this.ol("\telse //update existing row ");
        this.ol("\t\t{");
        if (this.pklist.size() == 0) {
            this.ol("\t\tint pknum = 0; /*we write pknum to shut up the compiler about unreachable statements*/");
            this.ol("\t\tif (pknum == 0) {");
            this.ol("\t\t\tthrow new ValidateException(");
            this.ol("\t\t\t\t\"Cannot update this bean because it has no primary keys.\"");
            this.ol("\t\t\t\t+ \"Use JDBC directly to update values to this table.\");");
            this.ol("\t\t\t}");
        }
        this.ol("\t\tvalidateBeforeSaveUpdate(bean);");
        this.ol("\t\tint __count = 0;");
        this.ol("\t\tfinal StringBuilder buf = new StringBuilder(512);");
        this.ol("\t\tbuf.append(\"UPDATE \");");
        this.o("\t\tbuf.append(\"");
        this.o(this.table.getName());
        this.ol("\");");
        this.ol("\t\tbuf.append(\" SET \");");
        for (n = 0; n < n2; ++n) {
            columnData = (ColumnData)arrayList.get(n);
            this.o("\t\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) { ");
            this.o("\t\t\tbuf.append(\"");
            this.o(columnData.getName());
            this.o("=?, ");
            this.ol("\");");
            this.ol("\t\t\t__count++;");
            this.ol("\t\t\t}");
        }
        this.ol();
        this.ol("\t\tif (__count == 0) {");
        this.ol("\t\t\tthrow new ValidateException(\"Cannot save this bean because no column has been modified. Use JDBC directly as needed.\\n\");");
        this.ol("\t\t}");
        this.ol("\t\tbuf.setLength(buf.length() - 2);");
        this.ol("\t\tbuf.append(\" WHERE \");");
        this.o("\t\tbuf.append(\"");
        this.o(Table.getPreparedStmtPlaceholders(this.pklist));
        this.ol("\");");
        this.ol("\t\tps = con.prepareStatement(buf.toString());");
        this.ol();
        this.ol("\t\t/* Insert any changed values into our prepared statement */");
        this.utilFillPStmtFromList_IfModified(arrayList, "\t\t");
        this.ol();
        this.ol("\t\t/* Set primary keys for the WHERE part of our prepared statement */");
        for (n = 0; n < this.pklist.size(); ++n) {
            columnData = (ColumnData)this.pklist.get(n);
            String string2 = this.wrangler.getGetName(columnData);
            string = columnData.getName();
            this.o("\t\t");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            this.o(string);
            this.o(" = ");
            this.o("(bean.__force_update) ? ");
            this.o("bean.");
            this.o(string2);
            this.o("()");
            this.o(" : ");
            this.o("bean.__orig_");
            this.o(columnData.getName());
            this.ol(";");
            this.o("\t\t");
            this.ol(columnData.getPreparedStmtSetMethod("ps.", "++pos", string));
        }
        this.ol("\t\t} //~else update;");
        this.ol();
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tint result = ps.executeUpdate();");
        this.ol("\tif (inserting_a_row) { //get auto increment info");
        n = arrayList2.size();
        if (n > 0) {
            this.ol("\t\t/* Retrieve values from auto-increment columns */");
            this.ol("\t\tResultSet rs = null; Statement stmt = null;");
            this.ol("\t\tString query = null;");
            this.ol("\t\tboolean found = false;");
            this.ol();
            for (int i = 0; i < n; ++i) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getIsModifiedName(columnData));
                this.ol("()) { ");
                this.o("\t\t\t//column: ");
                this.ol(columnData.getName());
                this.ol("\t\t\t//not getting auto increment value for this column");
                this.ol("\t\t\t//since not using auto increment, a value was specified manually");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                columnData = (ColumnData)arrayList2.get(i);
                string = this.dbspecific.getAutoIncrementQuery(columnData);
                String string3 = this.wrangler.getSetName(columnData);
                this.ol("\t\t\tstmt = con.createStatement();");
                this.o("\t\t\tquery = \"");
                this.o(string);
                this.ol("\";");
                this.ol("\t\t\trs = stmt.executeQuery(query);");
                this.ol("\t\t\tfound = rs.next();");
                this.ol("\t\t\tif (! found) throw new SQLException(\"No last inserted id returned\");");
                this.o("\t\t\tbean.");
                this.o(string3);
                this.o("( ");
                if (!columnData.useBooleanObject()) {
                    this.o("rs.");
                }
                this.o(columnData.getResultSetMethod());
                this.ol(");");
                this.ol("\t\t\tif (rs.wasNull()) {");
                this.o("\t\t\t\tbean.__isNullInDB_");
                this.o(columnData.getName());
                this.ol(" = true;");
                this.ol("\t\t\t\t}");
                this.ol("\t\t\trs.close();");
                this.ol("\t\t\t}");
            }
            this.ol("\t\t}");
        } else {
            this.ol("\t\t//No auto inc columns in this table");
            this.ol("\t\t}");
        }
        this.ol();
        this.ol("\t//discard after saving/updating for safety");
        this.ol("\tbean.discard();");
        this.ol("\treturn result;");
        this.ol("\t}");
    }

    final void mgrWriteMethodUpdate() throws SQLException {
        this.ol();
        if (this.pklist.size() == 0) {
            this.ol("/* update() method not implemented since this bean has no primary keys. Use JDBC directly.");
            return;
        }
        this.ol("/**");
        this.ol("Uses the specified object to update existing data in the database.");
        this.ol("<p>");
        this.ol("Note, the {@link #save save} method automatically saves newly created objects");
        this.ol("as <i>inserts</i> in the database (and prior <i>retrieved</i> objects, when");
        this.ol("subsequently modified, are saved as <i>updates</i>).");
        this.ol("<p>");
        this.ol("However, sometimes it is useful to create a <i>new</i> object and then");
        this.ol("use its data to <i>update</i> an existing row in the database.");
        this.ol("This method need <b>only</b> be called to save a <u>newly</u>");
        this.ol("created object as an <u>update</u> into the database (overriding the");
        this.ol("default action of saving new objects as inserts in the database).");
        this.ol("<p>");
        this.ol("Note, also, a bean can only be updated if the corresponding table it has");
        this.ol("at least one primary key defined. To update tables with no primary keys,");
        this.ol("use JDBC directly.");
        this.ol("<p>");
        this.o("This method takes primary key(s) of {@link ");
        this.o(this.beanClassName);
        this.ol("} as additional arguments and sets those in the");
        this.ol("specified bean before updating the database (this way the row to update");
        this.ol("can be uniquely identified).");
        this.ol();
        this.ol("@see #save");
        this.ol();
        this.ol("@return \tthe number of rows that were updated (typically useful ");
        this.ol("\t\t\tto see if an update succeeded)");
        this.ol("@throws\tValidateException \ton a validation error");
        this.ol("@throws SQLException\t\ton some SQL/Database error");
        this.ol("*/");
        this.o("public static int update(final Connection con, final ");
        this.o(this.beanClassName);
        this.o(" bean, ");
        this.o(this.pkFormalParamString);
        this.ol(") throws ValidateException, SQLException, IOException");
        this.ol("\t{");
        for (int i = 0; i < this.pklist.size(); ++i) {
            ColumnData columnData = (ColumnData)this.pklist.get(i);
            String string = columnData.getName();
            this.o("\tbean.");
            this.o(this.wrangler.getSetName(columnData));
            this.o("(");
            this.o(string);
            this.o(");");
            this.ol();
        }
        this.ol();
        this.ol("\tif (bean.isNew()) { /* force update (and not insert) for new bean */");
        this.ol("\t\tbean.__force_update = true;");
        this.ol("\t\t}");
        this.ol("\treturn save(con, bean);");
        this.ol("\t}");
    }

    final void mgrWriteMethodDelete() throws SQLException {
        this.ol();
        if (this.pklist.size() == 0) {
            this.ol("/* delete() not implemented since this table does not have any primary keys defined. */");
            return;
        }
        this.o("static private final String deleteStmt = \"DELETE ");
        this.o(" from ");
        this.o(this.table.getName());
        this.o(" WHERE ");
        this.o(Table.getPreparedStmtPlaceholders(this.pklist));
        this.ol("\";");
        this.ol("/** ");
        this.o("Deletes this object from the database. ");
        this.ol("<p>");
        this.ol("<b>NOTE 1:</b> Only objects that were retrieved from the database can be deleted. Newly");
        this.ol("created objects cannot be deleted since they do not yet exist in the database.");
        this.ol("Use {@link #deleteByKey deleteByKey} or {@link #deleteWhere deleteWhere} instead");
        this.ol("for arbitrary deletions. <p><b>NOTE 2:</b> Once an object is successfully");
        this.ol("deleted, it is discarded and cannot be deleted again and any attempt to delete");
        this.ol("it again will result in a runtime Exception.");
        this.ol("*/");
        this.o("public static void delete(final Connection con, ");
        this.o(this.beanClassName);
        this.ol(" bean) throws SQLException");
        this.ol("\t{");
        this.ol("\t__delete_called++;");
        this.ol("\tif (bean.isNew()) {");
        this.ol("\t\tthrow new DBOException(\"Cannot delete new objects using this method. Use deleteByKey() or deleteWhere() instead\");");
        this.ol("\t\t}");
        this.ol("\tcheckDiscarded(bean);");
        this.ol("\tfinal PreparedStatement ps = prepareStatement(con, deleteStmt);");
        for (int i = 0; i < this.pklist.size(); ++i) {
            ColumnData columnData = (ColumnData)this.pklist.get(i);
            String string = this.wrangler.getGetName(columnData);
            this.o("\t");
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            String string2 = columnData.getName();
            this.o(string2);
            this.o(" = bean.");
            this.o(string);
            this.ol("();");
            this.o("\t");
            String string3 = String.valueOf(i + 1);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", string3, string2));
        }
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal int result = ps.executeUpdate();");
        this.ol("\tif (result != 1) { ");
        this.ol("\t\tthrow new DBOException(\"The number of deleted rows was: \" + result + \"; [Should have been 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\t}");
    }

    final void mgrWriteMethodDeleteByKey() throws SQLException {
        this.ol();
        if (this.pklist.size() == 0) {
            this.ol("/* deleteByKey() not implemented since this table does not have any primary keys defined */");
            return;
        }
        this.o("static private final String deleteByPKStmt = \"DELETE ");
        this.o(" from ");
        this.o(this.table.getName());
        this.o(" WHERE ");
        this.o(Table.getPreparedStmtPlaceholders(this.pklist));
        this.ol("\";");
        this.ol("/** ");
        this.o("Deletes the rows with the specified primary key(s) from the database. ");
        this.ol("<p>This method uses a prepared statement and is safe from SQL injection attacks");
        this.ol("*/");
        this.o("public static void deleteByKey(final Connection con, ");
        this.o(this.pkFormalParamString);
        this.ol(") throws SQLException");
        this.ol("\t{");
        this.ol("\t__deletebykey_called++;");
        this.ol("\tPreparedStatement ps = prepareStatement(con, deleteByPKStmt);");
        for (int i = 0; i < this.pklist.size(); ++i) {
            ColumnData columnData = (ColumnData)this.pklist.get(i);
            String string = columnData.getName();
            this.o("\t");
            String string2 = String.valueOf(i + 1);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", string2, string));
        }
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tfinal int result = ps.executeUpdate();");
        this.ol("\tif (result != 1) { ");
        this.ol("\t\tthrow new DBOException(\"The number of deleted rows was: \" + result + \"; [Should have been 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\t}");
    }

    final void mgrWriteMethodDeleteWhere() {
        this.ol();
        this.ol("/** ");
        this.ol("Deletes the rows with the specified where clause. <p><b>The");
        this.ol("where clause is sent as-is to the database and SQL injection");
        this.ol("attacks are possible if it is created as-is from a untrusted");
        this.ol("source.</b>");
        this.ol("(note: the string <tt>\"WHERE\"</tt> does <b>not</b> have to be");
        this.ol("specified in the clause. It is added automatically by this method).");
        this.ol();
        this.ol("@return the number of rows deleted by the database");
        this.ol("*/");
        this.o("public static int deleteWhere(final Connection con, final String where) throws SQLException");
        this.ol("\t{");
        this.ol("\t__deletewhere_called++;");
        this.ol("\tArgcheck.notnull(where, \"the where parameter was null (and should not be null)\");");
        this.ol("\tfinal String stmt_string = \"DELETE from " + this.table.getName() + " WHERE \" + where ;");
        this.ol("\tStatement stmt = con.createStatement();");
        this.ol("\tlog.bug(\"Query to run: \", stmt_string);");
        this.ol("\tfinal int result = stmt.executeUpdate(stmt_string);");
        this.ol("\treturn result;");
        this.ol("}");
    }

    final void mgrWriteMethodDeleteUsing() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.ol("Returns the rows returned by querying the table with the contents of");
        this.ol("the specified instance of <tt>alltypes</tt> or <tt>null</tt> if no");
        this.ol("rows were found. As many fields in <tt>alltypes</tt> can be set as");
        this.ol("needed and the values of all set fields (including fields explicitly");
        this.ol("set to <tt>null</tt>) are then used to perform the query. <p>Note,");
        this.ol("however that this method does use any primary key(s). If the ");
        this.ol("primary keys are known then one should use the {@link");
        this.ol("#deleteByKey deleteByKey} method to delete the data instead.");
        this.ol("<p>Likewise, to delete a previously fetched row, use the {@link ");
        this.ol("#delete delete} method. This method is really meant to create an new");
        this.ol("object, set various fields in it, and then use that to delete matching");
        this.ol("row(s) from the database in a type safe way.");
        this.ol("<p>");
        this.ol("This method is often convenient/safer than the {@link #deleteWhere");
        this.ol("deleteWhere} method (because the <tt>deleteWhere</tt> method takes");
        this.ol("an arbitrary query string which has to be properly escaped by the user).");
        this.ol();
        this.ol("<p>However, as a middle ground, this method also takes an <tt>clause</tt> parameter which");
        this.ol("is sent as is to the database. For example, a clause can be:");
        this.ol("<blockquote><pre>");
        this.ol("List beans = table_fooMgr.<font color=blue>deleteUsing(proto, <b>\"xyx > 5\"</b>)</font>;");
        this.ol("</pre> </blockquote>");
        this.ol("This clause is optional. Specify <tt>null</tt> to not use it at all.");
        this.ol("If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.");
        this.ol();
        this.ol("<p>Essentially, this method is a more convenient way to use a");
        this.ol("PreparedStatement. Internally, a prepared statement is created and");
        this.ol("it's parameters are set to fields that are set in this object).");
        this.ol("Using PreparedStatements directly is also perfectly fine. For");
        this.ol("example, the following are equivalent. ");
        this.ol("<p> Using a PreparedStatement:");
        this.ol("<blockquote><pre>");
        this.ol("String foo = \"delete from table_foo where x = ? and y = ?\";");
        this.ol("PreparedStatement ps = con.prepareStatement(foo);");
        this.ol("ps.setString(1, \"somevalue\");");
        this.ol("ps.setString(2, \"othervalue\");");
        this.ol("int rows_deleted = ps.executeUpdate();");
        this.ol("</pre> </blockquote>\t");
        this.ol("");
        this.ol("Using this method:");
        this.ol("<blockquote><pre>");
        this.ol("table_foo proto = new table_foo();");
        this.ol("proto.set_x(\"somevalue\");\t//compile time safety");
        this.ol("proto.set_y(\"othervalue\");\t//compile time safety");
        this.ol("int rows_deleted = table_fooMgr.<font color=blue>deleteUsing</font>(proto);");
        this.ol("</pre></blockquote>");
        this.ol("@return\t\tthe number of rows deleted");
        this.ol("*/");
        this.o("public static int deleteUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean, final String clause) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\t__deleteusing_called++;");
        this.ol();
        this.ol("\tArgcheck.notnull(bean, \"the bean parameter was null (and should not be null)\");");
        this.ol("\tif (! bean.isModified()) { ");
        this.ol("\t\tthrow new ValidateException(\"bean=\" + bean + \" not modified, ignoring query\");");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tfinal StringBuilder buf = new StringBuilder(512);");
        this.o("\tbuf.append(\"DELETE  from ");
        this.o(this.table.getName());
        this.ol(" WHERE \");");
        this.ol();
        this.ol("\tint __count = 0;");
        List list = this.table.getColumnList();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            if (columnData.isPK()) continue;
            this.o("\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) { ");
            arrayList.add(columnData);
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("() == null) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else if (columnData.isNullable()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getIsModifiedNullName(columnData));
                this.ol("()) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else {
                this.o("\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t__count++;");
            }
            this.ol("\t\t}");
        }
        if (arrayList.size() == 0) {
            this.ol("\tthrow new RuntimeException(\"This table contains no non-primary keys. Use the deleteByKey method instead.\");");
            this.ol("\t}");
            return;
        }
        this.ol("\tbuf.setLength(buf.length() - 4);");
        this.ol("\tif (__count == 0) {");
        this.ol("\t\tthrow new ValidateException(\"No non-PrimaryKey column was modified/set in this bean. You must set at least one such column. To delete by the Primary key, use the deleteByKey method instead.\");");
        this.ol("\t\t}");
        this.ol("\tif (clause != null) {");
        this.ol("\t\tbuf.append(\" \");");
        this.ol("\t\tbuf.append(clause);");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tfinal String getUsingPKStmt = buf.toString();");
        this.ol("\tPreparedStatement ps = prepareStatement(con, getUsingPKStmt);");
        this.utilFillPStmtFromList_IfModified_Object(arrayList, "\t");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tList list = new ArrayList();");
        this.ol("\tint result = ps.executeUpdate();");
        this.ol("\treturn result;");
        this.ol("\t}");
    }

    final void mgrWriteMethodDeleteUsingNoClause() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Convenience method that invokes {@link getUsing(Connection, ");
        this.o(this.beanClassName);
        this.o(", String) getUsing} with an empty <i><tt>clause</tt></i> parameter.");
        this.ol("*/");
        this.o("public static int deleteUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\treturn deleteUsing(con, bean, null);");
        this.ol("\t}");
    }

    final void mgrWriteMethodCount() {
        this.ol();
        this.ol("private final static String countStmt = \"SELECT count(*) from " + this.table.getName() + "\";");
        this.ol("/**");
        this.ol("Returns the count of all rows in the table. <p><b>Note</b>: This may");
        this.ol("be an expensive operation in MVCC databases like PostgresQL, Oracle and");
        this.ol("others, where an entire non-optimized table scan <i>may</i> be");
        this.ol("required -- hence speed will typically be O(n). However, on Postgres (for");
        this.ol("example), this is still very fast for small values of n (on a");
        this.ol("mid-level test machine) as of 2004, counting 4k records was about");
        this.ol("15 milli-seconds(ms); this scaled almost linearly, so count(*) for 16k records was");
        this.ol("about 70 ms, 65k records was about 370 ms, 524k records was about");
        this.ol("2000 ms and 1 million records was about 4000 ms. Results will vary");
        this.ol("on your machine and database but the general O(n) principle will");
        this.ol("remain the same.");
        this.ol("*/");
        this.ol("public static int count(final Connection con) throws SQLException");
        this.ol("\t{");
        this.ol("\t__count_called++;");
        this.ol("  \tint __count = -1;");
        this.ol("\tfinal Statement stmt = con.createStatement();");
        this.ol("    final ResultSet rs = stmt.executeQuery(countStmt);");
        this.ol("    if (rs.next())");
        this.ol("    \t{");
        this.ol("      \t__count = rs.getInt(1);");
        this.ol("    \t}");
        this.ol("\telse { //rs returned no count, which should never happen");
        this.ol("\t\tthrow new DBOException(\"The COUNT query [\" + countStmt + \"] returned no rows. [Should have returned 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\tstmt.close();");
        this.ol("\treturn __count;");
        this.ol("\t}");
    }

    final void mgrWriteMethodCountWhere() {
        this.ol();
        this.ol("/**");
        this.ol("Returns the count of rows in the table using the specified <tt>where</tt> clause.");
        this.ol("(note: the string <tt>\"WHERE\"</tt> does <b>not</b> have to be");
        this.ol("specified in the clause. It is added automatically by this method).");
        this.ol();
        this.ol("@throws \tIllegalArgumentException \tif the where paramater was null");
        this.ol("*/");
        this.ol("public static int countWhere(final Connection con, final String where) throws SQLException");
        this.ol("\t{");
        this.ol("\t__countwhere_called++;");
        this.ol("\tArgcheck.notnull(where, \"the where parameter was null\");");
        this.ol("  \tint __count = -1;");
        this.ol("\tfinal String countWhereStmt = \"SELECT count(*) from " + this.table.getName() + " WHERE \" + where;");
        this.ol("\tStatement stmt = con.createStatement();");
        this.ol("\tlog.bug(\"Query to run: \", stmt, \" \", countWhereStmt);");
        this.ol("    ResultSet rs = stmt.executeQuery(countWhereStmt);");
        this.ol("    if (rs.next())");
        this.ol("    \t{");
        this.ol("      \t__count = rs.getInt(1);");
        this.ol("    \t}");
        this.ol("\telse { //rs returned no count, which should never happen");
        this.ol("\t\tthrow new DBOException(\"The COUNT query [\" + countWhereStmt + \"] returned no rows. [Should have returned 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\tstmt.close();");
        this.ol("\treturn __count;");
        this.ol("\t}");
    }

    final void mgrWriteMethodCountUsingNoClause() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.o("Convenience method that invokes {@link getUsing(Connection, ");
        this.o(this.beanClassName);
        this.o(", String) getUsing} with an empty <i><tt>clause</tt></i> parameter.");
        this.ol("*/");
        this.o("public static int countUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\treturn countUsing(con, bean, null);");
        this.ol("\t}");
    }

    final void mgrWriteMethodCountUsing() throws SQLException {
        this.ol();
        this.ol("/** ");
        this.ol("Returns the rows count by querying the table with the contents of the");
        this.o("specified instance of <tt>");
        this.o(this.beanClassName);
        this.ol("</tt> As many fields in <tt>alltypes</tt> can be set as needed and the");
        this.ol("values of all set fields (including fields explicitly set to");
        this.ol("<tt>null</tt>) are then used to perform the query. If the primary");
        this.ol("key(s) are known then one can also use the {@link #exists} method to");
        this.ol("see if that row exists in the database.");
        this.ol("<p>");
        this.ol("This method is often convenient/safer than the {@link #countWhere");
        this.ol("countWhere} method (because the <tt>countWhere</tt> method takes an");
        this.ol("arbitrary query string which has to be properly escaped by the");
        this.ol("user). ");
        this.ol("<p>Essentially, this method is a more convenient way to use a");
        this.ol("PreparedStatement (with parameters set to fields that are set in");
        this.ol("this object). Using PreparedStatements directly is also perfectly");
        this.ol("fine. For example, the following two are equivalent. <p>");
        this.ol("Using a PreparedStatement:");
        this.ol("<blockquote><pre>");
        this.ol("String foo = \"select <i>count(*)</i> from table_foo where x = ? and y = ?\";");
        this.ol("PreparedStatement ps = con.prepareStatement(foo);");
        this.ol("ps.setString(1, \"somevalue\");");
        this.ol("ps.setString(2, \"othervalue\");");
        this.ol("ResultSet rs  = ps.executeUpdate();");
        this.ol("rs.next();");
        this.ol("int count = rs.getInt(1);");
        this.ol("</pre> </blockquote>");
        this.ol("");
        this.ol("Using this method:");
        this.ol("<blockquote><pre>");
        this.ol("table_foo proto = new table_foo();");
        this.ol("proto.set_x(\"somevalue\");\t//compile time safety");
        this.ol("proto.set_y(\"othervalue\");\t//compile time safety");
        this.ol("int count = table_fooMgr.<font color=blue>countUsing</font>(proto);");
        this.ol("</pre> </blockquote>");
        this.ol("The clause is optional. Specify <tt>null</tt> to not use it at all.");
        this.ol("If the clause is specified, do <font size='+1'><b>NOT</b></font> include the word <tt>WHERE</tt>.");
        this.ol("*/");
        this.o("public static int countUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean, final String clause) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\t__countusing_called++;");
        this.o("\tArgcheck.notnull(bean, \"the bean parameter was null (and should not be null)\");");
        this.ol("\tif (! bean.isModified()) { ");
        this.ol("\t\tthrow new ValidateException(\"bean=\" + bean + \" not modified, ignoring query\");");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tint __count = 0;");
        this.ol("\tfinal StringBuilder buf = new StringBuilder(512);");
        this.o("\tbuf.append(\"SELECT count(*)  from ");
        this.o(this.table.getName());
        this.ol(" WHERE \");");
        List list = this.table.getColumnList();
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>();
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            arrayList.add(columnData);
            this.o("\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) { ");
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("() == null) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else if (columnData.isNullable()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getIsModifiedNullName(columnData));
                this.ol("()) {");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.ol(" is NULL and \");");
                this.ol("\t\t\t}");
                this.ol("\t\telse{");
                this.o("\t\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t\t__count++;");
                this.ol("\t\t\t}");
            } else {
                this.o("\t\tbuf.append(\"");
                this.o(columnData.getName());
                this.o("=? and ");
                this.ol("\");");
                this.ol("\t\t__count++;");
            }
            this.ol("\t\t}");
        }
        this.ol();
        this.ol("\tbuf.setLength(buf.length() - 4);");
        this.ol("\tif (clause != null) {");
        this.ol("\t\tbuf.append(\" \");");
        this.ol("\t\tbuf.append(clause);");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tfinal String countUsingStmt = buf.toString();");
        this.ol("\tPreparedStatement ps = prepareStatement(con, countUsingStmt);");
        this.utilFillPStmtFromList_IfModified_Object(arrayList, "\t");
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tResultSet rs = ps.executeQuery();");
        this.ol("\tif (! rs.next()) {");
        this.ol("\t\tthrow new DBOException(\"The COUNT query [\" + countUsingStmt + \"] returned no rows. [Should have returned 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\tint rows = rs.getInt(1);");
        this.ol("\trs.close();");
        this.ol("\treturn rows;");
        this.ol("\t}");
    }

    final void mgrWriteMethodExists() throws SQLException {
        if (this.pklist.size() == 0) {
            this.ol("/* exists() not implemented since this table does not have any primary keys defined */");
            return;
        }
        this.ol();
        this.o("static private final String existsStmt = \"SELECT count(*) from ");
        this.o(this.table.getName());
        this.o(" WHERE ");
        this.o(Table.getPreparedStmtPlaceholders(this.pklist));
        this.ol("\";");
        this.ol("/**");
        this.ol("Returns <tt>true</tt> if a row with the specified primary keys exists, <tt>false</tt> otherwise.");
        this.ol("<p>This method uses a prepared statement and is safe from SQL injection attacks");
        this.ol("*/");
        this.o("public static boolean exists(final Connection con, ");
        this.o(this.pkFormalParamString);
        this.ol(") throws SQLException");
        this.ol("\t{");
        this.ol("\t__exists_called++;");
        this.ol("\tPreparedStatement ps = prepareStatement(con, existsStmt);");
        for (int i = 0; i < this.pklist.size(); ++i) {
            ColumnData columnData = (ColumnData)this.pklist.get(i);
            String string = columnData.getName();
            this.o("\t");
            String string2 = String.valueOf(i + 1);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", string2, string));
        }
        this.ol("\tlog.bug(\"Query to run: \", ps);");
        this.ol("\tResultSet rs = ps.executeQuery();");
        this.ol("\tint __count = -1;");
        this.ol("    if (rs.next())");
        this.ol("    \t{");
        this.ol("      \t__count = rs.getInt(1);");
        this.ol("    \t}");
        this.ol("\telse { //rs returned no count, which should never happen");
        this.ol("\t\tthrow new DBOException(\"The COUNT query [\" + existsStmt + \"] returned no rows. [Should have returned 1 row exactly] \");");
        this.ol("\t\t}");
        this.ol("\trs.close();");
        this.ol("\treturn (__count > 0); //exists if __count > 0");
        this.ol("\t}");
    }

    final void mgrWriteMethodExistsUsing() throws SQLException {
        this.ol("/**");
        this.o("A thin wrapper around {@link getUsing(Connection,");
        this.o(this.beanClassName);
        this.ol(") getUsing}");
        this.ol("that returns <tt>false</tt> if no rows are returned, <tt>true</tt> otherwise.");
        this.ol("*/");
        this.o("public static boolean existsUsing(final Connection con, final ");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException, SQLException");
        this.ol("\t{");
        this.ol("\tfinal List list = getUsing(con, bean, null);");
        this.ol("\treturn (list.size() > 0);");
        this.ol("\t}");
    }

    final void mgrWriteMethodPrepareStatement() {
        this.ol();
        this.ol("/**");
        this.ol("Returns a prepared statement given it's variable name.");
        this.ol();
        this.ol("Essentially speeds up the creation of prepared statements perhaps");
        this.ol("using a per connection cache -- which makes sense for pooled");
        this.ol("connections since they are not closed but returned to the pool");
        this.ol("and hence don't need to \"prepare\" statements every time (the");
        this.ol("prepareStatement call is seperate from actually filling in the");
        this.ol("placeholders in a already created prepared statement -- which");
        this.ol("does need to be done every time). <p>");
        this.ol("Prepared statements are unique per connection, so multiple threads");
        this.ol("using different connections won't stomp over each other's prepared");
        this.ol("statements. Multiple threads using the SAME connection will cause");
        this.ol("bizarre errors but multiple threads won't get the same connection");
        this.ol("from the connection manager -- ever :-), so that should never happen.");
        this.ol("*/");
        this.o("private static final PreparedStatement prepareStatement (");
        this.ol(" final Connection con, final String sql) throws SQLException");
        this.ol("\t{");
        this.ol("\tif (! (con instanceof fc.jdbc.PooledConnection) ) { ");
        this.ol("\t\treturn con.prepareStatement(sql);");
        this.ol("\t\t}");
        this.ol("\tfinal PooledConnection pc = (PooledConnection) con;");
        this.ol("\treturn pc.getCachedPreparedStatement(sql);");
        this.ol("\t}");
    }

    final void mgrWriteCheckDiscarded() {
        this.ol();
        this.ol("private static final void checkDiscarded(final DBO bean) throws DBOException");
        this.ol("\t{");
        this.ol("\tif (bean.isDiscarded()) {");
        this.ol("\t\tthrow new DBOException(\"===== Attempt to save a discarded object === \" + bean);");
        this.ol("\t\t}");
        this.ol("\t}");
    }

    final void mgrWriteMethodStats() {
        this.ol();
        this.ol("private static final java.util.Date __loadDate = new java.util.Date();");
        this.ol("/** Returns usage statistics for this class */");
        this.ol("public static String stats() ");
        this.ol("\t{");
        this.ol("\t//locally created _numberFormat for thread safety");
        this.ol("\tfinal java.text.NumberFormat _numberFormat = java.text.NumberFormat.getInstance();");
        this.ol("\tfinal String nl = fc.io.IOUtil.LINE_SEP;");
        this.ol("\tStringBuffer buf = new StringBuffer(256);");
        this.o("\tbuf.append(\"Class Name: [");
        this.o(this.mgrClassName);
        this.ol("]; Class loaded on: \");");
        this.ol("\tbuf.append(__loadDate);");
        this.ol("\tbuf.append(nl);");
        this.o("\tbuf.append(\"---- Start Usage Statistics ----\")");
        this.ol(".append(nl);");
        this.ol();
        this.ol("\tByteArrayOutputStream out = new ByteArrayOutputStream(512);");
        this.ol("\tTablePrinter.PrintConfig config = new TablePrinter.PrintConfig();");
        this.ol("\tconfig.setPrintBorders(false);");
        this.ol("\tconfig.setCellSpacing(1);");
        this.ol("\tconfig.setCellPadding(0);");
        this.ol("\tconfig.setAutoFit(true);");
        this.ol("\tTablePrinter p = new TablePrinter(2, new PrintStream(out), config);");
        this.ol("\tp.startTable();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"Method\");");
        this.ol("\tp.printCell(\"# times called\");");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getAll()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getall_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getLimited()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getlimited_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getByKey()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getbykey_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getWhere()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getwhere_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getUsing()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getusing_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getUsing(prepared_stmt)\");");
        this.ol("\tp.printCell(_numberFormat.format(__getusing_ps_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"getFromRS()\");");
        this.ol("\tp.printCell(_numberFormat.format(__getfromrs_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"save()\");");
        this.ol("\tp.printCell(_numberFormat.format(__save_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"delete()\");");
        this.ol("\tp.printCell(_numberFormat.format(__delete_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"deleteByKey()\");");
        this.ol("\tp.printCell(_numberFormat.format(__deletebykey_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"deleteWhere()\");");
        this.ol("\tp.printCell(_numberFormat.format(__deletewhere_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"deleteUsing()\");");
        this.ol("\tp.printCell(_numberFormat.format(__deleteusing_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"count()\");");
        this.ol("\tp.printCell(_numberFormat.format(__count_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"countWhere()\");");
        this.ol("\tp.printCell(_numberFormat.format(__countwhere_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"countUsing()\");");
        this.ol("\tp.printCell(_numberFormat.format(__countusing_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.startRow();");
        this.ol("\tp.printCell(\"exists()\");");
        this.ol("\tp.printCell(_numberFormat.format(__exists_called));");
        this.ol("\tp.endRow();");
        this.ol();
        this.ol("\tp.endTable();");
        this.ol("\tbuf.append(out.toString());");
        this.ol("\treturn buf.toString();");
        this.ol("\t}");
    }

    final void mgrWriteMethodToString() {
        this.ol();
        this.ol("public String toString() ");
        this.ol("\t{");
        this.ol("\treturn getClass().getName() + \" [call stats() for more info]\";");
        this.ol("\t}");
    }

    void mgrWriteValidators() throws SQLException {
        String string;
        ColumnData columnData;
        int n;
        this.ol();
        this.ol("// ================ Validation  ==================== ");
        this.ol();
        this.ol("/** ");
        this.ol("Creates and attaches validators for all the fields in the");
        this.ol("specified {@link fc.web.forms.Form}. These fields should");
        this.o("<i>have the same name</i> in the form as in {@link ");
        this.o(this.beanClassName);
        this.ol("}. If this is not the case, then the then the differences can be specifed");
        this.ol("as follows. <p>");
        this.ol("<dl>");
        this.ol("<dt>with a prefix</dt>");
        this.o("\t<dd><tt>(prefix + ");
        this.o(this.beanClassName);
        this.ol(" column)</tt> should equal <tt>form fieldname</tt></dd>");
        this.ol("<dt>with a suffix</dt> ");
        this.o("\t<dd><tt>(");
        this.o(this.beanClassName);
        this.ol(" column + suffix)</tt> should equal <tt>form fieldname</tt></dd>");
        this.ol("<dt>with both a prefix/suffix</dt> ");
        this.o("\t<dd><tt>(prefix + ");
        this.o(this.beanClassName);
        this.ol(" + suffix)</tt> should equal <tt>form fieldname</tt></dd>");
        this.ol("<dt>with a arbitrary map</dt> ");
        this.o("\t<dd>[key] <tt>");
        this.o(this.beanClassName);
        this.ol(" column</tt> -> [value] <tt>form fieldname</tt>");
        this.ol("\t<u>If a map is specified, then the prefix/suffix are not used.</u>");
        this.ol("\t</dd>");
        this.ol("</dl>");
        this.ol("<p>These validators are for database constraints such as <i>nullability</i> & <i>column length</i>.");
        this.ol("These validators save a lot of grunt-work in adding such schema");
        this.ol("constraints to the front-end {@link fc.web.forms.Form}. <p><b>However, <i>business and");
        this.ol("other validation constraints</i> still need to be manually added to");
        this.ol("the application code/front-end forms as/when needed</b>.");
        this.ol("<p>");
        this.ol("");
        this.ol("The following table shows the kind of validators added by this method");
        this.ol("<table border=1 width=90%>");
        this.ol("<tr bgcolor='#CCCCCC'>");
        this.ol("\t<td>Database SQL Type</td>");
        this.ol("\t<td><b>Nullable</b>validator</td>");
        this.ol("\t<td><b>Length</b> validator</td>");
        this.ol("\t<td><b>Digits only</b> input validator ({@link VText#allowIntegersOnly})</td>");
        this.ol("</tr>");
        this.ol("\t<tr>");
        this.ol("\t\t<td><tt>CHAR</tt>, <tt>VARCHAR</tt></td>");
        this.ol("\t\t<td>Yes (maximum length constraint).<br><font size='-1' color=red>This");
        this.ol("\t\tonly applies to form fields that are subclasses of {@link ");
        this.ol("\t\tfc.web.forms.MaxSizable} </font></td>");
        this.ol("\t\t<td>-NO-</td>");
        this.ol("\t</tr>");
        this.ol("\t<tr>");
        this.ol("\t\t<td><tt>TINYINT, MEDIUMINT, INT, BIGINT (integral types)</tt></td>");
        this.ol("\t\t<td>Yes</td>");
        this.ol("\t\t<td>-NO-</td>");
        this.ol("\t\t<td>Yes to integer columns displayed using form fields that are subclasses of {@link fc.web.forms.AbstractText}<br> Note: <b>not</b> added non-<i>integral</i> number types such as <tt>FLOAT, REAL, DOUBLE, NUMERIC/DECIMAL</tt></td>");
        this.ol("\t</tr>");
        this.ol("\t<tr>");
        this.ol("\t\t<td>All other SQL types</td>");
        this.ol("\t\t<td>Yes</td>");
        this.ol("\t\t<td>-NO-</td>");
        this.ol("\t</tr>");
        this.ol("</table>");
        this.ol("<p>Automatic validators are very useful but can be very tricky to understand. It is");
        this.ol("suggested to invoke this method, print the form using it's <tt>toString</tt>");
        this.ol("method and then examine the output to see what validators were added If those");
        this.ol("automatic validators are too little, too many or too hard to understand, <u>then");
        this.ol("simply enoough, do NOT invoke this method and simply add validators by");
        this.ol("hand</u>. In particular, do <i>not</i> add automatic validators for");
        this.ol("<b>tables</b> in which a row is optional but <i>if</i> some column is filled in");
        this.ol("the front end form, <i>then</i> all columns must be filled.");
        this.ol();
        this.ol("@param\tform\tthe form containing fields (some or all) representing");
        this.ol("\t\t\t\tthis and possible other tables. These field");
        this.ol("\t\t\t\tobjects must have been added to the form prior");
        this.ol("\t\t\t\tto calling this method");
        this.ol("@param\tprefix  an optional (null allowed) prefix to this table's column name with which the");
        this.ol("\t\t\t\tcorresponding column was added to the form.");
        this.ol("\t\t\t\tA <tt>*</tt> specifies all possible prefixes");
        this.ol("@param\tsuffix  an optional suffix (null allowed) to this table's column name with which the ");
        this.ol("\t\t\t\tcorresponding column was added to the form.");
        this.ol("\t\t\t\tA <tt>*</tt> specifies all possible suffixes");
        this.ol("@param\tmap\t\tan optional map (null allowed) that maps this table's column name with which the ");
        this.ol("\t\t\t\tcorresponding column was added to the form. ");
        this.ol("\t\t\t\t[key] <tt>table's column_name</tt> -> [value] <tt>form's fieldname</tt>");
        this.ol("*/");
        this.ol("public static void addValidators(final fc.web.forms.Form form, final String prefix, final String suffix, final Map map) ");
        this.ol("\t{");
        this.ol("\taddValidators(form, prefix, suffix, map, false);");
        this.ol("\t}");
        this.ol();
        this.ol("private static void addValidators(fc.web.forms.Form form, String prefix, String suffix, final Map map, final boolean onlyOnFilled) ");
        this.ol("\t{");
        this.ol("\tList list = null;");
        this.ol("\tArgcheck.notnull(form, \"How can I add validators to the form when the form parameter was null ?\");");
        this.ol("\tField field = null;");
        this.ol("\tFieldValidator fv = null;");
        this.ol("\tString colname_in_form = null;");
        this.ol("\t//fields can be null if they are not being used in the html form");
        List list = this.table.getColumnList();
        for (n = 0; n < list.size(); ++n) {
            columnData = (ColumnData)list.get(n);
            string = columnData.getName();
            String string2 = columnData.getSQLTypeName().intern();
            this.ol();
            this.o("\t");
            this.ol(this.getBeanComment(columnData));
            this.o("\tlist = getFieldFromForm(form, \"");
            this.o(string);
            this.o("\", prefix, suffix, map, ");
            if (columnData.isAutoIncrement()) {
                this.o("false");
            } else {
                this.o("true");
            }
            this.ol(");");
            this.ol("\tif (list.size() > 0) ");
            this.ol("\t\t{ //add applicable automatic validators, empty if n/a");
            this.ol("\t\tfor (int n = 0; n < list.size(); n++)");
            this.ol("\t\t\t{");
            this.ol("\t\t\tfield = (Field) list.get(n);");
            if (!columnData.isNullable()) {
                if (columnData.hasDefaultValue()) {
                    this.o("\t\t\t/* field is non-nullable but has a default value [");
                    this.o(columnData.getDefaultValue());
                    this.ol("], skipping non-nullability validation */");
                } else {
                    this.ol("\t\t\tif (field instanceof Choice) {");
                    this.ol("\t\t\t\t//choice fields are ignored because they can");
                    this.ol("\t\t\t\t//mean false even when NOT selected/filled");
                    this.ol("\t\t\t\tcontinue;");
                    this.ol("\t\t\t\t}");
                    this.ol("\t\t\t/* field is non-nullable */");
                    this.o("\t\t\tfv = new VFilled(field, \"");
                    this.o(this.validateNull_ErrorMsg);
                    this.ol("\");");
                }
            } else {
                this.ol("\t\t\t/* field is nullable, skipping non-nullability validation */");
            }
            if (string2.toLowerCase().indexOf("int") >= 0) {
                this.ol();
                this.ol("\t\t\t/* database type for this field is integral */");
                this.ol("\t\t\tif (field instanceof AbstractText) {");
                this.o("\t\t\t\tfv = new VText((AbstractText)field, \"");
                this.o(this.validateIntegerOnly_ErrorMsg);
                this.ol("\")");
                this.ol("\t\t\t\t\t.allowIntegersOnly();");
                this.ol("\t\t\t\t}");
            }
            if (string2 == "CHAR" || string2 == "VARCHAR") {
                int n2 = columnData.getSize();
                if (n2 < 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this.ol("\t\t\tif (! (field instanceof MaxSizable)) {");
                this.o("\t\t\t\tlog.warn(\"Skipping maximum length validator for field '\" + field.getName() + \"'; [database type='");
                this.o(string2);
                this.ol("', field.type='\" +  field.getType() + \"' is not MaxSizable]\"); ");
                this.ol("\t\t\t\t}");
                this.ol("\t\t\telse{");
                this.o("\t\t\t\tVText vt = new VText((MaxSizable) field, \"");
                this.o(this.validateText_ErrorMsg_MaxSize);
                this.ol("\");");
                this.o("\t\t\t\tvt.setMaxSize(");
                this.o(String.valueOf(n2));
                this.ol(");");
                this.ol("\t\t\t\t}");
            }
            this.ol("\t\t\t}");
            this.ol("\t\t}");
        }
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Convenience method that calls {@link #addValidators(Form, String, String, Map)} with a ");
        this.ol("<tt>null</tt> prefix/suffix and the specified map");
        this.ol("*/");
        this.ol("public static void addValidators(fc.web.forms.Form form, Map map) ");
        this.ol("\t{");
        this.ol("\taddValidators(form, null, null, map);");
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Convenience method that calls {@link #addValidators(Form, String, String, Map)} with a ");
        this.ol("<tt>null</tt> prefix/suffix/map");
        this.ol("*/");
        this.ol("public static void addValidators(fc.web.forms.Form form) ");
        this.ol("\t{");
        this.ol("\taddValidators(form, null, null, null);");
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Convenience method that calls {@link #addValidators(Form, String, String, map)} with the ");
        this.ol("specified prefix and a <tt>null</tt> suffix/map");
        this.ol("*/");
        this.ol("public static void addValidators(fc.web.forms.Form form, String prefix) ");
        this.ol("\t{");
        this.ol("\taddValidators(form, prefix, null, null);");
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Validates a form field <i>if</i> it is filled by the user. Leaves empty fields alone.");
        this.ol("This is very useful for fields that are optional but must have the correct value when");
        this.ol("filled by the user");
        this.ol("*/");
        this.ol("public static void addIfFilledValidators(Form form, String prefix) ");
        this.ol("\t{");
        this.ol("\taddValidators(form, prefix, null, null, true);");
        this.ol("\t}");
        this.ol();
        this.ol("/** implementation helper method -- not for public use */");
        this.ol("static List getFieldFromForm(Form form, String colname, String prefix, String suffix, Map map, boolean warn)");
        this.ol("\t{");
        this.ol("\tField field = null;");
        this.ol("\tList list = Form.empty_list;");
        this.ol("\tboolean getwhere = false;");
        this.ol("\tgetwhere = false;");
        this.ol("\tString colname_in_form = colname;");
        this.ol();
        this.ol("\tif (map != null) {");
        this.ol("\t\tString str = (String) map.get(colname);");
        this.ol("\t\tif (str != null) {");
        this.ol("\t\t\tprefix = null;  /*ignored when there is a mapping*/");
        this.ol("\t\t\tsuffix = null;  /*ignored when there is a mapping*/");
        this.ol("\t\t\tcolname_in_form = str; /* else if not in map, colname remains as-is*/");
        this.ol("\t\t\t}");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tif (prefix != null) ");
        this.ol("\t\t{ ");
        this.ol("\t\tif (prefix.equals(\"*\")) { ");
        this.ol("\t\t\tgetwhere = true;");
        this.ol("\t\t\t}");
        this.ol("\t\telse{");
        this.ol("\t\t\tcolname_in_form = prefix + colname_in_form;");
        this.ol("\t\t\t}");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tif (suffix != null) ");
        this.ol("\t\t{");
        this.ol("\t\tif (suffix.equals(\"*\")) { ");
        this.ol("\t\t\tgetwhere = true;");
        this.ol("\t\t\t}");
        this.ol("\t\telse{");
        this.ol("\t\t\tcolname_in_form = colname_in_form + suffix;");
        this.ol("\t\t\t}");
        this.ol("\t\t}");
        this.ol();
        this.ol("\tif (getwhere) { ");
        this.ol("\t\tlist = form.getContaining(colname_in_form);");
        this.ol("\t\tif (list.size() == 0 && warn) warn(form, colname_in_form, suffix, prefix, map);");
        this.ol("\t\treturn list;");
        this.ol("\t\t}");
        this.ol("\telse{");
        this.ol("\t\t//containsField() check prevents an un-necessary warning with form.get()");
        this.ol("\t\tif (! form.containsField(colname_in_form)) {");
        this.ol("\t\t\tif (warn) warn(form, colname_in_form, suffix, prefix, map);");
        this.ol("\t\t\treturn list;");
        this.ol("\t\t\t}");
        this.ol("\t\tfield = form.get(colname_in_form);");
        this.ol("\t\tlist = new ArrayList();");
        this.ol("\t\tlist.add(field);");
        this.ol("\t\t}");
        this.ol("\treturn list;");
        this.ol("\t}");
        this.ol();
        this.ol("private static final void warn(Form form, String name, String suffix, String prefix, Map map) {");
        this.ol("\tlog.warn(form.getName(),\": No automatic validators will be added for Field [\",name,\"]. This field does not exist in the front-end form. (this could be normal). suffix=[\"+suffix+\"] prefix=[\"+prefix+\"] map=\", map);");
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Validates the bean before saving it to the database. This");
        this.ol("method is called internally by the {@link save()} method");
        this.ol("before saving a new bean (i.e., inserting a new row) to the");
        this.ol("database.");
        this.ol("<p>");
        this.ol("The validation is somewhat basic and there can exist many");
        this.ol("constraints and conditions on the database that might results in a");
        this.ol("insert/update error anyway. But by doing some basic validation");
        this.ol("against some known constraints, we save a needless trip to the");
        this.ol("database.");
        this.ol("We check to see that: <ol>");
        this.ol("<li><i>non-nullable and non auto-increment</i> columns [and with no default");
        this.ol("column value in the database] are modified (via a set method) since these");
        this.ol("columns must have a explicitly set value.</li>");
        this.ol("<li>for non-nullable columns that hold non-primitive (i.e., Object)");
        this.ol("java types, the modified value for non-nullable columns is a");
        this.ol("non-null object. </li>");
        this.ol("</ol>");
        this.ol("*/");
        this.o("protected static void validateBeforeSaveNew(");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException");
        this.ol("\t{");
        this.ol("\tboolean error = false;");
        this.ol("\tfinal StringBuffer buf = new StringBuffer(\"The following validation errors were found\").append(IOUtil.LINE_SEP);");
        for (n = 0; n < list.size(); ++n) {
            columnData = (ColumnData)list.get(n);
            string = columnData.getName();
            this.ol();
            if (columnData.isNullable()) {
                this.o("\t//[");
                this.o(string);
                this.ol("]=>nullable, no modification check necessary, skipping...");
                continue;
            }
            if (!columnData.isNullable() && columnData.hasDefaultValue()) {
                this.o("\t//[");
                this.o(string);
                this.o("]=>is not nullable but has a default column value [");
                this.o(columnData.getDefaultValue());
                this.ol("], no modification check necessary, skipping...");
                continue;
            }
            if (columnData.isAutoIncrement()) {
                this.o("\t//[");
                this.o(string);
                this.ol("]=>auto-increment, no modification check necessary, skipping...");
                continue;
            }
            this.o("\tif (! bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) {");
            this.ol("\t\terror = true;");
            this.o("\t\tbuf.append(\"");
            this.o(string);
            this.o(" was not set (this field is required in the database)\").append(\";current value=\"");
            this.o(").append(bean.");
            this.o(this.wrangler.getGetName(columnData));
            this.ol("()).append(IOUtil.LINE_SEP);");
            this.ol("\t\t}");
            if (!columnData.usesPrimitiveJavaType()) {
                this.ol("\telse { //was modified but to null");
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("() == null) {");
                this.ol("\t\t\terror = true;");
                this.o("\t\t\tbuf.append(\"");
                this.o(string);
                this.o(" was set to null (but is non-nullable)\").append(\";current value=\"");
                this.o(").append(bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("()).append(IOUtil.LINE_SEP);");
                this.ol("\t\t\t}");
                this.ol("\t\t}");
                continue;
            }
            this.o("\t//");
            this.o(columnData.getJavaTypeFromSQLType());
            this.ol(" is primitive, skipping null test");
        }
        this.ol("\tif (error) { ");
        this.ol("\t\tthrow new ValidateException(buf.toString());");
        this.ol("\t\t}");
        this.ol("\t}");
        this.ol();
        this.ol("/** ");
        this.ol("Validates the bean before saving it to the database. This method is");
        this.ol("called internally by the {@link save()} method before updating an");
        this.ol("existing bean (i.e., updating a row) in the database.");
        this.ol("<p>");
        this.ol("For <i>each modified column</i>, if that column is non-nullable in");
        this.ol("the database, then it must have a non-null value in the bean before");
        this.ol("it is saved. This check is only done for fields of");
        this.ol("<i>non</i>-primitive (Object) java types. [There is no way to ensure");
        this.ol("a non-null value for <i>primitive</i> types since all values");
        this.ol("[including 0] are non-null for those types].");
        this.ol("*/");
        this.o("protected static void validateBeforeSaveUpdate(");
        this.o(this.beanClassName);
        this.ol(" bean) throws ValidateException");
        this.ol("\t{");
        this.ol("\tboolean error = false;");
        this.ol("\tfinal StringBuffer buf = new StringBuffer(\"The following validation errors were found\").append(IOUtil.LINE_SEP);");
        this.ol();
        for (n = 0; n < list.size(); ++n) {
            columnData = (ColumnData)list.get(n);
            string = columnData.getName();
            if (columnData.isNullable()) {
                this.o("\t//[");
                this.o(string);
                this.ol("]=>nullable, no modification check necessary, skipping...");
                continue;
            }
            if (columnData.isAutoIncrement()) {
                this.o("\t//[");
                this.o(string);
                this.ol("]=>auto-increment, no modification check necessary, skipping...");
                continue;
            }
            this.o("\tif (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) {");
            if (!columnData.usesPrimitiveJavaType()) {
                this.o("\t\tif (bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("() == null) {");
                this.ol("\t\t\terror = true;");
                this.o("\t\t\tbuf.append(\"");
                this.o(string);
                this.o(" was set to null (but is non-nullable)\").append(\";current value=\"");
                this.o(").append(bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("()).append(IOUtil.LINE_SEP);");
                this.ol("\t\t\t}");
            } else {
                this.o("\t\t//");
                this.o(columnData.getJavaTypeFromSQLType());
                this.ol(" is primitive, skipping null test");
            }
            this.ol("\t\t}");
        }
        this.ol("\tif (error) { ");
        this.ol("\t\tthrow new ValidateException(buf.toString());");
        this.ol("\t\t}");
        this.ol("\t}");
    }

    void o(String string) {
        this.out.print(string);
    }

    void o(String string, String string2) {
        this.out.print(string);
        this.out.print(string2);
    }

    void ol(String string) {
        this.out.println(string);
    }

    void ol() {
        this.out.println();
    }

    void utilFillPStmtFromList_IfModified(List list, String string) throws SQLException {
        String string2 = string + "\t";
        String string3 = string + "\t\t";
        this.o(string);
        this.ol("int pos = 0;");
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string4 = columnData.getName();
            this.o(string);
            this.o("if (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) {");
            this.o(string2);
            this.ol("pos++;");
            if (columnData.usesPrimitiveJavaType() && columnData.isNullable()) {
                this.o(string2);
                this.o("if (bean.");
                this.o(this.wrangler.getIsModifiedNullName(columnData));
                this.ol("()) { /* nullable in db */");
                this.o(string3);
                this.o("ps.");
                this.o(columnData.getPreparedStmtSetNullMethod("pos", string4));
                this.ol(";");
                this.o(string3);
                this.ol("}");
                this.o(string2);
                this.ol("else{");
                this.o(string3);
                this.o(columnData.getJavaTypeFromSQLType());
                this.o(" ");
                this.o(string4);
                this.o(" = bean.");
                this.o(this.wrangler.getGetName(columnData));
                this.ol("();");
                this.o(string3);
                this.ol(columnData.getPreparedStmtSetMethod("ps.", "pos", string4));
                this.o(string3);
                this.ol("}");
                this.o(string2);
                this.ol("}");
                continue;
            }
            this.o(string2);
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            this.o(string4);
            this.o(" = bean.");
            this.o(this.wrangler.getGetName(columnData));
            this.ol("();");
            this.o(string2);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", "pos", string4));
            this.o(string2);
            this.ol("}");
        }
    }

    void utilFillPStmtFromList_IfModified_Object(List list, String string) throws SQLException {
        String string2 = string + "\t";
        String string3 = string + "\t\t";
        this.o(string);
        this.ol("int pos = 0;");
        for (int i = 0; i < list.size(); ++i) {
            ColumnData columnData = (ColumnData)list.get(i);
            String string4 = columnData.getName();
            this.o(string);
            this.o("if (bean.");
            this.o(this.wrangler.getIsModifiedName(columnData));
            this.ol("()) {");
            if (!columnData.usesPrimitiveJavaType() || columnData.isNullable()) {
                this.o(string2);
                this.o("if (bean.");
                if (!columnData.usesPrimitiveJavaType()) {
                    this.o(this.wrangler.getGetName(columnData));
                    this.ol("() == null) { ");
                } else {
                    this.o(this.wrangler.getIsModifiedNullName(columnData));
                    this.ol("()) { ");
                }
                this.o(string3);
                this.ol("/* no value to set here, uses [xxx IS NULL] syntax*/");
                this.o(string3);
                this.ol("}");
                this.o(string2);
                this.ol("else{");
            }
            this.o(string3);
            this.ol("pos++;");
            this.o(string3);
            this.o(columnData.getJavaTypeFromSQLType());
            this.o(" ");
            this.o(string4);
            this.o(" = bean.");
            this.o(this.wrangler.getGetName(columnData));
            this.ol("();");
            this.o(string3);
            this.ol(columnData.getPreparedStmtSetMethod("ps.", "pos", string4));
            this.o(string3);
            this.ol("}");
            if (columnData.usesPrimitiveJavaType() && !columnData.isNullable()) continue;
            this.o(string2);
            this.ol("}");
        }
    }

    public boolean isPostgres() {
        return this.dbname == DBName.postgres;
    }

    public boolean isMysql() {
        return this.dbname == DBName.mysql;
    }

    public static void main(String[] stringArray) throws Exception {
        Generate generate = new Generate(stringArray);
    }
}

