/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.IOUtil;
import fc.io.Log;
import fc.io.SystemLog;
import fc.jdbc.ConnectionMgr;
import fc.jdbc.PooledConnection;
import fc.jdbc.QueryUtil;
import fc.util.Args;
import fc.util.FilePropertyMgr;
import fc.util.PropertyMgr;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public final class PooledConnectionMgr
extends ConnectionMgr {
    public static final int defaultSize = 100;
    MyBoundedBuffer buffer;
    boolean dbgCheckOut;
    Map checkedOutInfo;
    public static final long ConnectionTimeoutWarning = 1500L;

    public PooledConnectionMgr(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        super(string, string2, string3, string4, string5);
        this.init(n);
    }

    public PooledConnectionMgr(PropertyMgr propertyMgr, int n) throws Exception {
        super(propertyMgr);
        this.init(n);
    }

    public PooledConnectionMgr(PropertyMgr propertyMgr, String string, int n) throws Exception {
        super(propertyMgr, string);
        this.init(n);
    }

    public PooledConnectionMgr(SystemLog systemLog, PropertyMgr propertyMgr, int n) throws Exception {
        super(systemLog, propertyMgr);
        this.init(n);
    }

    public PooledConnectionMgr(SystemLog systemLog, PropertyMgr propertyMgr, String string, int n) throws Exception {
        super(systemLog, propertyMgr, string);
        this.init(n);
    }

    private void init(int n) throws Exception {
        if (n <= 0) {
            throw new IllegalArgumentException("size must be greater than 0");
        }
        this.buffer = new MyBoundedBuffer(this, n);
        this.log.bug("PooledConnectionMgr.constructor: Constructed new connection pool buffer: ", this.buffer);
        for (int i = 0; i < n; ++i) {
            Connection connection = DriverManager.getConnection(this.url, this.user, this.password);
            if (connection == null) {
                throw new Exception("PooledConnectionMgr: Cannot connect to database [" + this.url + "]");
            }
            PooledConnection pooledConnection = new PooledConnection(this, connection);
            this.buffer.put(pooledConnection);
        }
        this.checkedOutInfo = new Hashtable();
        this.log.bug("PooledConnectionMgr.constructor: added ", this.buffer.size(), " connections to the connection pool");
    }

    public void setDebugCheckout(boolean bl) {
        this.dbgCheckOut = bl;
        if (!bl) {
            this.checkedOutInfo.clear();
        }
    }

    public Iterator getCheckoutInfo() {
        return this.checkedOutInfo.values().iterator();
    }

    public List getHungTransactions(long l) {
        long l2 = System.currentTimeMillis();
        Object[] objectArray = this.buffer.toArray();
        ArrayList<PooledConnection> arrayList = new ArrayList<PooledConnection>();
        for (int i = 0; i < objectArray.length; ++i) {
            PooledConnection pooledConnection = (PooledConnection)objectArray[i];
            if (pooledConnection.transaction_start_time == 0L || pooledConnection.transaction_start_time + l > l2) continue;
            arrayList.add(pooledConnection);
        }
        return arrayList;
    }

    @Override
    protected Connection getConImpl() throws SQLException {
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = (PooledConnection)this.buffer.poll(1500L, TimeUnit.MILLISECONDS);
            if (pooledConnection == null) {
                this.log.warn(this, "Could not obtain connection in ", String.valueOf(1500L), " milliseconds..\n", "Possibly waiting forever for connection here...\n", IOUtil.throwableToString(new Exception("Debug Stack Trace")));
                pooledConnection = (PooledConnection)this.buffer.take();
                this.log.info(this, "...Connection obtained successfully.");
            }
            pooledConnection.setClosed(false);
            if (this.dbgCheckOut) {
                this.checkedOutInfo.put(new Integer(pooledConnection.getID()), new Exception("==PooledConnectionMgr/Checkout Debug Info=="));
            }
            return pooledConnection;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new SQLException(interruptedException.getMessage());
        }
    }

    @Override
    protected boolean handleMgrShutdown() {
        this.buffer.closeAllConnections();
        return true;
    }

    void put(PooledConnection pooledConnection) throws SQLException {
        try {
            this.buffer.put(pooledConnection);
            if (this.dbgCheckOut) {
                this.checkedOutInfo.remove(new Integer(pooledConnection.getID()));
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new SQLException(interruptedException.getMessage());
        }
    }

    @Override
    public String toString() {
        return this.myname + " [capacity=" + this.buffer.bufsize + "; available=" + this.buffer.size() + "]";
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object3;
        int n;
        Args args = new Args(stringArray);
        Log.getDefault().setLevel(SystemLog.DEBUG);
        args.setUsage("java fc.jdbc.PooledConnectionMgr -conf conf-file -query query-to-execute");
        String string = args.getRequired("query");
        String string2 = args.getRequired("conf");
        FilePropertyMgr filePropertyMgr = new FilePropertyMgr(new File(string2));
        PooledConnectionMgr pooledConnectionMgr = new PooledConnectionMgr((PropertyMgr)filePropertyMgr, 5);
        pooledConnectionMgr.setDebugCheckout(true);
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        for (n = 0; n < 2; ++n) {
            object3 = pooledConnectionMgr.getConnection();
            arrayList.add((Connection)object3);
        }
        System.out.println("Got connections, connection pool=" + String.valueOf(pooledConnectionMgr));
        System.out.println("Now using connections...");
        n = 1;
        for (Connection object22 : arrayList) {
            object = object22.createStatement();
            ResultSet resultSet = object.executeQuery(string);
            System.out.println("=== query using connection [# " + n++ + "]" + String.valueOf(object22) + "=====");
            QueryUtil.printRS(resultSet);
            System.out.println("=============================================================");
            object22.close();
        }
        System.out.println("Used and closed all connections in pool.");
        object3 = pooledConnectionMgr.getConnection();
        System.out.println("Got new connection:" + String.valueOf(object3));
        System.out.println("==== [debug] Checkout Info: ====");
        Iterator exception = pooledConnectionMgr.getCheckoutInfo();
        while (exception.hasNext()) {
            object = (Throwable)exception.next();
            ((Throwable)object).printStackTrace();
        }
        System.out.println("==== [debug end] Checkout Info: ====");
        System.out.println("Closed all connections, connection pool=" + String.valueOf(pooledConnectionMgr));
        pooledConnectionMgr.close();
        System.out.println("Trying to get connection after closing connection mgr");
        try {
            object3 = pooledConnectionMgr.getConnection();
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
        System.out.println("TEST 2....");
        final PooledConnectionMgr pooledConnectionMgr2 = new PooledConnectionMgr((PropertyMgr)filePropertyMgr, 5);
        object = new Thread(){

            @Override
            public void run() {
                try {
                    int n;
                    ArrayList<Connection> arrayList = new ArrayList<Connection>();
                    for (n = 0; n < 5; ++n) {
                        Connection connection = pooledConnectionMgr2.getConnection();
                        arrayList.add(connection);
                        System.out.println("Got connection: " + String.valueOf(connection));
                    }
                    System.out.println("sleeping 10 seconds");
                    Thread.currentThread();
                    Thread.sleep(5000L);
                    for (n = 0; n < arrayList.size(); ++n) {
                        System.out.println("Releasing connection: " + (n + 1) + " " + String.valueOf(arrayList.get(n)));
                        ((Connection)arrayList.get(n)).close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        ((Thread)object).start();
        for (int i = 0; i < 5; ++i) {
            System.out.println("Main Thread: Trying to get connection..." + (i + 1));
            object3 = pooledConnectionMgr2.getConnection();
            System.out.println("Main Thread: Got connection: " + String.valueOf(object3));
            object3.close();
        }
        pooledConnectionMgr2.close();
    }

    class MyBoundedBuffer
    extends ArrayBlockingQueue {
        int bufsize;
        final /* synthetic */ PooledConnectionMgr this$0;

        MyBoundedBuffer(PooledConnectionMgr pooledConnectionMgr, int n) {
            PooledConnectionMgr pooledConnectionMgr2 = pooledConnectionMgr;
            Objects.requireNonNull(pooledConnectionMgr2);
            this.this$0 = pooledConnectionMgr2;
            super(n);
            this.bufsize = n;
        }

        void closeAllConnections() {
            Object[] objectArray = this.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    PooledConnection pooledConnection = (PooledConnection)objectArray[i];
                    if (pooledConnection == null) continue;
                    if (!pooledConnection.isClosed()) {
                        this.this$0.log.warn("PooledConnectionMgr shutdown: closing open database connection #" + pooledConnection.id);
                    }
                    pooledConnection.closeReally();
                    continue;
                }
                catch (SQLException sQLException) {
                    this.this$0.log.warn(sQLException);
                }
            }
        }
    }
}

