/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class NamedParamStatement {
    private static final boolean dbg = false;
    private static final Map queryMap = new HashMap();
    private PreparedStatement wrappedPS;
    private Map indexMap;
    static final Pattern pat = Pattern.compile("(\\s*)@([a-zA-Z_0-9.]+)");

    private NamedParamStatement(PreparedStatement preparedStatement, Map map) {
        this.wrappedPS = preparedStatement;
        this.indexMap = map;
    }

    public static NamedParamStatement get(Connection connection, String string) throws SQLException {
        return NamedParamStatement.add(connection, string, false);
    }

    public static NamedParamStatement getScrollable(Connection connection, String string) throws SQLException {
        return NamedParamStatement.add(connection, string, true);
    }

    private static final ParseData parse(String string) {
        ArrayList<Integer> arrayList;
        String string2;
        HashMap<String, ArrayList<Integer>> hashMap = new HashMap<String, ArrayList<Integer>>();
        Matcher matcher = pat.matcher(string);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 1;
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "$1?");
            string2 = matcher.group(2);
            arrayList = (ArrayList)hashMap.get(string2);
            if (arrayList == null) {
                arrayList = new ArrayList<Integer>();
                hashMap.put(string2, arrayList);
            }
            arrayList.add(n++);
        }
        matcher.appendTail(stringBuffer);
        string2 = stringBuffer.toString();
        arrayList = new ParseData();
        ((ParseData)((Object)arrayList)).indexMap = hashMap;
        ((ParseData)((Object)arrayList)).parsedQuery = string2;
        queryMap.put(string, arrayList);
        return arrayList;
    }

    private static final NamedParamStatement add(Connection connection, String string, boolean bl) throws SQLException {
        if (string == null) {
            throw new IllegalArgumentException("'query' parameter was null");
        }
        ParseData parseData = (ParseData)queryMap.get(string);
        if (parseData == null) {
            parseData = NamedParamStatement.parse(string);
        }
        PreparedStatement preparedStatement = null;
        preparedStatement = bl ? connection.prepareStatement(parseData.parsedQuery, 1004, 1007) : connection.prepareStatement(parseData.parsedQuery);
        NamedParamStatement namedParamStatement = new NamedParamStatement(preparedStatement, parseData.indexMap);
        return namedParamStatement;
    }

    private List getIndexes(String string) {
        List list = (List)this.indexMap.get(string);
        if (list == null) {
            throw new IllegalArgumentException("NamedParamStatement [" + this.wrappedPS.toString() + "], replacement parameter not found, parameter name=" + string);
        }
        return list;
    }

    public void close() throws SQLException {
        this.wrappedPS.close();
        this.wrappedPS = null;
    }

    public String toString() {
        return this.wrappedPS.toString();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.wrappedPS.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.wrappedPS.executeUpdate();
    }

    public void setNull(String string, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setNull((Integer)list.get(i), n);
        }
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setBoolean((Integer)list.get(i), bl);
        }
    }

    public void setByte(String string, byte by) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setByte((Integer)list.get(i), by);
        }
    }

    public void setShort(String string, short s) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setShort((Integer)list.get(i), s);
        }
    }

    public void setInt(String string, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setInt((Integer)list.get(i), n);
        }
    }

    public void setLong(String string, long l) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setLong((Integer)list.get(i), l);
        }
    }

    public void setFloat(String string, float f) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setFloat((Integer)list.get(i), f);
        }
    }

    public void setDouble(String string, double d) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setDouble((Integer)list.get(i), d);
        }
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setBigDecimal((Integer)list.get(i), bigDecimal);
        }
    }

    public void setString(String string, String string2) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setString((Integer)list.get(i), string2);
        }
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setBytes((Integer)list.get(i), byArray);
        }
    }

    public void setDate(String string, Date date) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setDate((Integer)list.get(i), date);
        }
    }

    public void setTime(String string, Time time) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setTime((Integer)list.get(i), time);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setTimestamp((Integer)list.get(i), timestamp);
        }
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setAsciiStream((int)((Integer)list.get(i)), inputStream, n);
        }
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setBinaryStream((int)((Integer)list.get(i)), inputStream, n);
        }
    }

    public void clearParameters() throws SQLException {
        this.wrappedPS.clearParameters();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setObject((int)((Integer)list.get(i)), object, n, n2);
        }
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setObject((int)((Integer)list.get(i)), object, n);
        }
    }

    public void setObject(String string, Object object) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setObject((Integer)list.get(i), object);
        }
    }

    public boolean execute() throws SQLException {
        return this.wrappedPS.execute();
    }

    public void addBatch() throws SQLException {
        this.wrappedPS.addBatch();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setCharacterStream((int)((Integer)list.get(i)), reader, n);
        }
    }

    public void setRef(String string, Ref ref) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setRef((Integer)list.get(i), ref);
        }
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setBlob((int)((Integer)list.get(i)), blob);
        }
    }

    public void setClob(String string, Clob clob) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setClob((int)((Integer)list.get(i)), clob);
        }
    }

    public void setArray(String string, Array array) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setArray((Integer)list.get(i), array);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.wrappedPS.getMetaData();
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setDate((Integer)list.get(i), date, calendar);
        }
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setTime((Integer)list.get(i), time, calendar);
        }
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setTimestamp((Integer)list.get(i), timestamp, calendar);
        }
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setNull((Integer)list.get(i), n, string2);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        List list = this.getIndexes(string);
        for (int i = 0; i < list.size(); ++i) {
            this.wrappedPS.setURL((Integer)list.get(i), uRL);
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.wrappedPS.getParameterMetaData();
    }

    private static class ParseData {
        String parsedQuery;
        Map indexMap;

        private ParseData() {
        }

        public String toString() {
            return "parsedQuery:" + this.parsedQuery + "; indexMap:" + String.valueOf(this.indexMap);
        }
    }
}

