/*
 * Decompiled with CFR 0.152.
 */
package fc.jdbc;

import fc.io.Log;
import fc.jdbc.DBName;
import fc.util.Argcheck;
import fc.util.PropertyMgr;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public abstract class ConnectionMgr {
    protected final Log log;
    String myname = this.getClass().getName();
    private volatile boolean mgrClosed = false;
    protected volatile String catalogName;
    protected String url;
    protected String driver;
    protected String user;
    protected String password;
    protected Driver mydriver;
    protected DBName dbname;

    public ConnectionMgr(String string, String string2, String string3, String string4, String string5) throws Exception {
        this(new PropertyMgrWrapper(string, string2, string3, string4, string5));
    }

    public ConnectionMgr(PropertyMgr propertyMgr) throws Exception {
        this(Log.getDefault(), propertyMgr, null);
    }

    public ConnectionMgr(PropertyMgr propertyMgr, String string) throws Exception {
        this(Log.getDefault(), propertyMgr, string);
    }

    public ConnectionMgr(Log log, PropertyMgr propertyMgr) throws Exception {
        this(log, propertyMgr, null);
    }

    public ConnectionMgr(Log log, PropertyMgr propertyMgr, String string) throws Exception {
        Argcheck.notnull(log);
        Argcheck.notnull(propertyMgr);
        this.log = log;
        this.url = propertyMgr.getRequired((String)(string != null ? string + "jdbc.url" : "jdbc.url"));
        this.driver = propertyMgr.getRequired((String)(string != null ? string + "jdbc.driver" : "jdbc.driver"));
        this.user = propertyMgr.getRequired((String)(string != null ? string + "jdbc.user" : "jdbc.user"));
        this.password = propertyMgr.getRequired((String)(string != null ? string + "jdbc.password" : "jdbc.password"));
        this.catalogName = propertyMgr.get((String)(string != null ? string + "jdbc.catalog" : "jdbc.catalog"));
        Class<?> clazz = Class.forName(this.driver);
        this.mydriver = (Driver)clazz.newInstance();
        DriverManager.registerDriver(this.mydriver);
        this.dbname = DBName.fromDriver(clazz.getName());
        if (this.dbname == null) {
            log.warn("Cannot guess dbname from the driver. Connections will still work perfectly but getDBName() in this class will return null");
        }
        String string2 = System.getProperty("line.separator");
        log.bug("ConnectionMgr constructor; driver=" + this.driver + string2 + "url=" + this.url + string2 + "user=" + this.user + string2 + "password=" + this.password + string2 + "catalog=" + this.catalogName);
    }

    public Driver getDriver() {
        return this.mydriver;
    }

    public DBName getDBName() throws SQLException {
        return this.dbname;
    }

    public void setCatalog(String string) {
        this.catalogName = string;
    }

    public Connection getConnection() throws SQLException {
        if (this.mgrClosed) {
            this.log.warn(this, "tried to get a connection from closed ConnectionMgr");
            throw new SQLException("tried to get a connection from closed ConnectionMgr");
        }
        Connection connection = this.getConImpl();
        if (this.catalogName != null) {
            this.log.bug(this, "setting catalog name to: ", this.catalogName);
            connection.setCatalog(this.catalogName);
        }
        this.log.bug(this, ", returning connection=", connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean close() {
        ConnectionMgr connectionMgr = this;
        synchronized (connectionMgr) {
            this.mgrClosed = true;
            this.log.bug(this, ": closing ConnectionMgr");
            return this.handleMgrShutdown();
        }
    }

    public String getURL() {
        return this.url;
    }

    public String toString() {
        return this.myname;
    }

    protected abstract boolean handleMgrShutdown();

    protected abstract Connection getConImpl() throws SQLException;

    private static class PropertyMgrWrapper
    extends PropertyMgr {
        Map map = new HashMap();

        PropertyMgrWrapper(String string, String string2, String string3, String string4, String string5) {
            this.map.put("jdbc.url", string);
            this.map.put("jdbc.driver", string2);
            this.map.put("jdbc.user", string3);
            this.map.put("jdbc.password", string4);
            this.map.put("jdbc.catalog", string5);
        }

        @Override
        public String get(String string) {
            return (String)this.map.get(string);
        }

        @Override
        public String set(String string, String string2) {
            Log.getDefault().error("not implemented");
            return null;
        }

        @Override
        public void save() {
            Log.getDefault().error("not implemented");
        }
    }
}

