/*
 * Decompiled with CFR 0.152.
 */
package fc.io.fileselectors;

import fc.io.fileselectors.ChainedFileSelector;
import fc.io.fileselectors.NormalFileSelector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class SuffixRejectSelector
extends ChainedFileSelector {
    List matchlist = new ArrayList();

    public SuffixRejectSelector(String string) {
        this(string, null);
    }

    public SuffixRejectSelector(String string, ChainedFileSelector chainedFileSelector) {
        super(chainedFileSelector);
        if (!string.equals("")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.matchlist.add(stringTokenizer.nextToken());
            }
        }
    }

    @Override
    protected boolean thisfilter(File file) {
        String string = file.toString();
        ListIterator listIterator = this.matchlist.listIterator();
        while (listIterator.hasNext()) {
            String string2 = (String)listIterator.next();
            if (!string.endsWith(string2)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        new Test();
    }

    private static class Test {
        Test() throws Exception {
            File file = new File("c:\\temp");
            SuffixRejectSelector suffixRejectSelector = new SuffixRejectSelector(".html", new NormalFileSelector());
            File[] fileArray = file.listFiles(suffixRejectSelector);
            List<File> list = Arrays.asList(fileArray);
            System.out.println("total=" + list.size() + ", files=" + String.valueOf(list));
            suffixRejectSelector = new SuffixRejectSelector("", new NormalFileSelector());
            fileArray = file.listFiles(suffixRejectSelector);
            list = Arrays.asList(fileArray);
            System.out.println("total=" + list.size() + ", files=" + String.valueOf(list));
        }
    }
}

