/*
 * Decompiled with CFR 0.152.
 */
package fc.io.fileselectors;

import fc.io.fileselectors.ChainedFileSelector;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class MaxSizeSelector
extends ChainedFileSelector {
    long filesize;

    public MaxSizeSelector(long l) {
        this(l, null);
    }

    public MaxSizeSelector(long l, ChainedFileSelector chainedFileSelector) {
        super(chainedFileSelector);
        this.filesize = l;
    }

    @Override
    protected boolean thisfilter(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return file.length() <= this.filesize;
    }

    public static void main(String[] stringArray) throws Exception {
        new Test();
    }

    private static class Test {
        Test() throws Exception {
            File file = new File("c:\\temp");
            MaxSizeSelector maxSizeSelector = new MaxSizeSelector(4L);
            File[] fileArray = file.listFiles(maxSizeSelector);
            List<File> list = Arrays.asList(fileArray);
            System.out.println("total=" + list.size() + ", files=" + String.valueOf(list));
        }
    }
}

