/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.io.IOUtil;
import fc.util.Argcheck;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;

public class Prompt {
    BufferedReader in;
    PrintWriter err;
    PrintWriter out;
    protected String line = null;

    public Prompt(Reader reader, PrintWriter printWriter, PrintWriter printWriter2) {
        Argcheck.notnull(reader);
        Argcheck.notnull(printWriter);
        Argcheck.notnull(printWriter2);
        this.in = IOUtil.bufferReader(reader);
        this.out = printWriter;
        this.err = printWriter2;
    }

    public Prompt(InputStream inputStream, PrintStream printStream, PrintStream printStream2) {
        Argcheck.notnull(inputStream);
        Argcheck.notnull(printStream);
        Argcheck.notnull(printStream2);
        this.in = new BufferedReader(new InputStreamReader(inputStream));
        this.out = new PrintWriter(printStream);
        this.err = new PrintWriter(printStream2);
    }

    public Prompt() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public String ask(String string, boolean bl) {
        String string2 = "";
        while (string2.equals("")) {
            this.out.print(string);
            if (bl) {
                this.out.println();
            }
            this.out.flush();
            this.readLine();
            string2 = this.line;
        }
        return string2;
    }

    public String ask(String string) {
        return this.ask(string, false);
    }

    public String ask(String string, String string2, boolean bl) {
        this.out.print(string);
        if (bl) {
            this.out.println();
        }
        this.out.flush();
        this.readLine();
        if (this.line.equals("")) {
            return string2;
        }
        return this.line;
    }

    public String ask(String string, String string2) {
        return this.ask(string, string2, false);
    }

    public void write(String string) {
        this.out.print(string);
        this.out.flush();
    }

    public void writeln(String string) {
        this.out.println(string);
        this.out.flush();
    }

    public String getLastLine() {
        return this.line;
    }

    protected void readLine() {
        try {
            this.line = this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void setInput(Reader reader) {
        this.in = IOUtil.bufferReader(reader);
    }

    public void setInput(InputStream inputStream) {
        this.in = new BufferedReader(new InputStreamReader(inputStream));
    }

    public void setOutput(PrintStream printStream) {
        this.out = new PrintWriter(printStream);
    }

    public void setOutput(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void setError(PrintStream printStream) {
        this.err = new PrintWriter(printStream);
    }

    public void setError(PrintWriter printWriter) {
        this.err = printWriter;
    }

    public static void main(String[] stringArray) throws Exception {
        new Test();
    }

    private static class Test {
        Test() throws Exception {
            Prompt prompt = new Prompt();
            String string = prompt.ask("What is your name ? ");
            System.out.println("You entered: " + string);
            string = prompt.ask("What is your age [default 1] ? ", "1");
            System.out.println("You entered: " + string);
        }
    }
}

