/*
 * Decompiled with CFR 0.152.
 */
package fc.io;

import fc.util.Argcheck;
import fc.util.Args;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IOUtil {
    private static final boolean dbg = false;
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final String PATH_SEP = System.getProperty("path.separator");
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final int FILECOPY_OVERWRITE = 0;
    public static final int FILECOPY_NO_OVERWRITE = 1;
    public static final int DIRCOPY_NO_OVERWRITE = 2;
    public static final int DIRCOPY_ADD_OR_OVERWRITE = 3;
    public static final int DIRCOPY_DELETE_AND_WRITE = 4;
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;
    public static final long FOUR_GB = 0x100000000L;
    private static String defaultEncoding = null;

    public static void beep() {
        System.out.print("\u0007");
        System.out.flush();
    }

    public static boolean copyFile(File file, File file2) throws FileNotFoundException, IOException {
        return IOUtil.copyFile(file, file2, 1);
    }

    public static boolean copyFile(File file, File file2, int n) throws FileNotFoundException, IOException {
        Argcheck.notnull(file, "copyFile(): source file argument is null");
        Argcheck.notnull(file2, "copyFile(): destination file argument is null");
        Argcheck.istrue(n == 0 || n == 1, "copyflag not valid");
        Argcheck.isfalse(file.isDirectory(), "A directory [" + String.valueOf(file) + "] was specified for the source. This method cannot only copy normal files");
        if (file2.isDirectory()) {
            file2 = new File(file2, file.getName());
        }
        if (file2.exists() && n == 1) {
            return false;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        FileChannel fileChannel = fileInputStream.getChannel();
        FileChannel fileChannel2 = fileOutputStream.getChannel();
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        fileChannel2.write(mappedByteBuffer);
        fileChannel.close();
        fileChannel2.close();
        fileInputStream.close();
        fileOutputStream.close();
        return true;
    }

    public static boolean copyDirectory(File file, File file2) throws FileNotFoundException, IOException {
        return IOUtil.copyDirectory(file, file2, 3);
    }

    public static boolean copyDirectory(File file, File file2, int n) throws IOException {
        Argcheck.notnull(file, "copyDirectory(): source file argument is null");
        Argcheck.notnull(file2, "copyDirectory(): destination file argument is null");
        Argcheck.istrue(n == 2 || n == 3 || n == 4, "copyflag not valid");
        if (file.exists()) {
            Argcheck.istrue(file.isDirectory(), "IOUtil.copyDirectory(): A file was specified for the source, need a directory not a file");
        }
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                return false;
            }
            if (n == 2) {
                System.out.println("IOUtil.copyDirectory(): Incompatible flag DIRCOPY_NO_OVERWRITE specified, returning false");
                return false;
            }
            if (n == 4 && !(var3_3 = IOUtil.deepDelete(file2))) {
                throw new IOException("IOUtil.copyDirectory, flag=DIRCOPY_DELETE_AND_WRITE, cannot delete the destination directory:" + String.valueOf(file2));
            }
        } else {
            var3_3 = file2.mkdirs();
            if (!var3_3) {
                return false;
            }
        }
        String[] stringArray = file.list();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            File file3 = new File(file, stringArray[i]);
            File file4 = new File(file2, stringArray[i]);
            bl = file3.isDirectory() ? IOUtil.copyDirectory(file3, file4, n) : IOUtil.copyFile(file3, file4, 0);
            if (bl) continue;
            bl2 = false;
        }
        return bl2;
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = IOUtil.bufferStream(inputStream);
        BufferedOutputStream bufferedOutputStream = IOUtil.bufferStream(outputStream);
        int n = 0;
        while ((n = bufferedInputStream.read()) > -1) {
            bufferedOutputStream.write(n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
    }

    public static void saveStreamToFile(InputStream inputStream, File file) throws IOException {
        IOUtil.copyStream(inputStream, new FileOutputStream(file));
    }

    public static void sortByFileName(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                return this.getStr(object).compareTo(this.getStr(object2));
            }

            private String getStr(Object object) {
                String string = null;
                string = object instanceof File ? ((File)object).getName() : (object instanceof String ? (String)object : (object != null ? object.toString() : null));
                return string;
            }
        });
    }

    public static boolean deepDelete(File file) {
        Argcheck.notnull(file, "File was null");
        boolean bl = true;
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            bl = file.delete();
            return bl;
        }
        File[] fileArray = file.listFiles();
        boolean bl2 = false;
        for (int i = 0; i < fileArray.length; ++i) {
            bl2 = IOUtil.deepDelete(fileArray[i]);
            if (bl2) continue;
            bl = false;
        }
        bl2 = file.delete();
        if (!bl2) {
            bl = false;
        }
        return bl;
    }

    public static long dirSize(File file) {
        Argcheck.notnull(file, "File was null");
        long l = 0L;
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            l += IOUtil.dirSize(fileArray[i]);
        }
        return l;
    }

    public static BufferedInputStream bufferStream(InputStream inputStream) {
        Argcheck.notnull(inputStream, "InputStream was null");
        BufferedInputStream bufferedInputStream = !(inputStream instanceof BufferedInputStream) ? new BufferedInputStream(inputStream) : (BufferedInputStream)inputStream;
        return bufferedInputStream;
    }

    public static BufferedOutputStream bufferStream(OutputStream outputStream) {
        Argcheck.notnull(outputStream, "OutputStream was null");
        BufferedOutputStream bufferedOutputStream = !(outputStream instanceof BufferedOutputStream) ? new BufferedOutputStream(outputStream) : (BufferedOutputStream)outputStream;
        return bufferedOutputStream;
    }

    public static BufferedReader bufferReader(Reader reader) {
        Argcheck.notnull(reader, "Reader was null");
        BufferedReader bufferedReader = !(reader instanceof BufferedReader) ? new BufferedReader(reader) : (BufferedReader)reader;
        return bufferedReader;
    }

    public static PrintStream toPrintStream(OutputStream outputStream) {
        Argcheck.notnull(outputStream, "OutputStream was null");
        if (!(outputStream instanceof PrintStream)) {
            outputStream = new PrintStream(outputStream);
        }
        return (PrintStream)outputStream;
    }

    public static PrintWriter toPrintWriter(Writer writer) {
        Argcheck.notnull(writer, "Writer was null");
        if (!(writer instanceof PrintWriter)) {
            writer = new PrintWriter(writer);
        }
        return (PrintWriter)writer;
    }

    public static BufferedWriter bufferWriter(Writer writer) {
        Argcheck.notnull(writer, "Writer was null");
        BufferedWriter bufferedWriter = !(writer instanceof BufferedWriter) ? new BufferedWriter(writer) : (BufferedWriter)writer;
        return bufferedWriter;
    }

    public static String propertiesToString(Properties properties) {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        properties.list(printStream);
        printStream.flush();
        string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static String getDefaultEncoding() {
        if (defaultEncoding != null) {
            return defaultEncoding;
        }
        String string = null;
        try {
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("fc/io/IOUtil.class");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            defaultEncoding = string = inputStreamReader.getEncoding();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public static List fileToLines(InputStream inputStream, boolean bl, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        Pattern pattern = null;
        Matcher matcher = null;
        if (string != null) {
            pattern = Pattern.compile("^[ \\t]*(" + string + ")+");
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            if (bl && (string2 = string2.trim()).length() == 0 || pattern != null && (matcher = pattern.matcher(string2)).find()) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static List fileToLines(File file, boolean bl, String string) throws IOException {
        return IOUtil.fileToLines(new FileInputStream(file), bl, string);
    }

    public static List fileToLines(File file) throws IOException {
        return IOUtil.fileToLines(file, true, "#|//");
    }

    public static List fileToLines(String string) throws IOException {
        return IOUtil.fileToLines(new File(string));
    }

    public static List fileToLines(InputStream inputStream) throws IOException {
        return IOUtil.fileToLines(inputStream, true, "#|//");
    }

    public static String fileToString(File file, boolean bl) throws IOException {
        byte[] byArray = IOUtil.fileToByteArray(file);
        if (byArray == null) {
            return null;
        }
        String string = IOUtil.arrayToCharBuffer(byArray).toString();
        if (bl) {
            string = string.trim();
        }
        return string;
    }

    public static String fileToString(String string, boolean bl) throws IOException {
        return IOUtil.fileToString(new File(string), bl);
    }

    public static String fileToString(String string) throws IOException {
        return IOUtil.fileToString(string, false);
    }

    public static String fileToString(File file) throws IOException {
        return IOUtil.fileToString(file, false);
    }

    public static byte[] fileToByteArray(String string) throws IOException {
        return IOUtil.fileToByteArray(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fileToByteArray(File file) throws IOException {
        Argcheck.notnull(file);
        if (!file.exists()) {
            return null;
        }
        long l = file.length();
        if (l > 0x100000000L) {
            throw new IOException("File size of " + l + " too large for this method");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = (int)l;
        byte[] byArray = new byte[n];
        try {
            int n2;
            int n3;
            for (n2 = 0; n2 < n; n2 += n3) {
                n3 = fileInputStream.read(byArray, n2, n - n2);
                if (n3 >= 0) continue;
            }
            if (n2 != n) {
                throw new IOException("Can't read entire file, filesize = " + n + ", read = " + n2);
            }
        }
        finally {
            fileInputStream.close();
        }
        return byArray;
    }

    public static ByteBuffer fileToByteBuffer(File file) throws IOException {
        Argcheck.notnull(file);
        long l = 0L;
        if (!file.exists()) {
            return null;
        }
        l = file.length();
        if (l > 0x100000000L) {
            throw new IOException("File size of " + file.length() + " too large for this method");
        }
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        Object var4_3 = null;
        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
        ((ByteBuffer)mappedByteBuffer).rewind();
        return mappedByteBuffer;
    }

    public static char[] fileToCharArray(File file, String string) throws IOException {
        Argcheck.notnull(file);
        if (!file.exists()) {
            return null;
        }
        long l = file.length();
        if (l > 0x100000000L) {
            throw new IOException("File size of " + l + " too large for this method");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        if (string == null) {
            string = "UTF-8";
        }
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string);
        int n = (int)l;
        char[] cArray = IOUtil.readerToCharArray(inputStreamReader, n);
        return cArray;
    }

    public static char[] readerToCharArray(Reader reader) throws IOException {
        Argcheck.notnull(reader);
        return IOUtil.readerToCharArray(reader, 1024);
    }

    public static char[] readerToCharArray(Reader reader, int n) throws IOException {
        Argcheck.notnull(reader);
        char[] cArray = new char[n];
        CharArrayWriter charArrayWriter = new CharArrayWriter(n);
        int n2 = 0;
        while ((n2 = reader.read(cArray, 0, n)) != -1) {
            charArrayWriter.write(cArray, 0, n2);
        }
        return charArrayWriter.toCharArray();
    }

    public static CharBuffer arrayToCharBuffer(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            return null;
        }
        Charset charset = Charset.forName(string);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(byArray));
        return charBuffer;
    }

    public static CharBuffer arrayToCharBuffer(byte[] byArray) {
        return IOUtil.arrayToCharBuffer(byArray, "UTF-8");
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream, boolean bl) throws IOException {
        Argcheck.notnull(inputStream, "InputStream was null");
        BufferedInputStream bufferedInputStream = IOUtil.bufferStream(inputStream);
        if (!bl) {
            int n = bufferedInputStream.available();
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; i += bufferedInputStream.read(byArray, n2, n - i)) {
                n2 = i + 1;
            }
            return byArray;
        }
        int n = 1024;
        byte[] byArray = new byte[n];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        int n3 = 0;
        while ((n3 = bufferedInputStream.read(byArray, 0, n)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        if (byteArrayOutputStream.size() == 0) {
            return null;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        return IOUtil.inputStreamToByteArray(inputStream, true);
    }

    public static String inputStreamToString(InputStream inputStream, boolean bl) throws IOException {
        byte[] byArray = IOUtil.inputStreamToByteArray(inputStream, bl);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, "UTF-8");
    }

    public static String inputStreamToString(InputStream inputStream, String string) throws IOException {
        byte[] byArray = IOUtil.inputStreamToByteArray(inputStream, true);
        if (byArray == null) {
            return null;
        }
        return new String(byArray, string);
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        return IOUtil.inputStreamToString(inputStream, true);
    }

    public static String throwableToString(Throwable throwable) {
        Argcheck.notnull(throwable, "The specified exception object was null");
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(768);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        throwable.printStackTrace(printStream);
        printStream.flush();
        string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static String stackTrace() {
        String string = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(768);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.println("==================== Debug Stack Trace ======================");
        new Exception().printStackTrace(printStream);
        printStream.println("=============================================================");
        printStream.flush();
        string = byteArrayOutputStream.toString();
        printStream.close();
        return string;
    }

    public static String fileSizeToString(long l, int n) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(n);
        return IOUtil.fileSizeToStringImpl(numberFormat, l);
    }

    public static String fileSizeToString(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        return IOUtil.fileSizeToStringImpl(numberFormat, l);
    }

    private static final String fileSizeToStringImpl(NumberFormat numberFormat, long l) {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (l > 0x40000000L) {
            stringBuffer.append(numberFormat.format(l / 0x40000000L)).append(" GB");
        } else if (l > 0x100000L) {
            stringBuffer.append(numberFormat.format(l / 0x100000L)).append(" MB");
        } else if (l > 1024L) {
            stringBuffer.append(numberFormat.format(l / 1024L)).append(" KB");
        } else {
            stringBuffer.append(numberFormat.format(l)).append(" bytes");
        }
        return stringBuffer.toString();
    }

    public static long stringToFileSize(String string) {
        Argcheck.notnull(string, "the specified string was null");
        string = string.replace(" ", "");
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case 'G': 
                case 'g': {
                    return Long.parseLong(string.substring(0, i)) * 0x40000000L;
                }
                case 'M': 
                case 'm': {
                    return Long.parseLong(string.substring(0, i)) * 0x100000L;
                }
                case 'K': 
                case 'k': {
                    return Long.parseLong(string.substring(0, i)) * 1024L;
                }
                case 'B': 
                case 'b': {
                    return Long.parseLong(string.substring(0, i));
                }
            }
        }
        return Long.parseLong(string);
    }

    public static final String sha1hash(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] byArray2 = messageDigest.digest(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray2) {
            String string = Integer.toHexString(0xFF & by);
            if (string.length() == 1) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static InputStream getClassResource(Class clazz, String string) throws IOException {
        if (clazz == null) {
            return null;
        }
        if (string.startsWith("/")) {
            string = string.substring(1, string.length());
        }
        InputStream inputStream = clazz.getResourceAsStream(string);
        return inputStream;
    }

    public static void main(String[] stringArray) throws Exception {
        Args args = new Args(stringArray);
        String string = args.getRequired("file");
        new Test(string);
    }

    private static class Test {
        Test(String string) throws Exception {
            File file = new File("testsourcefile");
            File file2 = new File("testsourcedir");
            File file3 = new File("testdestfile");
            File file4 = new File("testdestdir");
            String string2 = "foo";
            String string3 = "foo" + FILE_SEP;
            String string4 = "f1";
            for (long i = 2L; i < 4000000001L; i *= 1000L) {
                System.out.println("file size " + i + " = " + IOUtil.fileSizeToString(i));
            }
            System.out.println("Platform encoding, via file.encoding: " + System.getProperty("file.encoding"));
            System.out.println("Platform encoding: " + IOUtil.getDefaultEncoding());
            System.out.println("--- fileToString('" + string + "') -----");
            String string5 = IOUtil.fileToString(string);
            System.out.println("file '" + string + "' read into String");
            System.out.println("String length = " + string5.length());
            System.out.println("String data = ");
            System.out.println(string5);
            List list = IOUtil.fileToLines(new File(string));
            System.out.println("--- fileToList('" + string + "') -----");
            for (int i = 0; i < list.size(); ++i) {
                System.out.println("[line:" + i + "]: " + String.valueOf(list.get(i)));
            }
            FileInputStream fileInputStream = new FileInputStream(string);
            System.out.println("--- inputStreamToString('" + string + "') -----");
            String string6 = IOUtil.inputStreamToString((InputStream)fileInputStream, false);
            System.out.println(string6);
            System.out.println(string + ", size=" + string6.length());
            Socket socket = new Socket("www.yahoo.com", 80);
            System.out.println("--- inputStreamToString('" + String.valueOf(socket) + "') -----");
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            outputStream.write("GET /index.html\n\n".getBytes());
            outputStream.flush();
            System.out.println(IOUtil.inputStreamToString(inputStream, true));
            Object object = new Object();
            System.out.println("--- getClassResource('" + String.valueOf(object.getClass()) + ", 'String.class') -----");
            System.out.println(IOUtil.getClassResource(object.getClass(), "String"));
            System.out.println("--- getClassResource('" + String.valueOf(IOUtil.class) + ", 'Args.class') -----");
            System.out.println(IOUtil.inputStreamToString(IOUtil.getClassResource(IOUtil.class, "compile.sh")));
            this.copyFileTest();
        }

        void copyFileTest() throws IOException {
            File file = new File("/tmp/foo");
            File file2 = new File("/tmp/bar");
            System.out.println("Copy test: " + String.valueOf(file) + " to " + String.valueOf(file2));
            IOUtil.copyDirectory(file, file2);
        }
    }
}

